/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.dormitorysystem.application.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.ICheckInApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.IRoomChangeApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.dormitory.DormitoryInfo;
import com.kingdee.eas.custom.dormitorysystem.enumerationset.DormitoryClassification;
import com.kingdee.eas.custom.dormitorysystem.occupants.IOccupants;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsCollection;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsFactory;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsInfo;
import com.kingdee.eas.custom.dormitorysystem.otherbasicdata.DormitoryTypeInfo;
import com.kingdee.eas.custom.dormitorysystem.otherbasicdata.PersonDormitoryTypeInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ValidateRoomAvailableByBillIdsUtil {
    private static Logger logger = Logger.getLogger(ValidateRoomAvailableByBillIdsUtil.class);
    private static String CHECKOUTAPPLICATIONBOSTYPE = "EBE6D24D";
    private static String ROOMCHANGEAPPLICATIONBOSTYPE = "0CDEF948";
    private static String CHECKINAPPLICATIONBOSTYPE = "412D7440";

    public static void startValidate(Context ctx, String billIds) throws BOSException {
        if (StringUtils.isEmpty((String)billIds)) {
            logger.error((Object)"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!");
            throw new BOSException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap roomListMap = new HashMap();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        BOSObjectType bosType = BOSUuid.read((String)billIds.split(",")[0]).getType();
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.person.*");
        sic.add("entrys.person.personType.*");
        if (CHECKOUTAPPLICATIONBOSTYPE.equals(CHECKOUTAPPLICATIONBOSTYPE)) {
            sic.add("entrys.currentRoom.DormitoryType.*");
            sic.add("entrys.currentRoom.*");
        } else if (CHECKINAPPLICATIONBOSTYPE.equals(CHECKINAPPLICATIONBOSTYPE)) {
            sic.add("entrys.checkInRoom.DormitoryType.*");
            sic.add("entrys.checkInRoom.*");
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("id", (Object)AtsUtil.toSet((String)billIds), CompareType.INCLUDE));
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        CoreBillBaseCollection hrBillBaseCollection = iCoreBillBase.getCoreBillBaseCollection(viewInfo);
        for (int i = 0; i < hrBillBaseCollection.size(); ++i) {
            HRBillBaseInfo hrBillBaseInfo = (HRBillBaseInfo)hrBillBaseCollection.get(i);
            String billId = hrBillBaseInfo.getId().toString();
            String baseInfoNumber = hrBillBaseInfo.getNumber();
            AbstractObjectCollection entrys = (AbstractObjectCollection)hrBillBaseInfo.get("entrys");
            for (int j = 0; j < entrys.size(); ++j) {
                try {
                    HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(j);
                    Date checkInDate = null;
                    checkInDate = "B371AC0A".equals(bosType) ? entryInfo.getDate("adjustmentDate") : entryInfo.getDate("checkInDate");
                    if (checkInDate == null) {
                        throw new BOSException("\u5165\u4f4f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    Date checkoutDate = null;
                    if (CHECKOUTAPPLICATIONBOSTYPE.equals(bosType)) {
                        checkInDate = entryInfo.getDate("oldCheckoutDate");
                    } else {
                        checkoutDate = entryInfo.getDate("checkoutDate");
                    }
                    if (checkoutDate == null) {
                        throw new BOSException("\u9000\u5bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    PersonInfo personInfo = (PersonInfo)entryInfo.getObjectValue("person");
                    if (personInfo == null) {
                        throw new BOSException("\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    DormitoryInfo dormitory = null;
                    dormitory = CHECKOUTAPPLICATIONBOSTYPE.equals(bosType) ? (DormitoryInfo)entryInfo.getObjectValue("currentRoom") : (DormitoryInfo)entryInfo.getObjectValue("checkInRoom");
                    if (dormitory == null) {
                        throw new BOSException("\u623f\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    String roomId = dormitory.getId().toString();
                    PersonDormitoryTypeInfo personType = (PersonDormitoryTypeInfo)personInfo.get("personType");
                    if (personType == null) {
                        throw new BOSException("\u5458\u5de5[" + personInfo.getName() + "]\u7684\u4eba\u5458\u7c7b\u522b\u4e3a\u7a7a\uff0c\u8bf7\u53ca\u65f6\u7ef4\u62a4\uff01");
                    }
                    int dormCheckInCount = 0;
                    HashSet<String> occupantsIds = new HashSet<String>();
                    ValidateRoomAvailableByBillIdsUtil.validateDormitoryInfo(ctx, personInfo, dormitory);
                    int occupancyCapacity = dormitory.getOccupancyCapacity();
                    dormCheckInCount += ValidateRoomAvailableByBillIdsUtil.getCheckInInfoByOccupants(ctx, checkInDate, checkoutDate, roomId, personType, occupantsIds);
                    dormCheckInCount += ValidateRoomAvailableByBillIdsUtil.getCheckInInfoByCheckInApplication(ctx, checkInDate, checkoutDate, roomId, personType, billId);
                    dormCheckInCount += ValidateRoomAvailableByBillIdsUtil.getRoomChangeInfoByRoomChangeApplication(ctx, checkInDate, checkoutDate, roomId, personType, billId);
                    if (roomListMap.containsKey(roomId)) {
                        List roomMapList = (List)roomListMap.get(roomId);
                        for (int k = 0; k < roomMapList.size(); ++k) {
                            Map roomMap = (Map)roomMapList.get(k);
                            java.util.Date checkInDateOld = (java.util.Date)roomMap.get("checkInDate");
                            java.util.Date checkoutDateOld = (java.util.Date)roomMap.get("checkoutDate");
                            if ((checkInDateOld.compareTo(checkInDate) > 0 || checkoutDateOld.compareTo(checkInDate) < 0) && (checkInDateOld.compareTo(checkInDate) < 0 || checkInDateOld.compareTo(checkoutDate) > 0)) continue;
                            ++dormCheckInCount;
                        }
                    }
                    if (occupancyCapacity - ++dormCheckInCount < 0) {
                        String dormitoryName = dormitory.getName();
                        throw new BOSException("\u5f53\u524d\u5165\u4f4f\u4eba\u6570" + dormCheckInCount + "\uff0c\u5df2\u8d85\u8fc7\u623f\u95f4[" + dormitoryName + "]\u53ef\u4f4f\u4eba\u6570" + occupancyCapacity + "\uff0c\u4e0d\u80fd\u5165\u4f4f!");
                    }
                    HashMap<String, Date> roomMap = new HashMap<String, Date>();
                    roomMap.put("checkInDate", checkInDate);
                    roomMap.put("checkoutDate", checkoutDate);
                    if (roomListMap.containsKey(roomId)) {
                        ((List)roomListMap.get(roomId)).add(roomMap);
                        continue;
                    }
                    ArrayList<HashMap<String, Date>> list = new ArrayList<HashMap<String, Date>>();
                    roomListMap.put(roomId, list);
                    list.add(roomMap);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("\u5355\u636e\u7f16\u53f7\u4e3a" + baseInfoNumber + "\u6821\u9a8c\u672a\u901a\u8fc7: " + e.getMessage()), (Throwable)e);
                    errorMsgList.add("\u5355\u636e\u7f16\u53f7\u4e3a" + baseInfoNumber + "\u6821\u9a8c\u672a\u901a\u8fc7: " + e.getMessage());
                }
            }
        }
        if (!errorMsgList.isEmpty()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            for (String errorMsg : errorMsgList) {
                errorMsgBuilder.append(errorMsg).append("\n");
            }
            throw new BOSException(errorMsgBuilder.toString());
        }
    }

    private static int getRoomChangeInfoByRoomChangeApplication(Context ctx, java.util.Date checkInDate, java.util.Date checkoutDate, String roomId, PersonDormitoryTypeInfo personType, String billId) throws BOSException {
        IRoomChangeApplicationEntry iRoomChangeApplicationEntry = RoomChangeApplicationEntryFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("adjustRoom", (Object)roomId));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("checkoutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkoutDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("parent.billState", (Object)"1,2", CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("parent.id", (Object)billId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) and #5  and #6");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("checkInRoom.id");
        sic.add("person.personType.id");
        sic.add("person.personType.name");
        sic.add("occupants.id");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        RoomChangeApplicationEntryCollection roomChangeApplicationEntryCol = iRoomChangeApplicationEntry.getRoomChangeApplicationEntryCollection(viewInfo);
        String personTypeId = personType.getId().toString();
        String personTypeName = personType.getName();
        int dormCheckInCount = 0;
        for (int i = 0; i < roomChangeApplicationEntryCol.size(); ++i) {
            RoomChangeApplicationEntryInfo roomChangeApplicationEntryInfo = roomChangeApplicationEntryCol.get(i);
            PersonInfo person = roomChangeApplicationEntryInfo.getPerson();
            String personName = person.getName();
            PersonDormitoryTypeInfo personDormitoryType = (PersonDormitoryTypeInfo)person.get("personType");
            if (personDormitoryType == null) {
                throw new BOSException("\u5458\u5de5[" + personName + "]\u7684\u4eba\u5458\u7c7b\u522b\u4e3a\u7a7a\uff0c\u8bf7\u53ca\u65f6\u7ef4\u62a4\uff01");
            }
            String personDormitoryTypeId = personDormitoryType.getId().toString();
            String personDormitoryTypeName = personDormitoryType.getName();
            if (!personTypeId.equals(personDormitoryTypeId)) {
                throw new BOSException("\u4eba\u5458\u7c7b\u522b[" + personTypeName + "]\u4e0e\u5bbf\u820d\u7c7b\u578b[" + personDormitoryTypeName + "]\u4e0d\u7b26\uff0c\u4e0d\u80fd\u5165\u4f4f\uff01");
            }
            ++dormCheckInCount;
        }
        return dormCheckInCount;
    }

    private static int getCheckInInfoByCheckInApplication(Context ctx, java.util.Date checkInDate, java.util.Date checkoutDate, String roomId, PersonDormitoryTypeInfo personType, String billId) throws BOSException {
        ICheckInApplicationEntry iCheckInApplicationEntry = CheckInApplicationEntryFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("checkInRoom", (Object)roomId));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("checkoutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkoutDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("parent.billState", (Object)"1,2", CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("parent.id", (Object)billId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) and #5 and #6");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("checkInRoom.id");
        sic.add("person.personType.id");
        sic.add("person.personType.name");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        CheckInApplicationEntryCollection checkInApplicationEntryCol = iCheckInApplicationEntry.getCheckInApplicationEntryCollection(viewInfo);
        String personTypeId = personType.getId().toString();
        String personTypeName = personType.getName();
        int dormCheckInCount = 0;
        for (int i = 0; i < checkInApplicationEntryCol.size(); ++i) {
            CheckInApplicationEntryInfo checkInApplicationEntryInfo = checkInApplicationEntryCol.get(i);
            PersonInfo person = checkInApplicationEntryInfo.getPerson();
            String personName = person.getName();
            PersonDormitoryTypeInfo personDormitoryType = (PersonDormitoryTypeInfo)person.get("personType");
            if (personDormitoryType == null) {
                throw new BOSException("\u5458\u5de5[" + personName + "]\u7684\u4eba\u5458\u7c7b\u522b\u4e3a\u7a7a\uff0c\u8bf7\u53ca\u65f6\u7ef4\u62a4\uff01");
            }
            String personDormitoryTypeId = personDormitoryType.getId().toString();
            String personDormitoryTypeName = personDormitoryType.getName();
            if (!personTypeId.equals(personDormitoryTypeId)) {
                throw new BOSException("\u4eba\u5458\u7c7b\u522b[" + personTypeName + "]\u4e0e\u5bbf\u820d\u7c7b\u578b[" + personDormitoryTypeName + "]\u4e0d\u7b26\uff0c\u4e0d\u80fd\u5165\u4f4f\uff01");
            }
            ++dormCheckInCount;
        }
        return dormCheckInCount;
    }

    protected static int getCheckInInfoByOccupants(Context ctx, java.util.Date checkInDate, java.util.Date checkoutDate, String roomId, PersonDormitoryTypeInfo personType, Set<String> occupantsIds) throws BOSException {
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("Dormitory", (Object)roomId));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("checkoutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkoutDate, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) ");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("PersonDormitoryType.id");
        sic.add("PersonDormitoryType.name");
        sic.add("id");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        OccupantsCollection occupantsCollection = iOccupants.getOccupantsCollection(viewInfo);
        String personTypeId = personType.getId().toString();
        String personTypeName = personType.getName();
        int dormCheckInCount = 0;
        String personDormitoryTypeId = null;
        for (int i = 0; i < occupantsCollection.size(); ++i) {
            OccupantsInfo occupantsInfo = occupantsCollection.get(i);
            PersonDormitoryTypeInfo personDormitoryType = occupantsInfo.getPersonDormitoryType();
            personDormitoryTypeId = personDormitoryType.getId().toString();
            String personDormitoryTypeName = personDormitoryType.getName();
            if (!personTypeId.equals(personDormitoryTypeId)) {
                throw new BOSException("\u4eba\u5458\u7c7b\u522b[" + personTypeName + "]\u4e0e\u5bbf\u820d\u7c7b\u578b[" + personDormitoryTypeName + "]\u4e0d\u7b26\uff0c\u4e0d\u80fd\u5165\u4f4f\uff01");
            }
            occupantsIds.add(occupantsInfo.getId().toString());
            ++dormCheckInCount;
        }
        return dormCheckInCount;
    }

    protected static void validateDormitoryInfo(Context ctx, PersonInfo personInfo, DormitoryInfo dormitory) throws BOSException, EASBizException {
        Genders gender = personInfo.getGender();
        if (gender == null) {
            throw new BOSException("\u5458\u5de5\u6027\u522b\u4e3a\u7a7a!");
        }
        String personInfoName = personInfo.getName();
        String dormitoryName = dormitory.getName();
        DormitoryClassification roomClassification = dormitory.getRoomClassification();
        if (!DormitoryClassification.ROOM.equals((Object)roomClassification)) {
            String classificationAlias = roomClassification.getAlias();
            throw new BOSException("\u623f\u95f4[" + dormitoryName + "]\u623f\u95f4\u5f52\u7c7b\u4e3a" + classificationAlias + "\uff0c\u4e0d\u80fd\u5165\u4f4f!");
        }
        BasicItemStateEnum dormitoryInfoState = dormitory.getState();
        if (BasicItemStateEnum.DISABLE.equals((Object)dormitoryInfoState)) {
            throw new BOSException("\u623f\u95f4[" + dormitoryName + "]\u672a\u542f\u7528\uff0c\u4e0d\u80fd\u5165\u4f4f!");
        }
        DormitoryTypeInfo dormitoryType = dormitory.getDormitoryType();
        Genders roomGender = dormitoryType.getGender();
        if (roomGender != null && gender.getValue() != roomGender.getValue()) {
            String dormitoryTypeName = dormitoryType.getName();
            throw new BOSException("\u623f\u95f4[" + dormitoryName + "]\u5bbf\u820d\u7c7b\u578b\u4e3a" + dormitoryTypeName + "\uff0c\u4e0e\u4eba\u5458[" + personInfoName + "]\u7684\u6027\u522b\u4e0d\u7b26!");
        }
    }
}

