/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.dormitorysystem.application.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationInfo;
import com.kingdee.eas.custom.dormitorysystem.application.ICheckoutApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.IRoomChangeApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.app.AbstractCheckoutApplicationControllerBean;
import com.kingdee.eas.custom.dormitorysystem.application.utils.ValidateRoomAvailableByBillIdsUtil;
import com.kingdee.eas.custom.dormitorysystem.dormitory.DormitoryInfo;
import com.kingdee.eas.custom.dormitorysystem.occupants.IOccupants;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsCollection;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsFactory;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CheckoutApplicationControllerBean
extends AbstractCheckoutApplicationControllerBean {
    private static Logger logger = Logger.getLogger(CheckoutApplicationControllerBean.class);

    @Override
    protected boolean _validateBillInProcess(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        boolean isError = super._validateBillInProcess(ctx, billID);
        if (!isError) {
            if (billID == null) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!"});
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("entrys.*");
            sic.add("entrys.occupants.*");
            CheckoutApplicationInfo info = this.getCheckoutApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), sic);
            try {
                HRBillStateEnum billState = info.getBillState();
                if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
                    throw new BOSException("\u5355\u636e\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
                }
                IRoomChangeApplicationEntry iRoomChangeApplicationEntry = RoomChangeApplicationEntryFactory.getLocalInstance((Context)ctx);
                CheckoutApplicationEntryCollection entrys = info.getEntrys();
                for (int i = 0; i < entrys.size(); ++i) {
                    CheckoutApplicationEntryInfo entryInfo = entrys.get(i);
                    OccupantsInfo occupants = entryInfo.getOccupants();
                    if (occupants == null) {
                        throw new BOSException("\u5165\u4f4f\u4fe1\u606f\u4e3a\u7a7a!");
                    }
                    String personName = entryInfo.getPerson().getName();
                    RoomChangeApplicationEntryCollection roomChangeApplicationEntryCollection = iRoomChangeApplicationEntry.getRoomChangeApplicationEntryCollection("select parent.number where oldOccupants = '" + occupants.getId() + "'");
                    if (roomChangeApplicationEntryCollection.size() <= 0) continue;
                    RoomChangeApplicationEntryInfo roomChangeApplicationEntryInfo = roomChangeApplicationEntryCollection.get(0);
                    String number = roomChangeApplicationEntryInfo.getParent().getNumber();
                    throw new BOSException("\u5458\u5de5 " + personName + "\u5df2\u6709\u6362\u5bbf\u5355[ " + number + " ]\uff0c\u4e0d\u80fd\u63d0\u4ea4\u751f\u6548\uff01\n");
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                SelectorItemCollection updateSic = new SelectorItemCollection();
                sic.add("errorMsg");
                info.setErrorMsg(e.getMessage());
                this.updatePartial(ctx, (CoreBaseInfo)info, updateSic);
                return true;
            }
        }
        return isError;
    }

    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
        CheckoutApplicationInfo info = this.getCheckoutApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("errorMsg");
        info.setErrorMsg(null);
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditing(ctx, billID);
        CheckoutApplicationInfo info = this.getCheckoutApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("errorMsg");
        info.setErrorMsg(null);
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("entrys.*");
        sic.add("entrys.occupants.*");
        CheckoutApplicationInfo info = this.getCheckoutApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), sic);
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection updateCols = new CoreBaseCollection();
        CheckoutApplicationEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            CheckoutApplicationEntryInfo entryInfo = entrys.get(i);
            Date checkoutDate = entryInfo.getCheckoutDate();
            OccupantsInfo occupants = entryInfo.getOccupants();
            occupants.setCheckOutDate(checkoutDate);
            updateCols.add((CoreBaseInfo)occupants);
        }
        iOccupants.updateBatchData(updateCols);
        super._setAudited(ctx, billID);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckoutApplicationInfo info = (CheckoutApplicationInfo)model;
        CheckoutApplicationEntryCollection entrys = info.getEntrys();
        HashSet<String> occupantsIds = new HashSet<String>();
        ICheckoutApplicationEntry iCheckoutApplicationEntry = CheckoutApplicationEntryFactory.getLocalInstance(ctx);
        for (int i = 0; i < entrys.size(); ++i) {
            CheckoutApplicationEntryInfo checkoutApplicationEntryInfo = entrys.get(i);
            BOSUuid id = checkoutApplicationEntryInfo.getId();
            OccupantsInfo occupants = checkoutApplicationEntryInfo.getOccupants();
            if (occupants == null) {
                throw new BOSException("\u5165\u4f4f\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String occupantsId = occupants.getId().toString();
            if (occupantsIds.contains(occupantsId)) {
                throw new BOSException("\u672c\u5355\u636e\u4e2d\u5b58\u5728\u5bf9\u76f8\u540c\u5165\u4f4f\u4fe1\u606f\u505a\u9000\u5bbf\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u4fe1\u606f\uff01");
            }
            occupantsIds.add(occupantsId);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("occupants", (Object)occupantsId));
            if (id != null) {
                filterItems.add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("person.name");
            sic.add("occupants.number");
            sic.add("parent.number");
            EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
            CheckoutApplicationEntryCollection checkoutApplicationEntryCol = iCheckoutApplicationEntry.getCheckoutApplicationEntryCollection(viewInfo);
            int j = 0;
            if (j >= checkoutApplicationEntryCol.size()) continue;
            CheckoutApplicationEntryInfo checkoutApplicationEntry = checkoutApplicationEntryCol.get(j);
            String personName = checkoutApplicationEntry.getPerson().getName();
            String occupantsNumber = checkoutApplicationEntry.getOccupants().getNumber();
            String number = checkoutApplicationEntry.getParent().getNumber();
            throw new BOSException(personName + "\u7684\u5165\u4f4f\u4fe1\u606f[" + occupantsNumber + "]\u5df2\u7ecf\u5728\u9000\u5bbf\u5355[" + number + "]\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u9000\u5bbf\u5355\uff01");
        }
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)this._getValue(ctx, pk);
        HRBillStateEnum billState = info.getBillState();
        boolean isRemovable = true;
        if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITED.equals((Object)billState)) {
            isRemovable = false;
        }
        if (!isRemovable) {
            throw new AffairBizException(AffairBizException.BILLCANTDELETE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billId)) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.occupants.*");
        CheckoutApplicationInfo info = this.getCheckoutApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        HRBillStateEnum billState = info.getBillState();
        if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5355\u636e\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01"});
        }
        IRoomChangeApplicationEntry iRoomChangeApplicationEntry = RoomChangeApplicationEntryFactory.getLocalInstance((Context)ctx);
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection updateCols = new CoreBaseCollection();
        CheckoutApplicationEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            CheckoutApplicationEntryInfo entryInfo = entrys.get(i);
            Date checkoutDate = entryInfo.getCheckoutDate();
            OccupantsInfo occupants = entryInfo.getOccupants();
            if (occupants == null) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5165\u4f4f\u4fe1\u606f\u4e3a\u7a7a!"});
            }
            String personName = entryInfo.getPerson().getName();
            RoomChangeApplicationEntryCollection roomChangeApplicationEntryCollection = iRoomChangeApplicationEntry.getRoomChangeApplicationEntryCollection("select parent.number where oldOccupants = '" + occupants.getId() + "'");
            if (roomChangeApplicationEntryCollection.size() > 0) {
                RoomChangeApplicationEntryInfo roomChangeApplicationEntryInfo = roomChangeApplicationEntryCollection.get(0);
                String number = roomChangeApplicationEntryInfo.getParent().getNumber();
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5458\u5de5 " + personName + "\u5df2\u6709\u6362\u5bbf\u5355[ " + number + " ]\uff0c\u4e0d\u80fd\u63d0\u4ea4\u751f\u6548\uff01\n"});
            }
            occupants.setCheckOutDate(checkoutDate);
            updateCols.add((CoreBaseInfo)occupants);
        }
        iOccupants.updateBatchData(updateCols);
        IObjectPK iObjectPK = super._submitEffect(ctx, (CoreBaseInfo)info);
        return iObjectPK;
    }

    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String billId = model.getId().toString();
        return this._submitEffect(ctx, billId);
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.person.*");
        sic.add("entrys.occupants.*");
        sic.add("entrys.currentRoom.*");
        CheckoutApplicationInfo info = this.getCheckoutApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        HRBillStateEnum billState = info.getBillState();
        if (!HRBillStateEnum.AUDITED.equals((Object)billState)) {
            throw new AffairBizException(HRBaseException.BILLSTATECANUNCHECK);
        }
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        CheckoutApplicationEntryCollection entrys = info.getEntrys();
        CoreBaseCollection updateCols = new CoreBaseCollection();
        for (int i = 0; i < entrys.size(); ++i) {
            CheckoutApplicationEntryInfo entryInfo = entrys.get(i);
            PersonInfo person = entryInfo.getPerson();
            String personId = person.getId().toString();
            Date checkInDate = entryInfo.getCheckInDate();
            if (checkInDate == null) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5165\u4f4f\u65e5\u671f\u4e3a\u7a7a!"});
            }
            Date oldCheckoutDate = entryInfo.getOldCheckoutDate();
            if (oldCheckoutDate == null) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u539f\u9000\u5bbf\u65e5\u671f\u4e3a\u7a7a!"});
            }
            OccupantsInfo occupants = entryInfo.getOccupants();
            if (occupants == null) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5165\u4f4f\u4fe1\u606f\u4e3a\u7a7a!"});
            }
            DormitoryInfo currentRoom = entryInfo.getCurrentRoom();
            if (currentRoom == null) {
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u73b0\u4f4f\u623f\u95f4\u4e3a\u7a7a!"});
            }
            String roomId = currentRoom.getId().toString();
            try {
                ValidateRoomAvailableByBillIdsUtil.startValidate(ctx, billId);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{e.getMessage()});
            }
            occupants.setCheckOutDate(oldCheckoutDate);
            updateCols.add((CoreBaseInfo)occupants);
        }
        super._untiCheckBizBill(ctx, billId);
        if (updateCols.size() > 0) {
            iOccupants.updateBatchData(updateCols);
        }
    }

    private void verifyOccupants(Context ctx, String roomId, String occupantsId, String displayName, Date checkInDate, Date oldCheckoutDate) throws BOSException, BaseItemException {
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("Dormitory", (Object)roomId));
        filterItems.add(new FilterItemInfo("CheckInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("CheckOutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("CheckInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("CheckInDate", (Object)oldCheckoutDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("id", (Object)occupantsId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) and #5");
        SelectorItemCollection occupantsSic = new SelectorItemCollection();
        occupantsSic.add("person.name");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)occupantsSic, null);
        OccupantsCollection occupantsCollection = iOccupants.getOccupantsCollection(viewInfo);
        int j = 0;
        if (j < occupantsCollection.size()) {
            OccupantsInfo occupantsInfo = occupantsCollection.get(j);
            String personName = occupantsInfo.getPerson().getName();
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5165\u4f4f\u4fe1\u606f\u4e2d\u5458\u5de5[" + personName + "]\u5728" + sdf.format(checkInDate) + " ~ " + sdf.format(oldCheckoutDate) + "\u671f\u95f4\u5df2\u5165\u4f4f\u623f\u95f4[" + displayName + "]\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6279\u8be5\u9000\u5bbf\u5355"});
        }
    }
}

