/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.synctask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.synctask.task.AbstractSynPersonToPunchCardFacadeControllerBean;
import com.kingdee.eas.hr.affair.IResignBizBillEntry;
import com.kingdee.eas.hr.affair.ResignBizBillEntryCollection;
import com.kingdee.eas.hr.affair.ResignBizBillEntryFactory;
import com.kingdee.eas.hr.affair.ResignBizBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.ws.ca.utils.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oadd.org.apache.commons.codec.digest.DigestUtils;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class SynPersonToPunchCardFacadeControllerBean
extends AbstractSynPersonToPunchCardFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.synctask.task.SynPersonToPunchCardFacadeControllerBean");
    private volatile Properties propt;
    private final Object configLock = new Object();
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws BOSException {
        if (this.propt == null) {
            Object object = this.configLock;
            synchronized (object) {
                if (this.propt == null) {
                    Properties temp = new Properties();
                    String path = System.getProperty("EAS_HOME") + "/server/properties/abk/syncAtsConfig.properties";
                    try (FileInputStream fis = new FileInputStream(path);){
                        temp.load(fis);
                        this.propt = temp;
                    }
                    catch (IOException e) {
                        String errorMsg = "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + path + " | " + e.getMessage();
                        logger.error((Object)errorMsg, (Throwable)e);
                        throw new BOSException(errorMsg);
                    }
                }
            }
        }
    }

    @Override
    protected void _dimissionPerson(Context ctx, String personNumbers) throws BOSException, EASBizException {
        logger.error((Object)"_dimissionPerson--");
        this.loadProperties();
        IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = this.getSic();
        FilterInfo filterInfo = new FilterInfo();
        if (personNumbers.equals(null) || personNumbers.equals("")) {
            throw new BOSException("\u540c\u6b65\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.number", (Object)AtsUtil.toSet((String)personNumbers), CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        PersonPositionCollection personPositionCollection = iPersonPosition.getPersonPositionCollection(entityViewInfo);
        if (personPositionCollection.size() <= 1) {
            logger.error((Object)("personPositionCollection--" + personPositionCollection.size()));
            ArrayList<PersonPositionInfo> PersonPositionList = new ArrayList<PersonPositionInfo>();
            for (int i = 0; i < personPositionCollection.size(); ++i) {
                PersonPositionList.add(personPositionCollection.get(i));
            }
            logger.error((Object)("PersonPositionList--" + PersonPositionList.size()));
            JSONArray msgArray = new JSONArray();
            Object messageMap = null;
            if (PersonPositionList.size() > 180) {
                List<PersonPositionCollection> objects = this.splitList(PersonPositionList, 180);
                for (int i = 0; i < objects.size(); ++i) {
                    PersonPositionCollection coll = objects.get(i);
                    this.personDelete(ctx, coll);
                }
            } else {
                this.personDelete(ctx, personPositionCollection);
                msgArray.add(messageMap);
            }
        }
    }

    public void personDelete(Context ctx, PersonPositionCollection personPositionCollection) throws BOSException {
        logger.error((Object)"personDelete--");
        IResignBizBillEntry iResignBizBillEntry = ResignBizBillEntryFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < personPositionCollection.size(); ++i) {
            PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
            PersonInfo person = personPositionInfo.getPerson();
            EmployeeTypeInfo employeeType = person.getEmployeeType();
            String number = employeeType.getNumber();
            logger.error((Object)("person--" + person.getName() + "--employeeType--" + number));
            if (!number.equals("010") && !number.equals("009") && !number.equals("S09")) continue;
            JSONObject result = this.synLeavePerson(iResignBizBillEntry, person);
            logger.error((Object)("personDelete--" + result));
        }
    }

    @Override
    protected void _recoverPerson(Context ctx, int offSet) throws BOSException, EASBizException {
        logger.error((Object)"_recoverPerson--");
        this.loadProperties();
        String dayBefore = this.getDayBefore(new Date(), offSet);
        logger.error((Object)("_recoverPerson--dayBefore--" + dayBefore));
        IEmpPosOrgRelation iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
        Set personSet = this.getPersonDateByDate(ctx, dayBefore);
        logger.error((Object)("_recoverPerson--personSet--" + dayBefore));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("person.id");
        sic.add("person.number");
        sic.add("action.id");
        sic.add("action.number");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("person", (Object)personSet, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, (SorterItemCollection)sorter);
        JSONArray personNumber = new JSONArray();
        EmpPosOrgRelationCollection empPosOrgRelationCollection = iEmpPosOrgRelation.getEmpPosOrgRelationCollection(entityViewInfo);
        for (int i = 0; i < empPosOrgRelationCollection.size(); ++i) {
            EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgRelationCollection.get(i);
            String actionNumebr = empPosOrgRelationInfo.getAction().getNumber();
            if (!actionNumebr.equals("SHR02")) continue;
            personNumber.add((Object)empPosOrgRelationInfo.getPerson().getNumber());
        }
        logger.error((Object)("personNumber--" + personNumber));
        if (personNumber.size() > 0) {
            JSONObject params = new JSONObject();
            params.put("userpin", (Object)personNumber);
            Map queryParams = this.getToken();
            String urlPath = this.propt.getProperty("recoverUrlPath");
            String result = SynPersonToPunchCardFacadeControllerBean.sendPostRequest(urlPath, params, (Map<String, String>)queryParams);
            logger.error((Object)("result--" + result));
        }
    }

    @Override
    protected void _synRecoverPerson(Context ctx, int offSet, String personNumber) throws BOSException {
        super._synRecoverPerson(ctx, offSet, personNumber);
        logger.error((Object)"_synRecoverPerson--");
        this.loadProperties();
        String dayBefore = this.getDayBefore(new Date(), offSet);
        logger.error((Object)("_recoverPerson--dayBefore--" + dayBefore));
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (!StringUtils.isEmpty((String)personNumber)) {
            filterItems.add(new FilterItemInfo("number", (Object)AtsUtil.toSet((String)personNumber), CompareType.INCLUDE));
        } else {
            filterItems.add(new FilterItemInfo("hireDate", (Object)dayBefore, CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("hireDate", (Object)new Date(), CompareType.LESS_EQUALS));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("name");
        sic.add("id");
        sic.add("hireDate");
        sic.add("nCell");
        sic.add("gender");
        sic.add("email");
        sic.add("employeeType.number");
        sic.add("employeeType.id");
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        logger.error((Object)("filterInfo--" + filterInfo.toSql()));
        PersonCollection personCollection = iPerson.getPersonCollection(entityViewInfo);
        logger.error((Object)("personCollection--" + personCollection.size()));
        JSONObject personNumberAll = this.getPersonNumberAll();
        logger.error((Object)("personNumberAll--" + personNumberAll));
        if (personNumberAll.size() > 0) {
            JSONArray notExistArray = new JSONArray();
            if (personCollection.size() > 0) {
                for (int i = 0; i < personCollection.size(); ++i) {
                    PersonInfo personInfo = personCollection.get(i);
                    String name = personInfo.getName();
                    String perNumber = personInfo.getNumber();
                    String number = personInfo.getEmployeeType().getNumber();
                    if ("010".equals(number) || "009".equals(number) || "S09".equals(number) || personNumberAll.containsKey((Object)perNumber)) continue;
                    notExistArray.add((Object)perNumber);
                }
                if (notExistArray.size() > 0) {
                    logger.error((Object)("notExistArray--" + notExistArray.size()));
                    JSONObject params = new JSONObject();
                    params.put("userpin", (Object)notExistArray);
                    Map queryParams = this.getToken();
                    String urlPath = this.propt.getProperty("recoverUrlPath");
                    String result = SynPersonToPunchCardFacadeControllerBean.sendPostRequest(urlPath, params, (Map<String, String>)queryParams);
                    logger.error((Object)("result--" + result));
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    if (jsonObject.containsKey((Object)"error_list")) {
                        JSONArray errorList = jsonObject.getJSONArray("error_list");
                        StringBuilder personNumbers = new StringBuilder();
                        for (int i = 0; i < errorList.size(); ++i) {
                            Object number = errorList.get(i);
                            personNumbers.append(number).append(",");
                        }
                        personNumbers.deleteCharAt(personNumbers.lastIndexOf(","));
                        logger.error((Object)("personNumbers--" + personNumbers));
                        try {
                            this.updatePerson(ctx, personNumbers.toString());
                        }
                        catch (EASBizException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    public JSONObject getPersonNumberAll() {
        JSONObject jsonObject = new JSONObject();
        Map queryParams = this.getToken();
        String urlPath = this.propt.getProperty("employeeUrlPath");
        logger.error((Object)("getPersonNumberAll--urlPath---" + urlPath));
        String response = SynPersonToPunchCardFacadeControllerBean.sendPostRequest(urlPath, queryParams);
        JSONObject result = JSONObject.parseObject((String)response);
        logger.error((Object)("getPersonNumberAll--result---" + result));
        Integer ret = result.getInteger("ret");
        if (ret == 0) {
            JSONObject data = result.getJSONObject("data");
            String count = data.containsKey((Object)"count") ? data.getString("count") : "";
            logger.error((Object)("getPersonNumberAll--count---" + count));
            JSONArray items = data.getJSONArray("items");
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                String pin = item.getString("pin");
                String name = item.getString("name");
                jsonObject.put(pin, (Object)name);
            }
            return jsonObject;
        }
        return new JSONObject();
    }

    private Set getPersonDateByDate(Context ctx, String dayBefore) throws BOSException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("hireDate", (Object)dayBefore, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("hireDate", (Object)new Date(), CompareType.LESS_EQUALS));
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, null, null);
        logger.error((Object)("filterInfo--" + filterInfo.toSql()));
        PersonCollection personCollection = iPerson.getPersonCollection(entityViewInfo);
        logger.error((Object)("personCollection--" + personCollection.size()));
        HashSet<BOSUuid> personSet = new HashSet<BOSUuid>();
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonInfo personInfo = personCollection.get(i);
            personSet.add(personInfo.getId());
        }
        return personSet;
    }

    public String getDayBefore(Date specifiedDay, int x) {
        Calendar c = Calendar.getInstance();
        Date date = specifiedDay;
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - x);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        return dayBefore;
    }

    @Override
    protected void _updatePerson(Context ctx, String personNumbers) throws BOSException, EASBizException {
        logger.error((Object)"_updatePerson--");
        this.loadProperties();
        IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = this.getSic();
        FilterInfo filterInfo = new FilterInfo();
        if (personNumbers.equals(null) || personNumbers.equals("")) {
            throw new BOSException("\u540c\u6b65\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.number", (Object)AtsUtil.toSet((String)personNumbers), CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        PersonPositionCollection personPositionCollection = iPersonPosition.getPersonPositionCollection(entityViewInfo);
        logger.error((Object)("personPositionCollection--" + personPositionCollection.size()));
        ArrayList<PersonPositionInfo> PersonPositionList = new ArrayList<PersonPositionInfo>();
        for (int i = 0; i < personPositionCollection.size(); ++i) {
            PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
            PersonPositionList.add(personPositionInfo);
        }
        logger.error((Object)("PersonPositionList--" + PersonPositionList.size()));
        JSONArray msgArray = new JSONArray();
        Map messageMap = null;
        if (PersonPositionList.size() > 180) {
            List<PersonPositionCollection> objects = this.splitList(PersonPositionList, 180);
            for (int i = 0; i < objects.size(); ++i) {
                PersonPositionCollection coll = objects.get(i);
                messageMap = this.updateSynPersonData(coll);
                msgArray.add((Object)messageMap);
            }
        } else {
            messageMap = this.updateSynPersonData(personPositionCollection);
            msgArray.add((Object)messageMap);
        }
        logger.error((Object)("msgArray--" + msgArray));
    }

    private Map updateSynPersonData(PersonPositionCollection personPositionCollection) throws BOSException {
        String response;
        logger.error((Object)"updateSynPersonData--");
        HashMap<String, String> messageMap = new HashMap<String, String>();
        JSONArray params = new JSONArray();
        for (int i = 0; i < personPositionCollection.size(); ++i) {
            PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
            PersonInfo person = personPositionInfo.getPerson();
            EmployeeTypeInfo employeeType = person.getEmployeeType();
            String number = employeeType.getNumber();
            logger.error((Object)("person--" + person.getName() + "--employeeType--" + number));
            if (number.equals("010") || number.equals("009") || number.equals("S09")) continue;
            JSONObject param = new JSONObject();
            param.put("name", (Object)person.getName());
            param.put("pin", (Object)person.getNumber());
            param.put("deptnumber", (Object)"1");
            params.add((Object)param);
        }
        logger.error((Object)("updateSynPersonData--params--" + params));
        if (params.size() > 0 && (response = this.synPerson(params)) != null) {
            messageMap.put("updatePersonMsg", response);
        }
        return messageMap;
    }

    @Override
    protected void _initializePerson(Context ctx) throws BOSException {
        logger.error((Object)"_initializePerson--");
        this.loadProperties();
        IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
        IResignBizBillEntry iResignBizBillEntry = ResignBizBillEntryFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = this.getSic();
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance(null, (SelectorItemCollection)sic, null);
        PersonPositionCollection personPositionCollection = iPersonPosition.getPersonPositionCollection(entityViewInfo);
        logger.error((Object)("personPositionCollection--" + personPositionCollection.size()));
        ArrayList<PersonPositionInfo> PersonPositionList = new ArrayList<PersonPositionInfo>();
        for (int i = 0; i < personPositionCollection.size(); ++i) {
            PersonPositionList.add(personPositionCollection.get(i));
        }
        logger.error((Object)("PersonPositionList--" + PersonPositionList.size()));
        JSONArray msgArray = new JSONArray();
        Map messageMap = null;
        if (PersonPositionList.size() > 180) {
            List<PersonPositionCollection> objects = this.splitList(PersonPositionList, 180);
            for (int i = 0; i < objects.size(); ++i) {
                PersonPositionCollection coll = objects.get(i);
                messageMap = this.initializeSynPersonData(coll, iResignBizBillEntry);
                msgArray.add((Object)messageMap);
            }
        } else {
            messageMap = this.initializeSynPersonData(personPositionCollection, iResignBizBillEntry);
            msgArray.add((Object)messageMap);
        }
        logger.error((Object)("msgArray--" + msgArray));
    }

    private Map initializeSynPersonData(PersonPositionCollection personPositionCollection, IResignBizBillEntry iResignBizBillEntry) throws BOSException {
        String response;
        int i;
        HashMap<String, String> messageMap = new HashMap<String, String>();
        JSONArray params = new JSONArray();
        JSONArray leavePersonMsg = new JSONArray();
        ArrayList<PersonInfo> deletePersonList = new ArrayList<PersonInfo>();
        for (i = 0; i < personPositionCollection.size(); ++i) {
            PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
            PersonInfo person = personPositionInfo.getPerson();
            EmployeeTypeInfo employeeType = person.getEmployeeType();
            String number = employeeType.getNumber();
            logger.error((Object)("person--" + person.getName() + "--employeeType--" + number));
            if (number.equals("010") || number.equals("009") || number.equals("S09")) {
                deletePersonList.add(person);
                continue;
            }
            JSONObject param = new JSONObject();
            param.put("name", (Object)person.getName());
            param.put("pin", (Object)person.getNumber());
            param.put("deptnumber", (Object)"1");
            params.add((Object)param);
        }
        messageMap.put("leavePersonMsg", leavePersonMsg.toString());
        if (params.size() > 0 && (response = this.synPerson(params)) != null) {
            messageMap.put("updatePersonMsg", response);
        }
        for (i = 0; i < deletePersonList.size(); ++i) {
            PersonInfo person = (PersonInfo)deletePersonList.get(i);
            JSONObject result = this.synLeavePerson(iResignBizBillEntry, person);
            if (result == null) continue;
            leavePersonMsg.add((Object)result);
        }
        return messageMap;
    }

    public SelectorItemCollection getSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("person.number");
        sic.add("person.name");
        sic.add("person.id");
        sic.add("person.hireDate");
        sic.add("person.nCell");
        sic.add("person.gender");
        sic.add("person.email");
        sic.add("person.employeeType.number");
        sic.add("personDep.name");
        sic.add("personDep.number");
        sic.add("personDep.id");
        sic.add("personDep.parent.id");
        return sic;
    }

    public List<PersonPositionCollection> splitList(List coll, int len) {
        ArrayList<PersonPositionCollection> result = new ArrayList<PersonPositionCollection>();
        int size = coll.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            PersonPositionCollection personPositionCollection = new PersonPositionCollection();
            List subList = coll.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            for (int p = 0; p < subList.size(); ++p) {
                PersonPositionInfo personPositionInfo = (PersonPositionInfo)subList.get(p);
                personPositionCollection.add(personPositionInfo);
            }
            result.add(personPositionCollection);
        }
        return result;
    }

    public JSONObject synLeavePerson(IResignBizBillEntry iResignBizBillEntry, PersonInfo personInfo) throws BOSException {
        logger.error((Object)"synLeavePerson-----");
        ResignBizBillEntryCollection entryInfo = iResignBizBillEntry.getResignBizBillEntryCollection("where person.id = '" + personInfo.getId() + "'");
        JSONObject param = new JSONObject();
        if (entryInfo.size() > 0) {
            ResignBizBillEntryInfo resignBizBillEntryInfo = entryInfo.get(0);
            Date bizDate = resignBizBillEntryInfo.getBizDate();
            param.put("pin", (Object)personInfo.getNumber());
            param.put("leavedate", (Object)DateTimeUtil.getFmtDate((Date)bizDate, (String)"yyyy-MM-dd HH:mm"));
            param.put("leavetype", (Object)0);
        }
        Map queryParams = this.getToken();
        String urlPath = this.propt.getProperty("leaveUrlPath");
        String response = SynPersonToPunchCardFacadeControllerBean.sendPostRequest(urlPath, param, (Map<String, String>)queryParams);
        if (response != null) {
            JSONObject result = JSONObject.parseObject((String)response);
            if ("0".equals(result.getString("ret"))) {
                logger.error((Object)(personInfo.getId() + "_" + personInfo.getName() + "result--" + result));
            }
            return result;
        }
        return null;
    }

    private String synPerson(JSONArray params) {
        Map queryParams = this.getToken();
        String urlPath = this.propt.getProperty("updateUrlPath");
        return SynPersonToPunchCardFacadeControllerBean.sendPostRequest(urlPath, params, (Map<String, String>)queryParams);
    }

    public Map getToken() {
        long currentTime = Instant.now().getEpochSecond();
        String secretKey = this.propt.getProperty("SECRET_KEY");
        String token = DigestUtils.md5Hex((String)(secretKey + currentTime));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("timestamp", String.valueOf(currentTime));
        queryParams.put("token", token);
        return queryParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostRequest(String urlPath, Map<String, String> queryParams) {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)urlPath).newBuilder();
            if (queryParams != null) {
                queryParams.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
            }
            String fullUrl = urlBuilder.build().toString();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)"");
            Request request = new Request.Builder().url(fullUrl).post(body).addHeader("Content-Type", "application/json").build();
            try (Response response = client.newCall(request).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String string = response.body().string();
                    return string;
                }
                logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.code()));
                return null;
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostRequest(String urlPath, JSONArray params, Map<String, String> queryParams) {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)urlPath).newBuilder();
            if (queryParams != null) {
                queryParams.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
            }
            String fullUrl = urlBuilder.build().toString();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)params.toJSONString());
            Request request = new Request.Builder().url(fullUrl).post(body).addHeader("Content-Type", "application/json").build();
            try (Response response = client.newCall(request).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String string = response.body().string();
                    return string;
                }
                logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.code()));
                return null;
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostRequest(String urlPath, JSONObject params, Map<String, String> queryParams) {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)urlPath).newBuilder();
            if (queryParams != null) {
                queryParams.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
            }
            String fullUrl = urlBuilder.build().toString();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)params.toJSONString());
            Request request = new Request.Builder().url(fullUrl).post(body).addHeader("Content-Type", "application/json").build();
            try (Response response = client.newCall(request).execute();){
                if (response.isSuccessful() && response.body() != null) {
                    String string = response.body().string();
                    return string;
                }
                logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.code()));
                return null;
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }
}

