/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.dormitorysystem.waterelectricity.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.dormitorysystem.dormitory.DormitoryInfo;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.IWaterElectricity;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.WaterElectricityCollection;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.WaterElectricityFactory;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.WaterElectricityInfo;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.WaterElectricityStutas;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.handler.WaterElectricityBatchListHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ats.web.util.SHRBillUtil;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.compensation.request.ParseRequestHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import shaded.com.google.common.collect.Lists;

public class WaterElectricityListHandler
extends WaterElectricityBatchListHandler {
    private static Logger logger = LoggerFactory.getLogger(WaterElectricityListHandler.class);
    public static final String TABLENAME = "CT_WOE_WaterElectricity";

    protected StringBuilder getPersonWaterElectricitySql(String startPeriodDateStr, String endPeriodDateStr, Collection<String> billids) {
        StringBuilder sel = new StringBuilder();
        sel.append(" select  p.fid pid,p.fname_l2 pName,p.fnumber pNumber,ops.fid opsid,ops.CFCheckInDate,ops.CFCheckOutDate,ops.CFDormitoryID dormitoryID, ");
        sel.append(" wpp.fid wppid,wpp.CFStartDate,wpp.CFEndDate,wpp.CFWaterprice,wpp.CFElectricityprice, ");
        sel.append(" wpmr.fid wpmrid,wpmr.CFYears wpmrStartDate,DATEADD(DD,-1,DATEADD(MM,DATEDIFF(MM,0,wpmr.CFYears)+1,0)) wpmrEndDate,isnull(wpmr.CFTotalWaterTons,0) CFTotalWaterTons,isnull(wpmr.CFTotalElecDegrees,0) CFTotalElecDegrees, ");
        sel.append(" isnull(wpmr.CFCurMonthWater,0) CFCurMonthWater,isnull(wpmr.CFCurMonthElecDegrees,0) CFCurMonthElecDegrees,wpmr.CFMeterReaPersonID,pp.FPrimaryPositionID,pp.FPersonDep, ");
        sel.append(" case ");
        sel.append("  bt.finservice ");
        sel.append("  when 1 then 'active' ");
        sel.append("  when 4 then 'active' ");
        sel.append("  else 'inactive' ");
        sel.append(" end as InService ");
        sel.append(" from CT_OCC_Occupants ops ");
        sel.append(" left join T_HR_PersonPosition pp on pp.fid =ops.CFPersonPositionID ");
        sel.append(" left join t_bd_person p on pp.FPERSONID = p.fid ");
        sel.append(" left join T_HR_BDEmployeeType bt on bt.fid = p.FEmployeeTypeID ");
        sel.append(" left join CT_DOR_Dormitory dy on ops.CFDormitoryID=dy.fid ");
        sel.append(" left join CT_WAT_WaterPowerPricing wpp on wpp.CFEndDate>='" + startPeriodDateStr + "' ");
        sel.append(" and wpp.CFStartDate<='" + endPeriodDateStr + "' ");
        sel.append(" left join CT_MAN_WaterPowerMeterReading wpmr on wpmr.CFDormitoryID=ops.CFDormitoryID ");
        sel.append(" and wpmr.CFYears<=ops.CFCheckOutDate ");
        sel.append(" and DATEADD(DD,-1,DATEADD(MM,DATEDIFF(MM,0,wpmr.CFYears)+1,0))>= ops.CFCheckInDate ");
        sel.append(" left join CT_WOE_WaterElectricity wey on wey.FSourceFunction=ops.fid and wey.CFPersonID=pp.FPERSONID ");
        sel.append(" and wey.CFStartDate='" + startPeriodDateStr + "' ");
        sel.append(" and wey.CFEndDate='" + endPeriodDateStr + "' ");
        sel.append(" where ");
        sel.append(" to_char(ops.CFCheckOutDate,'yyyy-MM-dd') >= '" + startPeriodDateStr + "' ");
        sel.append(" and to_char(ops.CFCheckInDate ,'yyyy-MM-dd') <='" + endPeriodDateStr + "' ");
        if (null != billids && !billids.isEmpty()) {
            sel.append(" and wey.fid in('' ");
            for (String id : billids) {
                sel.append(",'");
                sel.append(id);
                sel.append("'");
            }
            sel.append(")");
        }
        System.out.println("getPersonWaterElectricitySql:" + sel);
        return sel;
    }

    protected List<Map<String, Object>> getPersonWaterElectricityList(Context ctx, String startPeriodDateStr, String endPeriodDateStr, Collection<String> billids) throws BOSException, SQLException {
        StringBuilder sel = this.getPersonWaterElectricitySql(startPeriodDateStr, endPeriodDateStr, billids);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString());
        ArrayList list = Lists.newArrayList();
        while (rs.next()) {
            HashMap rowMap = Maps.newHashMap();
            String pid = rs.getString("pid");
            String pName = rs.getString("pName");
            String pNumber = rs.getString("pNumber");
            String opsid = rs.getString("opsid");
            String InService = rs.getString("InService");
            Date checkInDate = rs.getDate("CFCheckInDate");
            Date checkOutDate = rs.getDate("CFCheckOutDate");
            String dormitoryID = rs.getString("dormitoryID");
            String wppid = rs.getString("wppid");
            Date startDate = rs.getDate("CFStartDate");
            Date endDate = rs.getDate("CFEndDate");
            BigDecimal waterprice = rs.getBigDecimal("CFWaterprice");
            BigDecimal electricityprice = rs.getBigDecimal("CFElectricityprice");
            String wpmrid = rs.getString("wpmrid");
            Date wpmrStartDate = rs.getDate("wpmrStartDate");
            Date wpmrEndDate = rs.getDate("wpmrEndDate");
            BigDecimal totalWaterTons = rs.getBigDecimal("CFTotalWaterTons");
            BigDecimal totalElecDegrees = rs.getBigDecimal("CFTotalElecDegrees");
            BigDecimal curMonthWater = rs.getBigDecimal("CFCurMonthWater");
            BigDecimal curMonthElecDegrees = rs.getBigDecimal("CFCurMonthElecDegrees");
            String FPrimaryPositionID = rs.getString("FPrimaryPositionID");
            String FPersonDep = rs.getString("FPersonDep");
            rowMap.put("pid", pid);
            rowMap.put("pName", pName);
            rowMap.put("pNumber", pNumber);
            rowMap.put("opsid", opsid);
            rowMap.put("InService", InService);
            rowMap.put("checkInDate", checkInDate);
            rowMap.put("checkOutDate", checkOutDate);
            rowMap.put("dormitoryID", dormitoryID);
            rowMap.put("wppid", wppid);
            rowMap.put("startDate", startDate);
            rowMap.put("endDate", endDate);
            rowMap.put("waterprice", waterprice);
            rowMap.put("electricityprice", electricityprice);
            rowMap.put("wpmrid", wpmrid);
            rowMap.put("wpmrStartDate", wpmrStartDate);
            rowMap.put("wpmrEndDate", wpmrEndDate);
            rowMap.put("totalWaterTons", totalWaterTons);
            rowMap.put("totalElecDegrees", totalElecDegrees);
            rowMap.put("curMonthWater", curMonthWater);
            rowMap.put("curMonthElecDegrees", curMonthElecDegrees);
            rowMap.put("primaryPositionID", FPrimaryPositionID);
            rowMap.put("personDep", FPersonDep);
            list.add(rowMap);
        }
        return list;
    }

    protected WaterElectricityInfo getWaterElectricityInfo(IWaterElectricity we, String periodDate, String pid, String dormitoryID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("yearMonth", (Object)periodDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dormitory.id", (Object)dormitoryID, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("person.*"));
        selector.add(new SelectorItemInfo("dormitory.*"));
        selector.add(new SelectorItemInfo("adminOrg.*"));
        selector.add(new SelectorItemInfo("position.*"));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("yearMonth"));
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, (SorterItemCollection)sorter);
        WaterElectricityCollection wec = we.getWaterElectricityCollection(viewInfo);
        WaterElectricityInfo waterElectricityInfo = null;
        if (null != wec && wec.size() > 0) {
            waterElectricityInfo = wec.get(0);
        }
        return waterElectricityInfo;
    }

    protected Map<String, Set<String>> createUpdateWE(Context ctx, List<Map<String, Object>> mapList, Map<String, Object> param, Map<String, Map<String, Object>> occupantsMap, String createUpdate) throws BOSException, ShrWebBizException, EASBizException {
        HashMap resutMap = Maps.newHashMap();
        HashSet alls = Sets.newHashSet();
        HashSet sess = Sets.newHashSet();
        HashSet errs = Sets.newHashSet();
        LocalDate startPeriodDate = (LocalDate)param.get("startPeriodDate");
        LocalDate endPeriodDate = (LocalDate)param.get("endPeriodDate");
        String startPeriodDateStr = (String)param.get("startPeriodDateStr");
        String endPeriodDateStr = (String)param.get("endPeriodDateStr");
        String periodDate = (String)param.get("periodDate");
        IWaterElectricity we = WaterElectricityFactory.getLocalInstance((Context)ctx);
        for (Map<String, Object> map : mapList) {
            IObjectPK pk;
            map.putAll(param);
            String pid = (String)map.get("pid");
            String pName = (String)map.get("pName");
            String pNumber = (String)map.get("pNumber");
            String opsid = (String)map.get("opsid");
            String InService = (String)map.get("InService");
            java.util.Date checkInDate = (java.util.Date)map.get("checkInDate");
            java.util.Date checkOutDate = (java.util.Date)map.get("checkOutDate");
            String dormitoryID = (String)map.get("dormitoryID");
            String wppid = (String)map.get("wppid");
            java.util.Date startDate = (java.util.Date)map.get("startDate");
            java.util.Date endDate = (java.util.Date)map.get("endDate");
            BigDecimal waterprice = (BigDecimal)map.get("waterprice");
            BigDecimal electricityprice = (BigDecimal)map.get("electricityprice");
            String wpmrid = (String)map.get("wpmrid");
            java.util.Date wpmrStartDate = (java.util.Date)map.get("wpmrStartDate");
            java.util.Date wpmrEndDate = (java.util.Date)map.get("wpmrEndDate");
            BigDecimal totalWaterTons = (BigDecimal)map.get("totalWaterTons");
            BigDecimal totalElecDegrees = (BigDecimal)map.get("totalElecDegrees");
            BigDecimal curMonthWater = (BigDecimal)map.get("curMonthWater");
            BigDecimal curMonthElecDegrees = (BigDecimal)map.get("curMonthElecDegrees");
            String primaryPositionID = (String)map.get("primaryPositionID");
            String personDep = (String)map.get("personDep");
            WaterElectricityInfo waterElectricityInfo = this.getWaterElectricityInfo(we, periodDate, pid, dormitoryID);
            if (null == waterElectricityInfo) {
                waterElectricityInfo = new WaterElectricityInfo();
            }
            waterElectricityInfo.setSourceFunction(opsid);
            Map<String, Object> occupants = occupantsMap.get(dormitoryID);
            HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
            hrOrgUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            waterElectricityInfo.setHrOrgUnit(hrOrgUnitInfo);
            waterElectricityInfo.setYearMonth(periodDate);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)pid));
            waterElectricityInfo.setPerson(personInfo);
            waterElectricityInfo.setEmpName(pName);
            waterElectricityInfo.setEmpNumber(pNumber);
            waterElectricityInfo.setPositionStatus(InService);
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)personDep));
            waterElectricityInfo.setAdminOrg(adminOrgUnitInfo);
            waterElectricityInfo.setBizDate(checkInDate);
            waterElectricityInfo.setLeaveDate(checkOutDate);
            DormitoryInfo dormitoryInfo = new DormitoryInfo();
            dormitoryInfo.setId(BOSUuid.read((String)dormitoryID));
            waterElectricityInfo.setDormitory(dormitoryInfo);
            this.calculateWaterElectricity((CoreBillBaseInfo)waterElectricityInfo, map, occupants);
            waterElectricityInfo.setMeterReading(wpmrid);
            waterElectricityInfo.setHydropowerStandards(wppid);
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)primaryPositionID));
            waterElectricityInfo.setPosition(positionInfo);
            Instant instant1 = startPeriodDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            long timestamp1 = instant1.toEpochMilli();
            waterElectricityInfo.setStartDate(new java.util.Date(timestamp1));
            Instant instant2 = endPeriodDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            long timestamp2 = instant2.toEpochMilli();
            waterElectricityInfo.setEndDate(new java.util.Date(timestamp2));
            waterElectricityInfo.setApplyDate(checkInDate);
            PersonInfo applier = SHRBillUtil.getCurrPersonInfo();
            waterElectricityInfo.setApplier(applier);
            BOSUuid id = waterElectricityInfo.getId();
            if (null == id) {
                waterElectricityInfo.setStutas(WaterElectricityStutas.UnLock);
                waterElectricityInfo.setBillState(HRBillStateEnum.SAVED);
            }
            if ("update".equals(createUpdate)) {
                if (null != id && WaterElectricityStutas.UnLock.equals((Object)waterElectricityInfo.getStutas())) {
                    pk = we.save((CoreBaseInfo)waterElectricityInfo);
                    sess.add(pk.toString());
                    continue;
                }
                if (null == id) continue;
                errs.add(id.toString());
                continue;
            }
            if (!WaterElectricityStutas.UnLock.equals((Object)waterElectricityInfo.getStutas())) continue;
            pk = we.save((CoreBaseInfo)waterElectricityInfo);
            sess.add(pk.toString());
        }
        resutMap.put("alls", alls);
        resutMap.put("errs", errs);
        resutMap.put("sess", sess);
        return resutMap;
    }

    public void createMonthAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            String billidStr = this.getBillId(request);
            HashSet billids = Sets.newHashSet();
            if (!StringUtils.isEmpty((String)billidStr)) {
                billids.addAll(Arrays.asList(billidStr.split(",")));
            }
            String periodDate = (String)ParseRequestHelper.getParameterByRequest((ServletRequest)request, (String)"periodDate");
            LocalDate startPeriodDate = LocalDate.parse(periodDate + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            Month month = startPeriodDate.getMonth();
            LocalDate endPeriodDate = LocalDate.of(startPeriodDate.getYear(), month, month.length(startPeriodDate.isLeapYear()));
            String startPeriodDateStr = startPeriodDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            String endPeriodDateStr = endPeriodDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            HashMap param = Maps.newHashMap();
            param.put("periodDate", periodDate);
            param.put("startPeriodDate", startPeriodDate);
            param.put("endPeriodDate", endPeriodDate);
            param.put("startPeriodDateStr", startPeriodDateStr);
            param.put("endPeriodDateStr", endPeriodDateStr);
            List<Map<String, Object>> mapList = this.getPersonWaterElectricityList(ctx, startPeriodDateStr, endPeriodDateStr, billids);
            HashSet dormitorySet = Sets.newHashSet();
            for (Map<String, Object> map : mapList) {
                String dormitoryID = (String)map.get("dormitoryID");
                dormitorySet.add(dormitoryID);
            }
            Map<String, Map<String, Object>> occupantsMap = this.getPersonOccupantsList(ctx, dormitorySet, startPeriodDate, endPeriodDate);
            Map<String, Set<String>> result = this.createUpdateWE(ctx, mapList, param, occupantsMap, "create");
            this.returnMessage(request, batchMessageTipsHeader, result, billids);
        }
        catch (BOSException | EASBizException | SQLException e) {
            e.printStackTrace();
        }
    }

    public void calculateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            String billId = this.getBillId(request);
            String billidStr = this.getBillId(request);
            HashSet billids = Sets.newHashSet();
            if (!StringUtils.isEmpty((String)billidStr)) {
                billids.addAll(Arrays.asList(billidStr.split(",")));
            }
            String fastFilterItems = (String)ParseRequestHelper.getParameterByRequest((ServletRequest)request, (String)"fastFilterItems");
            logger.error(fastFilterItems);
            HashMap fastFilterItemsMap = JSONUtils.convertJsonToObject((Context)SHRContext.getInstance().getContext(), (String)fastFilterItems);
            Map bizDateMap = (Map)fastFilterItemsMap.get("startDate");
            if (!(null == bizDateMap.get("values") || String.class.equals(bizDateMap.get("values").getClass()) && StringUtils.isEmpty((String)String.valueOf(bizDateMap.get("values"))))) {
                Map subMap = (Map)bizDateMap.get("values");
                String periodDate = (String)subMap.get("date");
                LocalDate startPeriodDate = LocalDate.parse(periodDate, DateTimeFormatter.ISO_LOCAL_DATE);
                periodDate = periodDate.substring(0, 7);
                Month month = startPeriodDate.getMonth();
                LocalDate endPeriodDate = LocalDate.of(startPeriodDate.getYear(), month, month.length(startPeriodDate.isLeapYear()));
                String startPeriodDateStr = startPeriodDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
                String endPeriodDateStr = endPeriodDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
                HashMap param = Maps.newHashMap();
                param.put("periodDate", periodDate);
                param.put("startPeriodDate", startPeriodDate);
                param.put("endPeriodDate", endPeriodDate);
                param.put("startPeriodDateStr", startPeriodDateStr);
                param.put("endPeriodDateStr", endPeriodDateStr);
                List<Map<String, Object>> mapList = this.getPersonWaterElectricityList(ctx, startPeriodDateStr, endPeriodDateStr, billids);
                HashSet dormitorySet = Sets.newHashSet();
                for (Map<String, Object> map : mapList) {
                    String dormitoryID = (String)map.get("dormitoryID");
                    dormitorySet.add(dormitoryID);
                }
                Map<String, Map<String, Object>> occupantsMap = this.getPersonOccupantsList(ctx, dormitorySet, startPeriodDate, endPeriodDate);
                Map<String, Set<String>> result = this.createUpdateWE(ctx, mapList, param, occupantsMap, "update");
                this.returnMessage(request, batchMessageTipsHeader, result, billids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public String enableAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = this.getBillId(request);
        Context ctx = SHRContext.getInstance().getContext();
        WaterElectricityListHandler.enable(ctx, billId);
        return null;
    }

    public static String enable(Context ctx, String billId) {
        if (null != billId) {
            String[] ids;
            for (String id : ids = billId.split(",")) {
                try {
                    WaterElectricityListHandler.updateBillState(ctx, "enable", id);
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return billId;
    }

    public String disableAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = this.getBillId(request);
        Context ctx = SHRContext.getInstance().getContext();
        WaterElectricityListHandler.disable(ctx, billId);
        return null;
    }

    public static String disable(Context ctx, String billId) {
        if (null != billId) {
            String[] ids;
            for (String id : ids = billId.split(",")) {
                try {
                    WaterElectricityListHandler.updateBillState(ctx, "disable", id);
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return billId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBillState(Context ctx, String math, String uuid) throws SQLException {
        Connection conn = null;
        Statement state = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            state = conn.createStatement();
            if ("enable".equals(math)) {
                state.execute("update CT_WOE_WaterElectricity set FBillState='2' where fid='" + uuid + "' and FBillState < 2 ");
            } else if ("disable".equals(math)) {
                state.execute("update CT_WOE_WaterElectricity set FBillState='0' where fid='" + uuid + "' and FBillState < 3 ");
            }
        }
        catch (SQLException var32) {
            var32.printStackTrace();
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
    }
}

