/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.dormitorysystem.application.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationInfo;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.ICheckoutApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.IRoomChangeApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.app.AbstractCheckInApplicationControllerBean;
import com.kingdee.eas.custom.dormitorysystem.application.utils.CheckDuplicateCheckInByBillIdUtil;
import com.kingdee.eas.custom.dormitorysystem.application.utils.ValidateRoomAvailableByBillIdsUtil;
import com.kingdee.eas.custom.dormitorysystem.occupants.IOccupants;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsFactory;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsInfo;
import com.kingdee.eas.custom.dormitorysystem.otherbasicdata.PersonDormitoryTypeInfo;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.IWaterElectricity;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.WaterElectricityCollection;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.WaterElectricityFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CheckInApplicationControllerBean
extends AbstractCheckInApplicationControllerBean {
    private static Logger logger = Logger.getLogger(CheckInApplicationControllerBean.class);

    @Override
    protected boolean _validateBillInProcess(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        boolean isError = super._validateBillInProcess(ctx, billID);
        if (!isError) {
            if (billID == null) {
                throw new BOSException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            CheckInApplicationInfo info = this.getCheckInApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
            try {
                HRBillStateEnum billState = info.getBillState();
                if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
                    throw new BOSException("\u5355\u636e\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
                }
                ValidateRoomAvailableByBillIdsUtil.startValidate(ctx, billID.toString());
                CheckDuplicateCheckInByBillIdUtil.startValidate(ctx, billID.toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("errorMsg");
                info.setErrorMsg(e.getMessage());
                this.updatePartial(ctx, (CoreBaseInfo)info, sic);
                return true;
            }
        }
        return isError;
    }

    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
        CheckInApplicationInfo info = this.getCheckInApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("errorMsg");
        info.setErrorMsg(null);
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditing(ctx, billID);
        CheckInApplicationInfo info = this.getCheckInApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("errorMsg");
        info.setErrorMsg(null);
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        CheckInApplicationInfo info = this.getCheckInApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        CheckInApplicationEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            CheckInApplicationEntryInfo entryInfo = entrys.get(i);
            PersonInfo personInfo = entryInfo.getPerson();
            String personId = personInfo.getId().toString();
            personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            PersonPositionInfo pp = iPersonPosition.getPersonPositionInfo("select personDep.*,primaryPosition.* where person = '" + personId + "'");
            OccupantsInfo occupantsInfo = new OccupantsInfo();
            occupantsInfo.setPerson(personInfo);
            occupantsInfo.setCheckInDate(entryInfo.getCheckInDate());
            occupantsInfo.setCheckOutDate(entryInfo.getCheckoutDate());
            occupantsInfo.setDormitory(entryInfo.getCheckInRoom());
            occupantsInfo.setPersonDormitoryType((PersonDormitoryTypeInfo)personInfo.get("personType"));
            occupantsInfo.setPersonPosition(pp);
            occupantsInfo.setState(BasicItemStateEnum.ENABLE);
            iOccupants.addnew((CoreBaseInfo)occupantsInfo);
            entryInfo.setOccupants(occupantsInfo);
        }
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billID), (CoreBaseInfo)info);
        super._setAudited(ctx, billID);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)this._getValue(ctx, pk);
        HRBillStateEnum billState = info.getBillState();
        boolean isRemovable = true;
        if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITED.equals((Object)billState)) {
            isRemovable = false;
        }
        if (!isRemovable) {
            throw new AffairBizException(AffairBizException.BILLCANTDELETE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billId)) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        CheckInApplicationInfo info = this.getCheckInApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        HRBillStateEnum billState = info.getBillState();
        if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{"\u5355\u636e\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01"});
        }
        try {
            ValidateRoomAvailableByBillIdsUtil.startValidate(ctx, billId);
            CheckDuplicateCheckInByBillIdUtil.startValidate(ctx, billId);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{e.getMessage()});
        }
        return super._submitEffect(ctx, (CoreBaseInfo)info);
    }

    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String billId = model.getId().toString();
        return this._submitEffect(ctx, billId);
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.person.*");
        CheckInApplicationInfo info = this.getCheckInApplicationInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        HRBillStateEnum billState = info.getBillState();
        if (!HRBillStateEnum.AUDITED.equals((Object)billState)) {
            throw new AffairBizException(HRBaseException.BILLSTATECANUNCHECK);
        }
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        IRoomChangeApplicationEntry iRoomChangeApplicationEntry = RoomChangeApplicationEntryFactory.getLocalInstance((Context)ctx);
        ICheckoutApplicationEntry iCheckoutApplicationEntry = CheckoutApplicationEntryFactory.getLocalInstance(ctx);
        IWaterElectricity iWaterElectricity = WaterElectricityFactory.getLocalInstance((Context)ctx);
        HashSet<String> occupantsIds = new HashSet<String>();
        CheckInApplicationEntryCollection entrys = info.getEntrys();
        StringBuilder errorMsg = new StringBuilder();
        HashSet<String> entryIds = new HashSet<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        for (int i = 0; i < entrys.size(); ++i) {
            String filter;
            WaterElectricityCollection waterElectricityCol;
            CheckoutApplicationEntryCollection checkoutApplicationEntryCollection;
            CheckInApplicationEntryInfo entryInfo = entrys.get(i);
            Date checkInDate = entryInfo.getCheckInDate();
            Date checkoutDate = entryInfo.getCheckoutDate();
            PersonInfo person = entryInfo.getPerson();
            String personId = person.getId().toString();
            OccupantsInfo occupants = entryInfo.getOccupants();
            String occupantsId = occupants.getId().toString();
            RoomChangeApplicationEntryCollection roomChangeApplicationEntryCollection = iRoomChangeApplicationEntry.getRoomChangeApplicationEntryCollection("select parent.number where oldOccupants = '" + occupantsId + "'");
            if (roomChangeApplicationEntryCollection.size() > 0) {
                RoomChangeApplicationEntryInfo roomChangeApplicationEntryInfo = roomChangeApplicationEntryCollection.get(0);
                String number = roomChangeApplicationEntryInfo.getParent().getNumber();
                errorMsg.append("\u5458\u5de5 " + person.getName() + "\u5df2\u6709\u6362\u5bbf\u5355[ " + number + " ]\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01\n");
            }
            if ((checkoutApplicationEntryCollection = iCheckoutApplicationEntry.getCheckoutApplicationEntryCollection("select parent.number where occupants = '" + occupantsId + "'")).size() > 0) {
                CheckoutApplicationEntryInfo checkoutApplicationEntryInfo = checkoutApplicationEntryCollection.get(0);
                String number = checkoutApplicationEntryInfo.getParent().getNumber();
                errorMsg.append("\u5458\u5de5 " + person.getName() + "\u5df2\u6709\u9000\u5bbf\u5355[ " + number + " ]\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01\n");
            }
            if ((waterElectricityCol = iWaterElectricity.getWaterElectricityCollection(filter = "where person.id = '" + personId + "' and yearMonth >= '" + dateFormat.format(checkInDate) + "' and yearMonth <='" + dateFormat.format(checkoutDate) + "'")).size() > 0) {
                errorMsg.append("\u5458\u5de5 " + person.getName() + " \u5df2\u7ecf\u4ea7\u751f\u6c34\u7535\u660e\u7ec6\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01\n");
            }
            occupantsIds.add(occupantsId);
            entryIds.add(entryInfo.getId().toString());
        }
        if (errorMsg.length() > 0) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{errorMsg.toString()});
        }
        super._untiCheckBizBill(ctx, billId);
        if (!occupantsIds.isEmpty()) {
            iOccupants.delete("where id in (" + AtsUtil.convertSetToString(occupantsIds) + ")");
            if (!entryIds.isEmpty()) {
                String updateSql = "update CT_APP_CheckInAE set CFOccupantsID = null where fid in (" + AtsUtil.convertSetToString(entryIds) + ")";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
    }
}

