/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.dormitorysystem.waterelectricity.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.custom.dormitorysystem.waterelectricity.handler.HRBillStateExEnum;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.web.handler.base.CommonBatchListHandler;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;

public abstract class WaterElectricityBatchListHandler
extends CommonBatchListHandler {
    private static Logger logger = LoggerFactory.getLogger(WaterElectricityBatchListHandler.class);
    private String successMessage = "";

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    protected CoreBillBaseInfo calculateWaterElectricity(CoreBillBaseInfo waterElectricityInfo, Map<String, Object> map, Map<String, Object> occupants) {
        BigDecimal waterprice = (BigDecimal)map.get("waterprice");
        BigDecimal electricityprice = (BigDecimal)map.get("electricityprice");
        BigDecimal curMonthWater = (BigDecimal)map.get("curMonthWater");
        BigDecimal curMonthElecDegrees = (BigDecimal)map.get("curMonthElecDegrees");
        LocalDate startPeriodDate = (LocalDate)map.get("startPeriodDate");
        LocalDate endPeriodDate = (LocalDate)map.get("endPeriodDate");
        Date checkInDate = (Date)map.get("checkInDate");
        Date checkOutDate = (Date)map.get("checkOutDate");
        waterElectricityInfo.put("waterTotalCost", (Object)waterprice.multiply(curMonthWater));
        waterElectricityInfo.put("electricityTotalCost", (Object)electricityprice.multiply(curMonthElecDegrees));
        LocalDate checkInDateLocal = new Date(checkInDate.getTime()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        checkInDateLocal = checkInDateLocal.compareTo(startPeriodDate) > 0 ? checkInDateLocal : startPeriodDate;
        LocalDate checkOutDateLocal = new Date(checkOutDate.getTime()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        checkOutDateLocal = checkOutDateLocal.compareTo(endPeriodDate) < 0 ? checkOutDateLocal : endPeriodDate;
        long daysBetween = ChronoUnit.DAYS.between(checkInDateLocal, checkOutDateLocal);
        BigDecimal days = new BigDecimal((Long)occupants.get("days"));
        waterElectricityInfo.put("allMonthDays", (Object)days);
        waterElectricityInfo.put("monthDays", (Object)new BigDecimal(daysBetween));
        BigDecimal monthWaterAmount = waterElectricityInfo.getBigDecimal("waterTotalCost").divide(days, 4, 4).multiply(waterElectricityInfo.getBigDecimal("MonthDays"));
        waterElectricityInfo.put("monthWaterAmount", (Object)monthWaterAmount);
        BigDecimal monthElectricityAmount = waterElectricityInfo.getBigDecimal("ElectricityTotalCost").divide(days, 4, 4).multiply(waterElectricityInfo.getBigDecimal("MonthDays"));
        waterElectricityInfo.put("monthElectricityAmount", (Object)monthElectricityAmount);
        return waterElectricityInfo;
    }

    public static String convertListToString(Object[] array) {
        StringBuilder sb = new StringBuilder();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append((String)array[i]);
                continue;
            }
            if (i != size - 1) {
                sb.append((String)array[i]);
                sb.append(",");
                continue;
            }
            sb.append((String)array[i]);
        }
        return sb.toString();
    }

    protected void returnMessage(HttpServletRequest request, BatchMessageTipsHeader batchMessageTipsHeader, Map<String, Set<String>> result, Set<String> billids) {
        Set<String> sess = result.get("sess");
        Set<String> errs = result.get("errs");
        sess.addAll(errs);
        billids.removeAll(sess);
        request.setAttribute("billId", (Object)WaterElectricityBatchListHandler.convertListToString(sess.toArray()));
        if (null != errs && !errs.isEmpty()) {
            WaterElectricityBatchListHandler.addBatchMessageTips(errs, (String)"\u4e3a\u9501\u5b9a\u72b6\u6001\u4e0d\u80fd\u66f4\u65b0", (BatchMessageTipsHeader)batchMessageTipsHeader);
        }
        billids.removeAll(errs);
        if (null != billids && !billids.isEmpty()) {
            WaterElectricityBatchListHandler.addBatchMessageTips(errs, (String)"\u4e3a\u9501\u5b9a\u72b6\u6001\u4e0d\u80fd\u66f4\u65b0", (BatchMessageTipsHeader)batchMessageTipsHeader);
        }
    }

    protected Map<String, Map<String, Object>> getPersonOccupantsList(Context ctx, Collection<String> dormitorys, LocalDate startPeriodDate, LocalDate endPeriodDate) throws BOSException, SQLException {
        String startPeriodDateStr = startPeriodDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        String endPeriodDateStr = endPeriodDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        HashMap occupantsMap = Maps.newHashMap();
        StringBuilder selCunt = new StringBuilder();
        selCunt.append(" select CFDormitoryID,CFPersonPositionID,CFCheckOutDate,CFCheckInDate from CT_OCC_Occupants ");
        selCunt.append(" where to_char(CFCheckOutDate ,'yyyy-MM-dd') >= '" + startPeriodDateStr + "' ");
        selCunt.append(" and to_char(CFCheckInDate ,'yyyy-MM-dd') <='" + endPeriodDateStr + "' ");
        selCunt.append(" and CFDormitoryID in('' ");
        for (String dormitory : dormitorys) {
            selCunt.append(",'");
            selCunt.append(dormitory);
            selCunt.append("'");
        }
        selCunt.append(" ) ");
        IRowSet rsCunt = DbUtil.executeQuery((Context)ctx, (String)selCunt.toString());
        while (rsCunt.next()) {
            String id = rsCunt.getString("CFDormitoryID");
            Map occupants = (Map)occupantsMap.get(id);
            if (null == occupants) {
                occupants = Maps.newHashMap();
                occupants.put("dormitoryID", id);
                occupants.put("days", 0L);
                occupantsMap.put(id, occupants);
            }
            LocalDate InDate = new Date(rsCunt.getDate("CFCheckInDate").getTime()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate OutDate = new Date(rsCunt.getDate("CFCheckOutDate").getTime()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            InDate = InDate.compareTo(startPeriodDate) > 0 ? InDate : startPeriodDate;
            OutDate = OutDate.compareTo(endPeriodDate) < 0 ? OutDate : endPeriodDate;
            long daysBetween = ChronoUnit.DAYS.between(InDate, OutDate);
            long days = (Long)occupants.get("days");
            occupants.put("days", days + daysBetween);
        }
        return occupantsMap;
    }

    public void lockAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        String billId = this.getBillId(request);
        Context ctx = SHRContext.getInstance().getContext();
        try {
            StringBuilder sel = new StringBuilder();
            sel.append("select fid from CT_WOE_WaterElectricity where CFStutas='Lock'  ");
            if (!StringUtils.isEmpty((String)billId)) {
                String[] ids = billId.split(",");
                HashSet errs = Sets.newHashSet();
                HashSet sess = Sets.newHashSet();
                sess.addAll(Arrays.asList(ids));
                sel.append(" and fid in('' ");
                for (String id : ids) {
                    sel.append(",'");
                    sel.append(id);
                    sel.append("'");
                }
                sel.append(")");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString());
                while (rs.next()) {
                    String id = rs.getString("fid");
                    errs.add(id);
                    WaterElectricityBatchListHandler.addBatchMessageTip((String)id, (String)"\u5df2\u7ecf\u9501\u5b9a\uff0c\u4e0d\u80fd\u518d\u6b21\u9501\u5b9a\u3002", (BatchMessageTipsHeader)batchMessageTipsHeader);
                }
                sess.removeAll(errs);
                for (String id : sess) {
                    try {
                        this.updateStutas(ctx, "enable", id);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                }
            } else {
                StringBuilder sel2 = new StringBuilder();
                sel2.append("select fid from CT_WOE_WaterElectricity where CFStutas!='Lock' ");
                HashSet errs = Sets.newHashSet();
                HashSet sess = Sets.newHashSet();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel2.toString());
                while (rs.next()) {
                    String id = rs.getString("fid");
                    this.updateStutas(ctx, "enable", id);
                    sess.add(id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unLockAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, BatchMessageTipsHeader batchMessageTipsHeader) throws SHRWebException {
        String billId = this.getBillId(request);
        Context ctx = SHRContext.getInstance().getContext();
        try {
            StringBuilder sel = new StringBuilder();
            sel.append("select fid from CT_WOE_WaterElectricity where FBillState in (2,3,4) ");
            if (!StringUtils.isEmpty((String)billId)) {
                String[] ids = billId.split(",");
                HashSet errs = Sets.newHashSet();
                HashSet sess = Sets.newHashSet();
                sess.addAll(Arrays.asList(ids));
                sel.append(" and fid in('' ");
                for (String id : ids) {
                    sel.append(",'");
                    sel.append(id);
                    sel.append("'");
                }
                sel.append(")");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel.toString());
                while (rs.next()) {
                    String id = rs.getString("fid");
                    errs.add(id);
                    WaterElectricityBatchListHandler.addBatchMessageTip((String)id, (String)"\u85aa\u8d44\u6570\u636e\u5df2\u7ecf\u9501\u5b9a\uff0c\u4e0d\u80fd\u89e3\u9501\u3002", (BatchMessageTipsHeader)batchMessageTipsHeader);
                }
                sess.removeAll(errs);
                for (String id : sess) {
                    try {
                        this.updateStutas(ctx, "disable", id);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                }
            } else {
                StringBuilder sel2 = new StringBuilder();
                sel2.append("select fid from CT_WOE_WaterElectricity where FBillState not in (2,3,4) ");
                HashSet errs = Sets.newHashSet();
                HashSet sess = Sets.newHashSet();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sel2.toString());
                while (rs.next()) {
                    String id = rs.getString("fid");
                    this.updateStutas(ctx, "disable", id);
                    sess.add(id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getBillId(HttpServletRequest request) throws SHRWebException {
        String billId = (String)request.getAttribute("billId");
        if (StringUtils.isEmpty((String)billId)) {
            billId = request.getParameter("billId");
        }
        if (StringUtils.isEmpty((String)billId)) {
            billId = request.getParameter("billID");
        }
        if (StringUtils.isEmpty((String)billId)) {
            return "";
        }
        return billId;
    }

    public abstract String getTableName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStutas(Context ctx, String math, String uuid) throws SQLException {
        Connection conn = null;
        Statement state = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            state = conn.createStatement();
            if ("enable".equals(math)) {
                state.execute("update " + this.getTableName() + " set CFStutas='Lock' where fid='" + uuid + "'");
            } else if ("disable".equals(math)) {
                state.execute("update " + this.getTableName() + " set CFStutas='UnLock' where fid='" + uuid + "' and FBillState = 0 ");
            }
        }
        catch (SQLException var32) {
            var32.printStackTrace();
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
    }

    protected void handleEnableWithTips(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String SUCCESS_MESSAGE = SHRPerfWebResourceUtil.getRes((SHRPerfWebResource)SHRPerfWebResource.OPERATESUCCESS, (Context)SHRContext.getInstance().getContext());
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        String billId = null;
        try {
            int crossTotalCount = 0;
            this.callAction(request, response, modelMap, batchMessageTipsHeader);
            if (StringUtils.isEmpty((String)this.successMessage)) {
                this.successMessage = SUCCESS_MESSAGE;
            }
            billId = this.getBillId(request);
            HashSet<String> ids2 = new HashSet<String>();
            if (!StringUtils.isEmpty((String)billId)) {
                ids2.addAll(Arrays.asList(billId.split(",")));
            }
            Set errorIds = WaterElectricityBatchListHandler.getErrorIdsByBatchMessageTip((BatchMessageTipsHeader)batchMessageTipsHeader);
            ids2.removeAll(errorIds);
            WaterElectricityBatchListHandler.addBatchMessageSuccessTips(ids2, (String)this.successMessage, (BatchMessageTipsHeader)batchMessageTipsHeader);
            List list = batchMessageTipsHeader.getResult();
            int rows = list.size();
            HashSet<String> ids = new HashSet<String>();
            for (BatchMessageTipsBody body : list) {
                ids.add(body.getId());
            }
            batchMessageTipsHeader.setBillId(WaterElectricityBatchListHandler.convertListToString(ids.toArray()));
            int failureCount = batchMessageTipsHeader.getFailureCount();
            int submitRecordsStep = rows - failureCount;
            if (submitRecordsStep < 0) {
                submitRecordsStep = crossTotalCount - failureCount;
            }
            if (submitRecordsStep < 0) {
                submitRecordsStep = 0;
            }
            batchMessageTipsHeader.setSuccessCount(submitRecordsStep);
            this.writeSuccessData(batchMessageTipsHeader);
        }
        catch (IllegalAccessException var26) {
            logger.error("", (Throwable)var26);
            throw new ShrWebBizException((Throwable)new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR));
        }
        catch (InvocationTargetException var27) {
            logger.error("", var27.getTargetException());
            throw new ShrWebBizException(var27.getCause().getMessage());
        }
        finally {
            this.setSuccessMessage(SUCCESS_MESSAGE);
        }
    }

    protected void afterGetListData(HttpServletRequest request, HttpServletResponse response, GridDataEntity gridDataEntity) throws SHRWebException {
        super.afterGetListData(request, response, gridDataEntity);
        List rows = gridDataEntity.getRows();
        this.afterGetExportData(request, response, rows);
    }

    public void afterGetExportData(HttpServletRequest request, HttpServletResponse response, List listData) throws SHRWebException {
        super.afterGetExportData(request, response, listData);
        List rows = listData;
        if (null != rows && !rows.isEmpty()) {
            for (Map map : rows) {
                HRBillStateEnum billState = (HRBillStateEnum)map.get("billState");
                map.put("billState", billState);
                map.put("billStateStr", HRBillStateExEnum.getEnum(billState.getValue()).toString());
            }
        }
    }
}

