/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;

public class CalFunctionServiceExt
extends SalaryCalFunction {
    public double getWaterOrElectPay(String type, Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter) {
        Context ctx = Tools.getInstance().getCtx();
        String key = "getWaterOrElectPay" + calScheme.getNumber() + calScheme.getPeriodYear() + calScheme.getPeriodMonth();
        Map<String, Double> dataMap = new HashMap();
        String personId = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null ? null : paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
        BigDecimal amt = BigDecimal.ZERO;
        if (personId == null) {
            return 0.0;
        }
        if (tempMap == null || tempMap.get(key) == null) {
            String sqlStr = this.getPerformanceDataSql(personId, mainTableRowFilter, calScheme);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
                while (rowSet.next()) {
                    BigDecimal speamt;
                    personId = rowSet.getString("cFPersonId");
                    BigDecimal wamt = rowSet.getBigDecimal("wamt") == null ? BigDecimal.ZERO : rowSet.getBigDecimal("wamt");
                    BigDecimal spwamt = rowSet.getBigDecimal("spwamt") == null ? BigDecimal.ZERO : rowSet.getBigDecimal("spwamt");
                    BigDecimal eamt = rowSet.getBigDecimal("eamt") == null ? BigDecimal.ZERO : rowSet.getBigDecimal("eamt");
                    BigDecimal bigDecimal = speamt = rowSet.getBigDecimal("speamt") == null ? BigDecimal.ZERO : rowSet.getBigDecimal("speamt");
                    amt = StringUtils.equals((CharSequence)"1", (CharSequence)type) ? wamt.add(spwamt) : (StringUtils.equals((CharSequence)"2", (CharSequence)type) ? eamt.add(speamt) : wamt.add(spwamt).add(eamt).add(speamt));
                    amt = amt.setScale(2, RoundingMode.HALF_UP);
                    double amtDouble = amt.doubleValue();
                    dataMap.put(String.valueOf(personId) + "_" + type, amtDouble);
                }
            }
            catch (BOSException | SQLException e) {
                e.printStackTrace();
            }
        }
        tempMap.put(key, dataMap);
        dataMap = (Map)tempMap.get(key);
        return dataMap.get(String.valueOf(personId) + "_" + type) == null ? 0.0 : (Double)dataMap.get(String.valueOf(personId) + "_" + type);
    }

    private String getPerformanceDataSql(String personId, String mainTableRowFilter, CalSchemeInfo calScheme) {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("SELECT cFPersonId, ");
        sqlStr.append("       SUM(wamt) AS wamt, ");
        sqlStr.append("       SUM(eamt) AS eamt, ");
        sqlStr.append("       SUM(spwamt) AS spwamt, ");
        sqlStr.append("       SUM(speamt) AS speamt ");
        sqlStr.append("FROM ( ");
        sqlStr.append("    SELECT defu.cFPersonId, ");
        sqlStr.append("           defu.cfmonthWaterAmount AS wamt, ");
        sqlStr.append("           defu.cfmonthElectricityAmount AS eamt, ");
        sqlStr.append("           0 AS spwamt, ");
        sqlStr.append("           0 AS speamt ");
        sqlStr.append("    FROM CT_WOE_WaterElectricity defu ");
        sqlStr.append("    WHERE ");
        if (mainTableRowFilter == null) {
            sqlStr.append("        defu.cFPersonId = '").append(personId).append("' ");
        } else {
            sqlStr.append("        defu.cFPersonId IN (SELECT FPersonId FROM t_hr_scmpcaltable ");
            sqlStr.append("                          WHERE ").append(mainTableRowFilter).append(") ");
        }
        sqlStr.append("    AND defu.CFYearMonth = '").append(calScheme.getPeriodYear()).append("-").append(calScheme.getPeriodMonth()).append("' ");
        sqlStr.append("    AND defu.fbillstate = '3' ");
        sqlStr.append("    UNION ALL ");
        sqlStr.append("    SELECT special.CFPersonId, ");
        sqlStr.append("           0 AS wamt, ");
        sqlStr.append("           0 AS eamt, ");
        sqlStr.append("           special.CFMonthWaterAmount AS spwamt, ");
        sqlStr.append("           special.CFelectricityTotalCost AS speamt ");
        sqlStr.append("    FROM CT_WOE_WaterElectricitySpecial special ");
        sqlStr.append("    WHERE ");
        if (mainTableRowFilter == null) {
            sqlStr.append("        special.CFPersonID = '").append(personId).append("' ");
        } else {
            sqlStr.append("        special.CFPersonID IN (SELECT FPersonId FROM t_hr_scmpcaltable ");
            sqlStr.append("                              WHERE ").append(mainTableRowFilter).append(") ");
        }
        sqlStr.append("    AND special.CFYearMonth = '").append(calScheme.getPeriodYear()).append("-").append(calScheme.getPeriodMonth()).append("' ");
        sqlStr.append("    AND special.fbillstate = '3' ");
        sqlStr.append(") combined_data ");
        sqlStr.append("GROUP BY cFPersonId ");
        return sqlStr.toString();
    }
}

