/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.dormitorysystem.application.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.CheckInApplicationInfo;
import com.kingdee.eas.custom.dormitorysystem.application.CheckoutApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.ICheckInApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.ICheckoutApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.IRoomChangeApplicationEntry;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryCollection;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryFactory;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationEntryInfo;
import com.kingdee.eas.custom.dormitorysystem.application.RoomChangeApplicationInfo;
import com.kingdee.eas.custom.dormitorysystem.occupants.IOccupants;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsCollection;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsFactory;
import com.kingdee.eas.custom.dormitorysystem.occupants.OccupantsInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CheckDuplicateCheckInByBillIdUtil {
    private static Logger logger = Logger.getLogger(CheckDuplicateCheckInByBillIdUtil.class);

    public static void startValidate(Context ctx, String billIds) throws BOSException {
        if (StringUtils.isEmpty((String)billIds)) {
            logger.error((Object)"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!");
            throw new BOSException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap roomListMap = new HashMap();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)billIds.split(",")[0]).getType());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.person.*");
        sic.add("entrys.person.personType.*");
        sic.add("entrys.checkInRoom.*");
        sic.add("entrys.checkInRoom.DormitoryType.*");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("id", (Object)AtsUtil.toSet((String)billIds), CompareType.INCLUDE));
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        CoreBillBaseCollection hrBillBaseCollection = iCoreBillBase.getCoreBillBaseCollection(viewInfo);
        int i = 0;
        while (i < hrBillBaseCollection.size()) {
            HRBillBaseInfo hrBillBaseInfo = (HRBillBaseInfo)hrBillBaseCollection.get(i);
            String baseInfoNumber = hrBillBaseInfo.getNumber();
            AbstractObjectCollection entrys = (AbstractObjectCollection)hrBillBaseInfo.get("entrys");
            int j = 0;
            while (j < entrys.size()) {
                try {
                    HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(j);
                    Date checkInDate = entryInfo.getDate("checkInDate");
                    if (checkInDate == null) {
                        throw new BOSException("\u5165\u4f4f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    Date checkoutDate = entryInfo.getDate("checkoutDate");
                    if (checkoutDate == null) {
                        throw new BOSException("\u9000\u5bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    PersonInfo personInfo = (PersonInfo)entryInfo.getObjectValue("person");
                    if (personInfo == null) {
                        throw new BOSException("\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    CheckDuplicateCheckInByBillIdUtil.checkDuplicateCheckIn(ctx, personInfo, checkInDate, checkoutDate, entryInfo);
                    CheckDuplicateCheckInByBillIdUtil.checkDuplicateOccupants(ctx, personInfo, checkInDate, checkoutDate);
                    CheckDuplicateCheckInByBillIdUtil.checkDuplicateRoomChange(ctx, personInfo, checkInDate, checkoutDate);
                }
                catch (Exception e) {
                    logger.error((Object)("\u5355\u636e\u7f16\u53f7\u4e3a" + baseInfoNumber + "\u6821\u9a8c\u672a\u901a\u8fc7: " + e.getMessage()));
                    errorMsgList.add("\u5355\u636e\u7f16\u53f7\u4e3a" + baseInfoNumber + "\u6821\u9a8c\u672a\u901a\u8fc7: " + e.getMessage());
                }
                ++j;
            }
            ++i;
        }
        if (!errorMsgList.isEmpty()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            for (String errorMsg : errorMsgList) {
                errorMsgBuilder.append(errorMsg).append("\n");
            }
            throw new BOSException(errorMsgBuilder.toString());
        }
    }

    protected static void checkDuplicateRoomChange(Context ctx, PersonInfo personInfo, java.util.Date checkInDate, java.util.Date checkoutDate) throws BOSException {
        String personInfoName = personInfo.getName();
        IRoomChangeApplicationEntry iRoomChangeApplicationEntry = RoomChangeApplicationEntryFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("person", (Object)personInfo.getId()));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("checkoutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkoutDate, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4))");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.number");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        RoomChangeApplicationEntryCollection entryCollection = iRoomChangeApplicationEntry.getRoomChangeApplicationEntryCollection(viewInfo);
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;
        while (i < entryCollection.size()) {
            RoomChangeApplicationEntryInfo roomChangeApplicationEntryInfo = entryCollection.get(i);
            RoomChangeApplicationInfo parent = roomChangeApplicationEntryInfo.getParent();
            String number = parent.getNumber();
            errorMsg.append("\u5458\u5de5[" + personInfoName + "]\u5728[" + sdf.format(checkInDate) + "] ~ [" + sdf.format(checkoutDate) + "]\u671f\u95f4\u4e0e\u6362\u5bbf\u7533\u8bf7\u5355[" + number + "]\u65e5\u671f\u5b58\u5728\u4ea4\u53c9\n");
            ++i;
        }
        if (errorMsg.length() > 0) {
            throw new BOSException(errorMsg.toString());
        }
    }

    protected static void checkDuplicateOccupants(Context ctx, PersonInfo personInfo, java.util.Date checkInDate, java.util.Date checkoutDate) throws BOSException {
        String personInfoName = personInfo.getName();
        IOccupants iOccupants = OccupantsFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("person", (Object)personInfo.getId()));
        filterItems.add(new FilterItemInfo("CheckInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("CheckOutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("CheckInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("CheckInDate", (Object)checkoutDate, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4))");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.number");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        OccupantsCollection occupantsCollection = iOccupants.getOccupantsCollection(viewInfo);
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (occupantsCollection.size() > 0) {
            errorMsg.append("\u5458\u5de5[" + personInfoName + "]\u5728[" + sdf.format(checkInDate) + "] ~ [" + sdf.format(checkoutDate) + "]\u671f\u95f4\u4e0e\u5165\u4f4f\u4fe1\u606f\u6570\u636e\u5b58\u5728\u65e5\u671f\u4ea4\u53c9\n");
            throw new BOSException(errorMsg.toString());
        }
    }

    protected static void checkDuplicateCheckIn(Context ctx, PersonInfo personInfo, java.util.Date checkInDate, java.util.Date checkoutDate, HRBillBaseEntryInfo entryInfo) throws BOSException {
        String personInfoName = personInfo.getName();
        String entryId = entryInfo.getId().toString();
        ICheckInApplicationEntry iCheckInApplicationEntry = CheckInApplicationEntryFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("parent.billState", (Object)"1,2,3", CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("checkoutDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkInDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("checkInDate", (Object)checkoutDate, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("person", (Object)personInfo.getId()));
        filterItems.add(new FilterItemInfo("id", (Object)entryId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) and #5 and #6");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.number");
        sic.add("occupants.id");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        CheckInApplicationEntryCollection entryCollection = iCheckInApplicationEntry.getCheckInApplicationEntryCollection(viewInfo);
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        IRoomChangeApplicationEntry iRoomChangeApplicationEntry = RoomChangeApplicationEntryFactory.getLocalInstance((Context)ctx);
        ICheckoutApplicationEntry iCheckoutApplicationEntry = CheckoutApplicationEntryFactory.getLocalInstance(ctx);
        int i = 0;
        while (i < entryCollection.size()) {
            block8: {
                CheckInApplicationEntryInfo checkInApplicationEntryInfo;
                block9: {
                    checkInApplicationEntryInfo = entryCollection.get(i);
                    OccupantsInfo occupants = checkInApplicationEntryInfo.getOccupants();
                    if (occupants != null) {
                        FilterItemCollection existsFilterItems;
                        FilterInfo existsFilter;
                        String occupantsId;
                        block7: {
                            occupantsId = occupants.getId().toString();
                            try {
                                existsFilter = new FilterInfo();
                                existsFilterItems = existsFilter.getFilterItems();
                                existsFilterItems.add(new FilterItemInfo("parent.billState", (Object)"3"));
                                existsFilterItems.add(new FilterItemInfo("occupants", (Object)occupantsId));
                                if (!iCheckoutApplicationEntry.exists(existsFilter)) break block7;
                                break block8;
                            }
                            catch (EASBizException e) {
                                logger.error((Object)("\u6821\u9a8c\u9000\u5bbf\u5355\u62a5\u9519:" + e.getMessage()), (Throwable)e);
                                throw new BOSException((Throwable)e);
                            }
                        }
                        try {
                            existsFilter = new FilterInfo();
                            existsFilterItems = existsFilter.getFilterItems();
                            existsFilterItems.add(new FilterItemInfo("parent.billState", (Object)"3"));
                            existsFilterItems.add(new FilterItemInfo("oldOccupants", (Object)occupantsId));
                            if (!iRoomChangeApplicationEntry.exists(existsFilter)) break block9;
                            break block8;
                        }
                        catch (EASBizException e) {
                            logger.error((Object)("\u6821\u9a8c\u6362\u5bbf\u5355\u62a5\u9519:" + e.getMessage()), (Throwable)e);
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
                CheckInApplicationInfo parent = checkInApplicationEntryInfo.getParent();
                String number = parent.getNumber();
                errorMsg.append("\u5458\u5de5[" + personInfoName + "]\u5728[" + sdf.format(checkInDate) + "] ~ [" + sdf.format(checkoutDate) + "]\u671f\u95f4\u4e0e\u5165\u4f4f\u7533\u8bf7\u5355[" + number + "]\u65e5\u671f\u5b58\u5728\u4ea4\u53c9\n");
            }
            ++i;
        }
        if (errorMsg.length() > 0) {
            throw new BOSException(errorMsg.toString());
        }
    }
}

