/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.HSMCmd;
import com.sansec.devicev4.gb.GBAlgorithmID_SGD;
import com.sansec.devicev4.gb.GBKeyConst;
import com.sansec.devicev4.gb.struct.DeviceInfo;
import com.sansec.devicev4.gb.struct.DeviceRunStatus;
import com.sansec.devicev4.gb.struct.key.ByteKeyPair;
import com.sansec.devicev4.gb.struct.key.IDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCSignature;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefCurveParam;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefKeyPair;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefPrivateKey;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECIESrefCipher;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefSignature;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.ECDSAUtil;
import com.sansec.devicev4.util.HashUtil;
import com.sansec.devicev4.util.SymmetryUtil;
import com.sun.jna.Structure;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Logger;

public class CMDCrypto
implements ISDSCrypto {
    private static final boolean racalSupport = true;
    public static final Logger logger = CryptoLogger.logger;

    @Override
    public byte[] generateRandom(int length) throws CryptoException {
        int nLeftLen;
        logger.info("-> CMDCrypto.generateRandom()...");
        if (length < 1) {
            throw new CryptoException("Random length is too short error(" + length + ")");
        }
        byte[] output = new byte[length];
        byte[] bufOutput = null;
        for (nLeftLen = length; nLeftLen > 8000; nLeftLen -= 8000) {
            try {
                bufOutput = HSMCmd.generateRandom(8000);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Random generation error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOutput, 0, output, output.length - nLeftLen, 8000);
        }
        try {
            bufOutput = HSMCmd.generateRandom(nLeftLen);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Random generation error: " + ex.getMessage(), ex);
        }
        System.arraycopy(bufOutput, 0, output, output.length - nLeftLen, nLeftLen);
        logger.info("-> CMDCrypto.generateRandom() end.");
        return output;
    }

    @Override
    public DeviceInfo getDeviceInfo() throws CryptoException {
        logger.info("-> CMDCrypto.getDeviceInfo()...");
        try {
            byte[] output = HSMCmd.getDeviceInfo();
            DeviceInfo info = new DeviceInfo();
            info.decode(output);
            logger.info("-> CMDCrypto.getDeviceInfo() end.");
            return info;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Get device info error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public DeviceRunStatus getDeviceRunStatus() throws CryptoException {
        throw new CryptoException("HSM not support this function!");
    }

    @Override
    public IRSArefPublicKey getRSAPublicKey(int keyIndex, int kpType) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal keyType parameter(" + kpType + ")");
        }
        int keyUsage = 65792;
        if (kpType == 2) {
            keyUsage = 66048;
        }
        try {
            byte[] pubKeyData = HSMCmd.exportPublicKey(keyIndex, keyUsage);
            Structure publicKey = null;
            publicKey = pubKeyData.length == RSArefPublicKeyLite.sizeof() ? new RSArefPublicKeyLite() : new RSArefPublicKeyEx();
            publicKey.decode(pubKeyData);
            return publicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get RSA( No. " + keyIndex + ")" + GBKeyConst.toKeyPairName(kpType) + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public RSArefKeyPair generateRSAKeyPair(int keysize) throws CryptoException {
        if (keysize < 1024 || keysize > 4096 || keysize % 128 != 0) {
            throw new CryptoException("Illegal parameter,RSA  keysize (" + keysize + ")");
        }
        try {
            ByteKeyPair keypair = HSMCmd.generateKeyPair(keysize, 65536);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            Structure publicKey = null;
            Structure privateKey = null;
            if (pubKeyData.length == RSArefPublicKeyLite.sizeof()) {
                publicKey = new RSArefPublicKeyLite();
                privateKey = new RSArefPrivateKeyLite();
            } else {
                publicKey = new RSArefPublicKeyEx();
                privateKey = new RSArefPrivateKeyEx();
            }
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new RSArefKeyPair((IRSArefPublicKey)((Object)publicKey), (IRSArefPrivateKey)((Object)privateKey));
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generation(" + keysize + ")RSA keypair error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public RSArefKeyPair generateRSAKeyPair(int keysize, int exponent) throws CryptoException {
        if (keysize < 1024 || keysize > 4096 || keysize % 128 != 0) {
            throw new CryptoException("Illegal RSA key modulus( " + keysize + " )");
        }
        if (exponent != 3 && exponent != 65537) {
            throw new CryptoException("Illegal RSA exponent ( " + exponent + " )");
        }
        try {
            ByteKeyPair keypair = HSMCmd.generateRSAKeyPairEx(keysize, exponent);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            Structure publicKey = null;
            Structure privateKey = null;
            if (pubKeyData.length == RSArefPublicKeyLite.sizeof()) {
                publicKey = new RSArefPublicKeyLite();
                privateKey = new RSArefPrivateKeyLite();
            } else {
                publicKey = new RSArefPublicKeyEx();
                privateKey = new RSArefPrivateKeyEx();
            }
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new RSArefKeyPair((IRSArefPublicKey)((Object)publicKey), (IRSArefPrivateKey)((Object)privateKey));
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate ( " + keysize + "bits )RSA key pair error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public void generateRSAKeyPair(int keyIndex, int keyType, int keysize) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal keyType parameter: " + keyType);
        }
        if (keysize < 1024 || keysize > 4096 || keysize % 128 != 0) {
            throw new CryptoException("Illegal RSA length parameter(" + keysize + ")");
        }
        keyIndex *= 2;
        if (keyType == 1) {
            --keyIndex;
        }
        try {
            HSMCmd.generateKeyPair(keysize, 65536, keyIndex);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generation(No." + keyIndex + " Type:" + keyType + " Size:" + keysize + ")RSA keypair error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] rsaPrivateKeyOperation(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal keyType parameter: " + kpType);
        }
        if (input == null) {
            throw new CryptoException("Input operation data is null.");
        }
        int keyUsage = 65792;
        if (kpType == 2) {
            keyUsage = 66048;
        }
        try {
            byte[] output = HSMCmd.rsaPrivateKeyOperation(keyIndex, keyUsage, null, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner RSA(No." + keyIndex + ") private key operat error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] rsaPublicKeyOperation(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal keyType parameter: " + kpType);
        }
        if (input == null) {
            throw new CryptoException("Input operation data is null.");
        }
        IRSArefPublicKey refPublicKey = this.getRSAPublicKey(keyIndex, kpType);
        if (refPublicKey.getBits() >> 3 != input.length) {
            throw new CryptoException("Operation data length not equal key length, key size: data length(" + (refPublicKey.getBits() >> 3) + ":" + input.length + ")");
        }
        int keyUsage = 65792;
        if (kpType == 2) {
            keyUsage = 66048;
        }
        try {
            byte[] output = HSMCmd.rsaPublicKeyOperation(keyIndex, keyUsage, null, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner RSA(No." + keyIndex + ")public key operation error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] rsaPublicKeyOperation(IRSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("Public key is null");
        }
        if (input == null) {
            throw new CryptoException("Input operation data is null.");
        }
        if (refPublicKey.getBits() >> 3 != input.length) {
            throw new CryptoException("Operation data length not equal key length, key size: data length(" + (refPublicKey.getBits() >> 3) + ":" + input.length + ")");
        }
        try {
            byte[] output = HSMCmd.rsaPublicKeyOperation(0, 0, refPublicKey, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External RSA public key operation error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("Private key is null");
        }
        if (input == null) {
            throw new CryptoException("Input operation data is null.");
        }
        if (refPrivateKey.getBits() >> 3 != input.length) {
            throw new CryptoException("Operation data length not equal key length, key size: data length(" + (refPrivateKey.getBits() >> 3) + ":" + input.length + ")");
        }
        try {
            byte[] output = HSMCmd.rsaPrivateKeyOperation(0, 0, refPrivateKey, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External RSA private key operation error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public SM2refPublicKey getSM2PublicKey(int keyIndex, int kpType) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal keyType parameter(" + kpType + ")");
        }
        int keyUsage = 131328;
        if (kpType == 2) {
            keyUsage = 132096;
        }
        try {
            byte[] pubKeyData = HSMCmd.exportPublicKey(keyIndex, keyUsage);
            SM2refPublicKey refPublicKey = new SM2refPublicKey();
            refPublicKey.decode(pubKeyData);
            return refPublicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Get SM2(No." + keyIndex + ")" + GBKeyConst.toKeyPairName(kpType) + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        if (keysize != 256) {
            throw new CryptoException("Illegal SM2 keySize parameter(" + keysize + ")");
        }
        try {
            ByteKeyPair keypair = HSMCmd.generateKeyPair(keysize, 131072);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            SM2refPublicKey publicKey = new SM2refPublicKey();
            SM2refPrivateKey privateKey = new SM2refPrivateKey();
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new SM2refKeyPair(publicKey, privateKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate(" + keysize + ")SM2 key pair error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void generateSM2KeyPair(int keyIndex, int keyType, int keysize) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal keyType parameter: " + keyType);
        }
        if (keysize != 256) {
            throw new CryptoException("Illegal SM2 key length parameter(" + keysize + ")");
        }
        int keyNum = keyIndex * 2;
        if (keyType == 1) {
            --keyNum;
        }
        try {
            HSMCmd.generateKeyPair(keysize, 131072, keyNum);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate(No." + keyIndex + " KeyType:" + keyType + " KeySize:" + keysize + ")SM2 key pair error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] sm2Decrypt(int keyIndex, int kpType, SM2refCipher refCipher) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal keyType parameter(" + kpType + ")");
        }
        if (refCipher == null) {
            throw new CryptoException("refCipher is null");
        }
        int keyUsage = 131328;
        if (kpType == 2) {
            keyUsage = 132096;
        }
        try {
            byte[] output = HSMCmd.sm2Decrypt(keyUsage, keyIndex, null, refCipher);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner SM2(No." + keyIndex + ") decrypt error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] sm2Decrypt(SM2refPrivateKey refPrivateKey, SM2refCipher refCipher) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("refPrivateKey is null");
        }
        if (refCipher == null) {
            throw new CryptoException("refCipher is null");
        }
        int keyUsage = 131328;
        try {
            byte[] output = HSMCmd.sm2Decrypt(keyUsage, 0, refPrivateKey, refCipher);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External SM2 decrypt error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public SM2refCipher sm2Encrypt(int keyIndex, int kpType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal keyType parameter(" + kpType + ")");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 131328;
        if (kpType == 2) {
            keyUsage = 132096;
        }
        try {
            SM2refCipher refCipher = HSMCmd.sm2Encrypt(keyUsage, keyIndex, null, input);
            return refCipher;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner SM2(No." + keyIndex + ")encrypt error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public SM2refCipher sm2Encrypt(SM2refPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("refPublicKey is null.");
        }
        if (input == null) {
            throw new CryptoException("input data is null.");
        }
        if (input.length > 136) {
            throw new CryptoException("Input length too long(136) error (" + input.length + ")");
        }
        int keyUsage = 131328;
        try {
            SM2refCipher refCipher = HSMCmd.sm2Encrypt(keyUsage, 0, refPublicKey, input);
            return refCipher;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External SM2 encrypt error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public SM2refSignature sm2Sign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (input == null) {
            throw new CryptoException("Input data is null.");
        }
        if (input.length != 32) {
            throw new CryptoException("Input length too long(32) error(" + input.length + ")");
        }
        int keyUsage = 131328;
        if (keyType == 2) {
            keyUsage = 132096;
        }
        try {
            SM2refSignature refSig = HSMCmd.sm2Sign(keyUsage, keyIndex, null, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner SM2(No." + keyIndex + ") sign error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public SM2refSignature sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("refPrivateKey is null");
        }
        if (input == null) {
            throw new CryptoException("input data is null");
        }
        if (input.length != 32) {
            throw new CryptoException("Input length too long(32) error(" + input.length + ")");
        }
        int keyUsage = 131328;
        try {
            SM2refSignature refSig = HSMCmd.sm2Sign(keyUsage, 0, refPrivateKey, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External SM2 sign error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean sm2Verify(int keyIndex, int keyType, byte[] input, SM2refSignature refSig) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        if (input.length != 32) {
            throw new CryptoException("Input length error(need 32)(" + input.length + ")");
        }
        if (refSig == null) {
            throw new CryptoException("refSig is null");
        }
        int keyUsage = 131328;
        if (keyType == 2) {
            keyUsage = 132096;
        }
        try {
            boolean flag = HSMCmd.sm2Verify(keyUsage, keyIndex, null, input, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner SM2(No." + keyIndex + ") verify error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] input, SM2refSignature refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("refPublicKey is null");
        }
        if (input == null) {
            throw new CryptoException("input data is null");
        }
        if (input.length != 32) {
            throw new CryptoException("Input length error(need 32)(" + input.length + ")");
        }
        if (refSig == null) {
            throw new CryptoException("refSig is null");
        }
        int keyUsage = 131328;
        try {
            boolean flag = HSMCmd.sm2Verify(keyUsage, 0, refPublicKey, input, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External SM2 verify error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void generateKey(int keyIndex, int keysize) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (keysize != 256 && keysize != 128) {
            throw new CryptoException("Illegal keySize parameter(need 128,256)(" + keysize + ")");
        }
        try {
            HSMCmd.generateKey(keysize, keyIndex);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate(No." + keyIndex + " KeySize:" + keysize + ") Key error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] encrypt(int algoType, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (key == null) {
            throw new CryptoException("key is null");
        }
        if (input == null) {
            throw new CryptoException("input data is null");
        }
        if (!SymmetryUtil.isRightInput(algoType, input)) {
            throw new CryptoException("Integer multiple of the non grouped length of the input data");
        }
        byte[] output = null;
        if (input.length > 8000) {
            int nLeftLen;
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            for (nLeftLen = input.length; nLeftLen > 8000; nLeftLen -= 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                try {
                    bufOut = HSMCmd.encrypt(algoType, 0, key, iv, bufIn);
                }
                catch (CryptoException ex) {
                    throw new CryptoException("External key(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
                }
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufOut, 8000 - iv.length, iv, 0, iv.length);
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            try {
                bufOut = HSMCmd.encrypt(algoType, 0, key, iv, bufIn);
            }
            catch (CryptoException ex) {
                throw new CryptoException("External key(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufOut, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            try {
                output = HSMCmd.encrypt(algoType, 0, key, iv, input);
            }
            catch (CryptoException ex) {
                throw new CryptoException("External key(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
            }
        }
        return output;
    }

    @Override
    public byte[] decrypt(int algoType, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (key == null) {
            throw new CryptoException("key is null");
        }
        if (input == null) {
            throw new CryptoException("input is null");
        }
        if (!SymmetryUtil.isRightInput(algoType, input)) {
            throw new CryptoException("Integer multiple of the non grouped length of the input data");
        }
        byte[] output = null;
        if (input.length > 8000) {
            int nLeftLen;
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            for (nLeftLen = input.length; nLeftLen > 8000; nLeftLen -= 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                try {
                    bufOut = HSMCmd.decrypt(algoType, 0, key, iv, bufIn);
                }
                catch (CryptoException ex) {
                    throw new CryptoException("External key(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
                }
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufIn, 8000 - iv.length, iv, 0, iv.length);
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            try {
                bufOut = HSMCmd.decrypt(algoType, 0, key, iv, bufIn);
            }
            catch (CryptoException ex) {
                throw new CryptoException("External key (" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufIn, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            try {
                output = HSMCmd.decrypt(algoType, 0, key, iv, input);
            }
            catch (CryptoException ex) {
                throw new CryptoException("External key(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
            }
        }
        return output;
    }

    @Override
    public byte[] encrypt(int algoType, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (input == null) {
            throw new CryptoException("input data is null");
        }
        if (!SymmetryUtil.isRightInput(algoType, input)) {
            throw new CryptoException("Integer multiple of the non grouped length of the input data");
        }
        byte[] output = null;
        if (input.length > 8000) {
            int nLeftLen;
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            for (nLeftLen = input.length; nLeftLen > 8000; nLeftLen -= 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                try {
                    bufOut = HSMCmd.encrypt(algoType, keyIndex, null, iv, bufIn);
                }
                catch (CryptoException ex) {
                    throw new CryptoException("Inner key (No." + keyIndex + ") (" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
                }
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufOut, 8000 - iv.length, iv, 0, iv.length);
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            try {
                bufOut = HSMCmd.encrypt(algoType, keyIndex, null, iv, bufIn);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(No." + keyIndex + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufOut, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            try {
                output = HSMCmd.encrypt(algoType, keyIndex, null, iv, input);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(" + keyIndex + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
            }
        }
        return output;
    }

    @Override
    public byte[] decrypt(int algoType, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (input == null) {
            throw new CryptoException("input is null");
        }
        if (!SymmetryUtil.isRightInput(algoType, input)) {
            throw new CryptoException("Integer multiple of the non grouped length of the input data");
        }
        byte[] output = null;
        if (input.length > 8000) {
            int nLeftLen;
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            for (nLeftLen = input.length; nLeftLen > 8000; nLeftLen -= 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                try {
                    bufOut = HSMCmd.decrypt(algoType, keyIndex, null, iv, bufIn);
                }
                catch (CryptoException ex) {
                    throw new CryptoException("Inner key(No." + keyIndex + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
                }
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufIn, 8000 - iv.length, iv, 0, iv.length);
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            try {
                bufOut = HSMCmd.decrypt(algoType, keyIndex, null, iv, bufIn);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(No." + keyIndex + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufIn, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            try {
                output = HSMCmd.decrypt(algoType, keyIndex, null, iv, input);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(No." + keyIndex + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
            }
        }
        return output;
    }

    @Override
    public byte[] encrypt_add(int algoType, byte[] key, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (key == null) {
            throw new CryptoException("Key is null");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        if (input.length > 8000) {
            throw new CryptoException("Input data cannot > 8000 byte.");
        }
        try {
            byte[] output = HSMCmd.encrypt_add(algoType, 0, key, iv, input, addInput);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External symmetric key ( " + GBKeyConst.toKeyPairName(algoType) + " ) encryption error:" + ex.getMessage());
        }
    }

    @Override
    public byte[] decrypt_add(int algoType, byte[] key, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (key == null) {
            throw new CryptoException("Key is null");
        }
        if (input == null) {
            throw new CryptoException("Ciphertext is null");
        }
        if (input.length > 8000) {
            throw new CryptoException("Ciphertext cannot > 8000 byte.");
        }
        try {
            byte[] output = HSMCmd.decrypt_add(algoType, 0, key, iv, input, addInput);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External symmetric key ( " + GBKeyConst.toKeyPairName(algoType) + " ) decyption error:" + ex.getMessage());
        }
    }

    @Override
    public byte[] encrypt_add(int algoType, int keyIndex, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        if (input.length > 8000) {
            throw new CryptoException("Input data cannot > 8000 byte.");
        }
        try {
            byte[] output = HSMCmd.encrypt_add(algoType, keyIndex, null, iv, input, addInput);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External symmetric key( " + GBKeyConst.toKeyPairName(algoType) + " ) encrytption error:" + ex.getMessage());
        }
    }

    @Override
    public byte[] decrypt_add(int algoType, int keyIndex, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        if (!SymmetryUtil.isRightAlg(algoType)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algoType));
        }
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("Ciphertext is null");
        }
        if (input.length > 8000) {
            throw new CryptoException("Input data cannot > 8000 byte.");
        }
        try {
            byte[] output = HSMCmd.decrypt_add(algoType, keyIndex, null, iv, input, addInput);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External symmetric key ( " + GBKeyConst.toKeyPairName(algoType) + " ) decryption error:" + ex.getMessage());
        }
    }

    @Override
    public void rsaImportKeyPair(int keyIndex, int kpType, IRSArefPublicKey refPublicKey, IRSArefPrivateKey refPrivateKey) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (kpType != 2 && kpType != 1) {
            throw new CryptoException("Illegal KeyType parameter: " + kpType);
        }
        if (refPublicKey == null) {
            throw new CryptoException("refPublicKey is null");
        }
        if (refPrivateKey == null) {
            throw new CryptoException("refPrivateKey is null");
        }
        keyIndex = kpType == 2 ? (keyIndex *= 2) : keyIndex * 2 - 1;
        try {
            HSMCmd.importKeyPair(65536, keyIndex, refPrivateKey.getBits(), refPublicKey.encode(), refPrivateKey.encode());
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import RSA(No." + keyIndex + ")" + GBKeyConst.toKeyPairName(kpType) + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] keyAgreement_SM2(int flag, int keyIndex, SM2refPublicKey ownTmpPubKey, SM2refPrivateKey ownTmpPriKey, SM2refPublicKey opPubKey, SM2refPublicKey opTmpPubKey, int keyBits, byte[] ownId, byte[] opId) throws CryptoException {
        if (flag != 0) {
            flag = 1;
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index: " + keyIndex);
        }
        if (ownTmpPubKey == null) {
            throw new CryptoException("ownTmpPubKey The initiator temporary SM2 public key parameter cannot be null");
        }
        if (ownTmpPriKey == null) {
            throw new CryptoException("ownTmpPriKey The initiator temporary SM2 private key parameter cannot be null");
        }
        if (opPubKey == null) {
            throw new CryptoException("opPubKey The responder SM2 public key parameter cannot be null");
        }
        if (opTmpPubKey == null) {
            throw new CryptoException("opTmpPubKey The responding party temporary SM2 public key parameter cannot be null");
        }
        if (keyBits <= 0) {
            throw new CryptoException("key length cannot be less than or equal to 0\uff0ckeyBits=" + keyBits);
        }
        if (ownId == null) {
            throw new CryptoException("ownId Initiator ID parameter cannot be null");
        }
        if (opId == null) {
            throw new CryptoException("opId responder ID parameter cannot be null");
        }
        try {
            return HSMCmd.keyAgreement_SM2(flag, keyIndex, ownTmpPubKey, ownTmpPriKey, opPubKey, opTmpPubKey, keyBits, ownId, opId);
        }
        catch (CryptoException ex) {
            throw new CryptoException("keyAgreement_SM2 Key agreement error:" + ex.getMessage());
        }
    }

    @Override
    public int[] getKeyStatus(int keyType) throws CryptoException {
        if (keyType != 4 && keyType != 3 && keyType != 1) {
            throw new CryptoException("Illegal keyType parameter:" + keyType);
        }
        try {
            return HSMCmd.getKeyStatus(keyType);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Get" + keyType + " key status error\uff1a" + ex.getMessage(), ex);
        }
    }

    @Override
    public void sm2ImportKeyPair(int keyIndex, int keyType, SM2refPublicKey refPublicKey, SM2refPrivateKey refPrivateKey) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal keyType parameter: " + keyType);
        }
        if (refPublicKey == null) {
            throw new CryptoException("refPublicKey is null");
        }
        if (refPrivateKey == null) {
            throw new CryptoException("refPrivateKey is null");
        }
        keyIndex = keyType == 2 ? (keyIndex *= 2) : keyIndex * 2 - 1;
        try {
            HSMCmd.importKeyPair(131072, keyIndex, refPrivateKey.getBits(), refPublicKey.encode(), refPrivateKey.encode());
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import RSA(No." + keyIndex + ")" + GBKeyConst.toKeyPairName(keyType) + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public ECDSArefKeyPair generateECDSAKeyPair(int keysize, int curetype) throws CryptoException {
        if (!ECDSAUtil.checkCurveType(curetype)) {
            throw new CryptoException("Illegal ECDSA curve parameters( " + curetype + " )");
        }
        if (!ECDSAUtil.checkKeyLength(curetype, keysize)) {
            throw new CryptoException("Illegal ECDSA curve parameters( " + curetype + " )," + "key modulus( " + keysize + " )");
        }
        try {
            ByteKeyPair keypair = HSMCmd.generateECDSAKeyPair(keysize, 524288, curetype);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            ECDSArefPublicKey publicKey = new ECDSArefPublicKey();
            ECDSArefPrivateKey privateKey = new ECDSArefPrivateKey();
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new ECDSArefKeyPair(publicKey, privateKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate ( " + keysize + "bits)ECDSA key pair error:" + ex.getMessage());
        }
    }

    @Override
    public ECDSArefPublicKey getECDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal key type( " + keyType + " )");
        }
        int keyUsage = 524544;
        if (keyType == 2) {
            keyUsage = 524800;
        }
        try {
            byte[] pubKeyData = HSMCmd.exportPublicKey(keyIndex, keyUsage);
            ECDSArefPublicKey refPublicKey = new ECDSArefPublicKey();
            refPublicKey.decode(pubKeyData);
            return refPublicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Export ECDSA(" + keyIndex + ")" + GBKeyConst.toKeyPairName(keyType) + " error:" + ex.getMessage());
        }
    }

    @Override
    public ECIESrefCipher ecdsaEncrypt(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 524544;
        if (keyType == 2) {
            keyUsage = 524800;
        }
        try {
            ECIESrefCipher eciesrefCipher = HSMCmd.ecdsaEncrypt(keyUsage, keyIndex, null, input);
            return eciesrefCipher;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal ECDSA encrypt error: " + ex.getMessage());
        }
    }

    @Override
    public ECIESrefCipher ecdsaEncrypt(ECDSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException(" PublicKey is null)");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 524544;
        try {
            ECIESrefCipher eciesrefCipher = HSMCmd.ecdsaEncrypt(keyUsage, 0, refPublicKey, input);
            return eciesrefCipher;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External ECDSA encrypt error: " + ex.getMessage());
        }
    }

    @Override
    public byte[] ecdsaDecrypt(int keyIndex, int keyType, ECIESrefCipher cipher) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (cipher == null) {
            throw new CryptoException("Cipher data is null");
        }
        int keyUsage = 524544;
        if (keyType == 2) {
            keyUsage = 524800;
        }
        try {
            byte[] out = HSMCmd.ecdsaDecrypt(keyUsage, keyIndex, null, cipher);
            return out;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal ECDSA decrypt error: " + ex.getMessage());
        }
    }

    @Override
    public byte[] ecdsaDecrypt(ECDSArefPrivateKey refPrivateKey, ECIESrefCipher cipher) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("PrivateKey is null)");
        }
        if (cipher == null) {
            throw new CryptoException("Cipher data is null");
        }
        int keyUsage = 524544;
        try {
            byte[] out = HSMCmd.ecdsaDecrypt(keyUsage, 0, refPrivateKey, cipher);
            return out;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External ECDSA decrypt error: " + ex.getMessage());
        }
    }

    @Override
    public ECDSArefSignature ecdsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 524544;
        if (keyType == 2) {
            keyUsage = 524800;
        }
        try {
            ECDSArefSignature refSig = HSMCmd.ecdsaSign(keyUsage, keyIndex, null, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal ECDSAsign error: " + ex.getMessage());
        }
    }

    @Override
    public ECDSArefSignature ecdsaSign(ECDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("Private key is null");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 524544;
        try {
            ECDSArefSignature refSig = HSMCmd.ecdsaSign(keyUsage, 0, refPrivateKey, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External ECDSA signature error: " + ex.getMessage());
        }
    }

    @Override
    public boolean ecdsaVerify(int keyIndex, int keyType, byte[] dataInput, ECDSArefSignature refSig) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            throw new CryptoException("Signed data is null");
        }
        int keyUsage = 524544;
        if (keyType == 2) {
            keyUsage = 524800;
        }
        try {
            boolean flag = HSMCmd.ecdsaVerify(keyUsage, keyIndex, null, dataInput, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal ECDSA verification error " + ex.getMessage());
        }
    }

    @Override
    public boolean ecdsaVerify(ECDSArefPublicKey refPublicKey, byte[] dataInput, ECDSArefSignature refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("Public key is null");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            throw new CryptoException("Signed data is null");
        }
        int keyUsage = 524544;
        try {
            boolean flag = HSMCmd.ecdsaVerify(keyUsage, 0, refPublicKey, dataInput, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External ECDSA verification error: " + ex.getMessage());
        }
    }

    @Override
    public DSArefKeyPair generateDSAKeyPair(int keysize) throws CryptoException {
        if (keysize < 1024 || keysize > 4096 || keysize % 64 != 0) {
            throw new CryptoException("Illegal DSA keysize parameter(" + keysize + ")");
        }
        try {
            ByteKeyPair keypair = HSMCmd.generateKeyPair(keysize, 262144);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            Structure publicKey = null;
            Structure privateKey = null;
            if (pubKeyData.length == DSArefPublicKeyLite.sizeof()) {
                publicKey = new DSArefPublicKeyLite();
                privateKey = new DSArefPrivateKeyLite();
            } else {
                publicKey = new DSArefPublicKeyEx();
                privateKey = new DSArefPrivateKeyEx();
            }
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new DSArefKeyPair((IDSArefPublicKey)((Object)publicKey), (IDSArefPrivateKey)((Object)privateKey));
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate (" + keysize + ")DSA key pair error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public IDSArefPublicKey getDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter(" + keyIndex + ")");
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal keyType parameter(" + keyType + ")");
        }
        int keyUsage = 262400;
        if (keyType == 2) {
            keyUsage = 262656;
        }
        try {
            byte[] pubKeyData = HSMCmd.exportPublicKey(keyIndex, keyUsage);
            Structure publicKey = null;
            publicKey = pubKeyData.length == DSArefPublicKeyLite.sizeof() ? new DSArefPublicKeyLite() : new DSArefPublicKeyEx();
            publicKey.decode(pubKeyData);
            return publicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Export DSA(No." + keyIndex + ")" + GBKeyConst.toKeyPairName(keyType) + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public DSArefSignature dsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 262400;
        if (keyType == 2) {
            keyUsage = 262656;
        }
        try {
            DSArefSignature refSig = HSMCmd.dsaSign(keyUsage, keyIndex, null, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal DSAsign error: " + ex.getMessage());
        }
    }

    @Override
    public DSArefSignature dsaSign(IDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("Private key is null");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 262400;
        try {
            DSArefSignature refSig = HSMCmd.dsaSign(keyUsage, 0, refPrivateKey, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External DSA signature error: " + ex.getMessage());
        }
    }

    @Override
    public boolean dsaVerify(int keyIndex, int keyType, byte[] dataInput, DSArefSignature refSig) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            throw new CryptoException("Signed data is null");
        }
        int keyUsage = 262400;
        if (keyType == 2) {
            keyUsage = 262656;
        }
        try {
            boolean flag = HSMCmd.dsaVerify(keyUsage, keyIndex, null, dataInput, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal ECDSA verification error " + ex.getMessage());
        }
    }

    @Override
    public boolean dsaVerify(IDSArefPublicKey refPublicKey, byte[] dataInput, DSArefSignature refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("Public key is null");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            throw new CryptoException("Signed data is null");
        }
        int keyUsage = 262400;
        try {
            boolean flag = HSMCmd.dsaVerify(keyUsage, 0, refPublicKey, dataInput, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External DSA verification error: " + ex.getMessage());
        }
    }

    @Override
    public void inputKEK(int keyIndex, byte[] key) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (key == null) {
            throw new CryptoException("key is null");
        }
        try {
            HSMCmd.inputKEK(keyIndex, key);
        }
        catch (CryptoException ex) {
            throw new CryptoException("inputKEK(No." + keyIndex + ")" + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void importKeyPair_ECC(int keyIndex, int keyType, int keyPriKeyIndex, byte[] eccPairEnvelopedKey) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex: " + keyIndex);
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal keyType: " + keyType);
        }
        if (keyPriKeyIndex < 1) {
            throw new CryptoException("Illegal keyPriKeyIndex: " + keyIndex);
        }
        if (eccPairEnvelopedKey.length < 1) {
            throw new CryptoException("Illegal eccPairEnvelopedKey,length is " + eccPairEnvelopedKey.length);
        }
        int encAlg = 131328;
        if (131328 != encAlg && 132096 != encAlg) {
            throw new CryptoException("Illegal encAlg:" + encAlg);
        }
        try {
            HSMCmd.importEnvelopedKeyPair_ECC(keyIndex, keyType, keyPriKeyIndex, encAlg, eccPairEnvelopedKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import EnvelopedKeyPair_ECC keyIndex:" + keyIndex + "\tkeyType:" + keyType + "\tkeyPriKeyIndex:" + keyPriKeyIndex + " error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public void importEncKeyPair_ECC(int keyIndex, byte[] eccPairEnvelopedKey) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex: " + keyIndex);
        }
        if (eccPairEnvelopedKey.length < 1) {
            throw new CryptoException("Illegal eccPairEnvelopedKey,length is " + eccPairEnvelopedKey.length);
        }
        int encAlg = 131328;
        int keyType = 2;
        try {
            HSMCmd.importEnvelopedKeyPair_ECC(keyIndex, keyType, keyIndex, encAlg, eccPairEnvelopedKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import EnvelopedKeyPair_ECC keyIndex:" + keyIndex + "\tkeyType:" + keyType + "\tkeyPriKeyIndex:" + keyIndex + " error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] genKCV(int keyIndex) throws CryptoException {
        byte[] data = new byte[8];
        int algId = 2049;
        byte[] iv = new byte[8];
        try {
            return this.encrypt(algId, keyIndex, iv, data);
        }
        catch (Exception ex) {
            throw new CryptoException("genKCV error\uff1a" + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] generateHMAC(int algId, int keyIndex, byte[] input) throws CryptoException {
        if (!HashUtil.isRightHmacAlg(algId)) {
            throw new CryptoException("Illegal hash alg:" + algId);
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        try {
            byte[] output = HSMCmd.generateHMAC(algId, keyIndex, null, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal key generate HMAC error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] generateHMAC(int algId, byte[] key, byte[] input) throws CryptoException {
        if (!HashUtil.isRightHmacAlg(algId)) {
            throw new CryptoException("Illegal hash alg:" + algId);
        }
        if (key == null || key.length == 0) {
            throw new CryptoException("Key is null");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        try {
            byte[] output = HSMCmd.generateHMAC(algId, 0, key, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External key generate HMAC error:" + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] genPBKDF2Key(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt) throws CryptoException {
        if (!HashUtil.isRightSHAAlg(hashAlg)) {
            throw new CryptoException("Illegal hash alg:" + hashAlg);
        }
        if (iteraCount < 0) {
            throw new CryptoException("Illegal iteraCount( " + iteraCount + " )");
        }
        if (pwd == null || pwd.length == 0) {
            throw new CryptoException("pwd is null");
        }
        if (salt == null || salt.length == 0) {
            throw new CryptoException("salt data is null");
        }
        try {
            byte[] output = new byte[]{};
            output = HSMCmd.genPBKDF2Key(hashAlg, iteraCount, outLength, new String(pwd).getBytes("UTF-8"), salt);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("genPBKDF2Key error:" + ex.getMessage(), ex);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException("genPBKDF2Key error:" + e.getMessage(), e);
        }
    }

    @Override
    public byte[] genPBKDF2KeyExt(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt, int keyIndex) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal keyIndex parameter: " + keyIndex);
        }
        if (!HashUtil.isRightSHAAlg(hashAlg)) {
            throw new CryptoException("Illegal hash alg:" + hashAlg);
        }
        if (iteraCount < 0) {
            throw new CryptoException("Illegal iteraCount( " + iteraCount + " )");
        }
        if (pwd == null || pwd.length == 0) {
            throw new CryptoException("pwd is null");
        }
        if (salt == null || salt.length == 0) {
            throw new CryptoException("salt data is null");
        }
        try {
            byte[] output = HSMCmd.genPBKDF2KeyExt(hashAlg, iteraCount, outLength, new String(pwd).getBytes("utf-8"), salt, keyIndex);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("genPBKDF2Key error:" + ex.getMessage(), ex);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException("genPBKDF2Key error:" + e.getMessage(), e);
        }
    }

    @Override
    public byte[] ecdhAgreement(int ecdsIndex, int keyType, byte[] pubKey) throws CryptoException {
        if (ecdsIndex < 1) {
            throw new CryptoException("Illegal ecdsIndex parameter(" + ecdsIndex + ")");
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal keyType parameter(" + keyType + ")");
        }
        int keyUsage = 524544;
        if (keyType == 2) {
            keyUsage = 524800;
        }
        try {
            byte[] pubKeyData = HSMCmd.ecdhAgreement(ecdsIndex, keyUsage, pubKey);
            return pubKeyData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner ECDH agreement error,(No." + ecdsIndex + ",keyType=" + keyType + ")error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] ecdhAgreement(byte[] priKey, byte[] pubKey) throws CryptoException {
        if (priKey == null) {
            throw new CryptoException("priKey is null");
        }
        if (pubKey == null) {
            throw new CryptoException("pubKey is null");
        }
        try {
            byte[] output = HSMCmd.ecdhAgreement(priKey, pubKey);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External ECDH agreement error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public int hsmCreateFile(String fileName, int maxLength) throws CryptoException {
        if (fileName == null || fileName.length() > 128) {
            throw new CryptoException("fileName is null or length >128 ");
        }
        if (maxLength > 8192) {
            throw new CryptoException("file length >8192 )");
        }
        try {
            int flag = HSMCmd.hsmCreateFile(fileName, maxLength);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("hsmCreateFile, ErrorCode:" + ex.getMessage());
        }
    }

    @Override
    public byte[] hsmReadFile(String fileName, int startPosition, int readLength) throws CryptoException {
        if (fileName == null || fileName.length() > 128) {
            throw new CryptoException("fileName is null or length >128 ");
        }
        if (startPosition + readLength > 8192) {
            throw new CryptoException("file length( (startPosition+readLength) >8192 )");
        }
        try {
            byte[] data = HSMCmd.hsmReadFile(fileName, startPosition, readLength);
            return data;
        }
        catch (CryptoException ex) {
            throw new CryptoException("hsmReadFile, ErrorCode:" + ex.getMessage());
        }
    }

    @Override
    public int hsmWriteFile(String fileName, int startPosition, byte[] data) throws CryptoException {
        if (fileName == null || fileName.length() > 128) {
            throw new CryptoException("fileName is null or length >128");
        }
        int writeLength = data.length;
        if (startPosition + writeLength > 8192) {
            throw new CryptoException("file length( (startPosition+writeLength) >8192 )");
        }
        try {
            int flag = HSMCmd.hsmWriteFile(fileName, startPosition, data);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("hsmWriteFile, ErrorCode:" + ex.getMessage());
        }
    }

    @Override
    public int hsmDeleteFile(String fileName) throws CryptoException {
        if (fileName == null || fileName.length() > 128) {
            throw new CryptoException("fileName is null or length >128");
        }
        try {
            int flag = HSMCmd.hsmDeleteFile(fileName);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("hsmDeleteFile, ErrorCode:" + ex.getMessage());
        }
    }

    @Override
    public IRSArefPublicKey getRSAPublicKey(String keyLabel) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        try {
            byte[] pubKeyData = HSMCmd.exportPublicKey(keyLabel);
            Structure publicKey = null;
            publicKey = pubKeyData.length == RSArefPublicKeyLite.sizeof() ? new RSArefPublicKeyLite() : new RSArefPublicKeyEx();
            publicKey.decode(pubKeyData);
            return publicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get RSA(" + keyLabel + ") error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void generateRSAKeyPair(String keyLabel, int keysize) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public void rsaImportKeyPair(String keyLabel, IRSArefPublicKey refPublicKey, IRSArefPrivateKey refPrivateKey) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (refPublicKey == null) {
            throw new CryptoException("refPublicKey is null");
        }
        try {
            if (refPrivateKey != null) {
                HSMCmd.importKeyPair(keyLabel, refPublicKey.getBits(), refPublicKey.encode(), refPrivateKey.encode());
            } else {
                HSMCmd.importKeyPair(keyLabel, refPublicKey.getBits(), refPublicKey.encode(), null);
            }
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import RSA(" + keyLabel + ") error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void rsaDeleteKeyPair(String keyLabel) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        try {
            HSMCmd.deleteKeyPair(keyLabel);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import RSA(" + keyLabel + ") error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] rsaPublicKeyOperation(String keyLabel, byte[] input) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (input == null) {
            throw new CryptoException("Input operation data is null.");
        }
        try {
            byte[] output = HSMCmd.rsaPublicKeyOperation(keyLabel, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner RSA(" + keyLabel + ")public key operation error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] rsaPrivateKeyOperation(String keyLabel, byte[] input) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (input == null) {
            throw new CryptoException("Input operation data is null.");
        }
        try {
            byte[] output = HSMCmd.rsaPrivateKeyOperation(keyLabel, input);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Inner RSA(" + keyLabel + ") private key operat error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void importKey(String keyLabel, byte[] key) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (key == null) {
            throw new CryptoException("key is null");
        }
        try {
            HSMCmd.inputKey(keyLabel, key);
        }
        catch (CryptoException ex) {
            throw new CryptoException("inputKey(" + keyLabel + ")" + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void deleteKey(String keyLabel) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        try {
            HSMCmd.deleteKey(keyLabel);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Import RSA(" + keyLabel + ") error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void generateKey(String keyLabel, int keysize) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt(int algoType, String keyLabel, byte[] iv, byte[] input) throws CryptoException {
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (input == null) {
            throw new CryptoException("input data is null");
        }
        if (!SymmetryUtil.isRightInput(algoType, input)) {
            throw new CryptoException("Integer multiple of the non grouped length of the input data");
        }
        byte[] output = null;
        if (input.length > 8000) {
            int nLeftLen;
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            for (nLeftLen = input.length; nLeftLen > 8000; nLeftLen -= 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                try {
                    bufOut = HSMCmd.encrypt(algoType, keyLabel, null, iv, bufIn);
                }
                catch (CryptoException ex) {
                    throw new CryptoException("Inner key (" + keyLabel + ") (" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
                }
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufOut, 8000 - iv.length, iv, 0, iv.length);
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            try {
                bufOut = HSMCmd.encrypt(algoType, keyLabel, null, iv, bufIn);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(" + keyLabel + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufOut, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            try {
                output = HSMCmd.encrypt(algoType, keyLabel, null, iv, input);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(" + keyLabel + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")encrypt error: " + ex.getMessage(), ex);
            }
        }
        return output;
    }

    @Override
    public byte[] decrypt(int algoType, String keyLabel, byte[] iv, byte[] input) throws CryptoException {
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (input == null) {
            throw new CryptoException("input is null");
        }
        if (!SymmetryUtil.isRightInput(algoType, input)) {
            throw new CryptoException("Integer multiple of the non grouped length of the input data");
        }
        byte[] output = null;
        if (input.length > 8000) {
            int nLeftLen;
            output = new byte[input.length];
            byte[] bufIn = new byte[8000];
            byte[] bufOut = null;
            for (nLeftLen = input.length; nLeftLen > 8000; nLeftLen -= 8000) {
                System.arraycopy(input, input.length - nLeftLen, bufIn, 0, 8000);
                try {
                    bufOut = HSMCmd.decrypt(algoType, keyLabel, null, iv, bufIn);
                }
                catch (CryptoException ex) {
                    throw new CryptoException("Inner key(" + keyLabel + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
                }
                System.arraycopy(bufOut, 0, output, input.length - nLeftLen, 8000);
                System.arraycopy(bufIn, 8000 - iv.length, iv, 0, iv.length);
            }
            System.arraycopy(input, input.length - nLeftLen, bufIn, 0, nLeftLen);
            try {
                bufOut = HSMCmd.decrypt(algoType, keyLabel, null, iv, bufIn);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(" + keyLabel + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
            }
            System.arraycopy(bufOut, 0, output, input.length - nLeftLen, nLeftLen);
            System.arraycopy(bufIn, nLeftLen - iv.length, iv, 0, iv.length);
            nLeftLen -= nLeftLen;
        } else {
            try {
                output = HSMCmd.decrypt(algoType, keyLabel, null, iv, input);
            }
            catch (CryptoException ex) {
                throw new CryptoException("Inner key(" + keyLabel + ")(" + GBAlgorithmID_SGD.toAllAlgoName(algoType) + ")decrypt error: " + ex.getMessage(), ex);
            }
        }
        return output;
    }

    @Override
    public byte[] encrypt_add(int algoType, String keyLabel, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (input == null) {
            throw new CryptoException("Input data is null");
        }
        if (input.length > 8000) {
            throw new CryptoException("Input data cannot > 8000 byte.");
        }
        try {
            byte[] output = HSMCmd.encrypt_add(algoType, keyLabel, null, iv, input, addInput);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External symmetric key( " + GBKeyConst.toKeyPairName(algoType) + " ) encrytption error:" + ex.getMessage());
        }
    }

    @Override
    public byte[] decrypt_add(int algoType, String keyLabel, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        if (!SymmetryUtil.isRightIV(algoType, iv)) {
            throw new CryptoException("Illegal IV parameter");
        }
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (input == null) {
            throw new CryptoException("Ciphertext is null");
        }
        if (input.length > 8000) {
            throw new CryptoException("Input data cannot > 8000 byte.");
        }
        try {
            byte[] output = HSMCmd.decrypt_add(algoType, keyLabel, null, iv, input, addInput);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External symmetric key ( " + GBKeyConst.toKeyPairName(algoType) + " ) decryption error:" + ex.getMessage());
        }
    }

    @Override
    public byte[] genPBKDF2KeyExt(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt, String keyLabel) throws CryptoException {
        if (keyLabel == null) {
            throw new CryptoException("keyLabel is null");
        }
        if (keyLabel.length() >= 32) {
            throw new CryptoException("keyLabel should <32");
        }
        if (!HashUtil.isRightSHAAlg(hashAlg)) {
            throw new CryptoException("Illegal hash alg:" + hashAlg);
        }
        if (iteraCount < 0) {
            throw new CryptoException("Illegal iteraCount( " + iteraCount + " )");
        }
        if (pwd == null || pwd.length == 0) {
            throw new CryptoException("pwd is null");
        }
        if (salt == null || salt.length == 0) {
            throw new CryptoException("salt data is null");
        }
        try {
            byte[] output = HSMCmd.genPBKDF2KeyExt(hashAlg, iteraCount, outLength, new String(pwd).getBytes("UTF-8"), salt, keyLabel);
            return output;
        }
        catch (CryptoException ex) {
            throw new CryptoException("genPBKDF2Key error:" + ex.getMessage(), ex);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException("genPBKDF2Key error:" + e.getMessage(), e);
        }
    }

    @Override
    public List<byte[]> SDF_GenerateEncKeyPairWithKEK(int alg, int bits, int kekIndex, int kekAlg) throws CryptoException {
        if (alg != 65536 && alg != 131072) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (alg == 65536) {
            if (bits != 1024 && bits != 2048) {
                throw new CryptoException("Illegal bits parameter for RSA(" + bits + ")");
            }
        } else if (bits != 256) {
            throw new CryptoException("Illegal alg parameter for SM2(" + bits + ")");
        }
        if (kekIndex < 1) {
            throw new CryptoException("Illegal kekIndex parameter(" + kekIndex + ")");
        }
        if (kekAlg != 1025 && kekAlg != 8193) {
            throw new CryptoException("Illegal kekAlg parameter(" + kekAlg + ")");
        }
        try {
            List<byte[]> keyPairData = HSMCmd.generateEncKeyPairWithKEK(alg, bits, kekIndex, kekAlg);
            return keyPairData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get " + GBAlgorithmID_SGD.toAllAlgoName(alg) + "( bits:" + bits + ") with No." + kekIndex + " kekAlg " + GBAlgorithmID_SGD.toAllAlgoName(kekAlg) + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_SignWithEncPrivateKey(int signAlg, int hashAlg, int kekAlg, int kekIndex, byte[] encPrivateKey, byte[] data) throws CryptoException {
        if (signAlg != 65792 && signAlg != 131328) {
            throw new CryptoException("Illegal signAlg parameter(" + signAlg + ")");
        }
        if (hashAlg != 4 && hashAlg != 1 && hashAlg != 0) {
            throw new CryptoException("Illegal hashAlg  parameter (" + hashAlg + ")");
        }
        if (kekAlg != 1025 && kekAlg != 8193) {
            throw new CryptoException("Illegal kekAlg  parameter (" + kekAlg + ")");
        }
        if (kekIndex < 1) {
            throw new CryptoException("Illegal kekIndex parameter(" + kekIndex + ")");
        }
        if (encPrivateKey == null) {
            throw new CryptoException("Input encPrivateKey is null.");
        }
        if (data == null) {
            throw new CryptoException("Input operation data is null.");
        }
        try {
            byte[] outData = HSMCmd.signWithEncPrivateKey(signAlg, hashAlg, kekAlg, kekIndex, encPrivateKey, data);
            return outData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get signAlg:" + GBAlgorithmID_SGD.toAllAlgoName(signAlg) + " hashAlg:" + GBAlgorithmID_SGD.toAllAlgoName(hashAlg) + " kekAlg:" + GBAlgorithmID_SGD.toAllAlgoName(kekAlg) + " with No." + kekIndex + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_GeneratSymEncKey(int alg, int kekIndex, int keyBits) throws CryptoException {
        if (alg != 1025 && alg != 8193) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (kekIndex < 1) {
            throw new CryptoException("Illegal kekIndex parameter(" + kekIndex + ")");
        }
        if (keyBits != 128 && keyBits != 256) {
            throw new CryptoException("Illegal keyBits parameter(" + keyBits + ")");
        }
        try {
            byte[] cipherData = HSMCmd.generatSymEncKey(alg, kekIndex, keyBits);
            return cipherData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get " + GBAlgorithmID_SGD.toAllAlgoName(alg) + " with No." + kekIndex + " keyBits:" + keyBits + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_SymEncryptWithEncKey(int alg, byte[] encKey, int paddingType, byte[] iv, int kekAlg, int kekIndex, byte[] data) throws CryptoException {
        if (alg != 1025 && alg != 8193 && alg != 1026 && alg != 8194) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (encKey == null) {
            throw new CryptoException("Input encKey is null.");
        }
        if (0 != paddingType && 1 != paddingType) {
            throw new CryptoException("Illegal alg parameter(" + paddingType + ")");
        }
        if (kekAlg != 1025 && kekAlg != 8193) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (kekIndex < 1) {
            throw new CryptoException("Illegal kekIndex parameter(" + kekIndex + ")");
        }
        if (data == null) {
            throw new CryptoException("Input data is null.");
        }
        try {
            byte[] cipherData = HSMCmd.symEncryptWithEncKey(alg, encKey, paddingType, iv, kekAlg, kekIndex, data);
            return cipherData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get " + GBAlgorithmID_SGD.toAllAlgoName(alg) + " with No." + kekIndex + "paddingType: " + paddingType + "kekAlg: " + kekAlg + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_SymDecryptWithEncKey(int alg, byte[] encKey, int paddingType, byte[] iv, int kekAlg, int kekIndex, byte[] data) throws CryptoException {
        if (alg != 1025 && alg != 8193 && alg != 1026 && alg != 8194) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (encKey == null) {
            throw new CryptoException("Input encKey is null.");
        }
        if (0 != paddingType && 1 != paddingType) {
            throw new CryptoException("Illegal alg parameter(" + paddingType + ")");
        }
        if (kekAlg != 1025 && kekAlg != 8193) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (kekIndex < 1) {
            throw new CryptoException("Illegal kekIndex parameter(" + kekIndex + ")");
        }
        if (data == null) {
            throw new CryptoException("Input data is null.");
        }
        try {
            byte[] cipherData = HSMCmd.symDecryptWithEncKey(alg, encKey, paddingType, iv, kekAlg, kekIndex, data);
            return cipherData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get " + GBAlgorithmID_SGD.toAllAlgoName(alg) + " with No." + kekIndex + "paddingType: " + paddingType + "kekAlg: " + kekAlg + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_HMACWithKEK(int alg, int kekIndex, byte[] data) throws CryptoException {
        if (alg != 1 && alg != 2 && alg != 4) {
            throw new CryptoException("Illegal alg parameter(" + alg + ")");
        }
        if (kekIndex < 1) {
            throw new CryptoException("Illegal kekIndex parameter(" + kekIndex + ")");
        }
        if (data == null) {
            throw new CryptoException("Input data is null.");
        }
        try {
            byte[] cipherData = HSMCmd.generateHMAC(alg, kekIndex, null, data);
            return cipherData;
        }
        catch (CryptoException ex) {
            throw new CryptoException("get " + GBAlgorithmID_SGD.toAllAlgoName(alg) + " with kekIndex No." + kekIndex + " error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_DerivativePubSign(byte[] A, byte[] kS, int i, int j) throws CryptoException {
        if (A == null || A.length == 0) {
            throw new CryptoException("Input A data is null.");
        }
        if (kS == null || kS.length == 0) {
            throw new CryptoException("Input kS data is null.");
        }
        if (i > 65535) {
            throw new CryptoException("Input i >65535.");
        }
        if (j > 255) {
            throw new CryptoException("Input j >255.");
        }
        try {
            byte[] Bij = HSMCmd.derivativePubSign(A, kS, i, j);
            return Bij;
        }
        catch (CryptoException ex) {
            throw new CryptoException(" do SDF_DerivativePubSign error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_DerivativePubEnc(byte[] P, byte[] kE, int i, int j) throws CryptoException {
        if (P == null || P.length == 0) {
            throw new CryptoException("Input P data is null.");
        }
        if (kE == null || kE.length == 0) {
            throw new CryptoException("Input kE data is null.");
        }
        if (i > 65535) {
            throw new CryptoException("Input i >65535.");
        }
        if (j > 255) {
            throw new CryptoException("Input j >255.");
        }
        try {
            byte[] Qij = HSMCmd.derivativePubEnc(P, kE, i, j);
            return Qij;
        }
        catch (CryptoException ex) {
            throw new CryptoException(" do SDF_DerivativePubSign error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_DerivativePriSign(byte[] A, byte[] kS, int i, int j) throws CryptoException {
        if (A == null || A.length == 0) {
            throw new CryptoException("Input A data is null.");
        }
        if (kS == null || kS.length == 0) {
            throw new CryptoException("Input kS data is null.");
        }
        if (i > 65535) {
            throw new CryptoException("Input i >65535.");
        }
        if (j > 255) {
            throw new CryptoException("Input j >255.");
        }
        try {
            byte[] bij = HSMCmd.derivativePriSign(A, kS, i, j);
            return bij;
        }
        catch (CryptoException ex) {
            throw new CryptoException(" do SDF_DerivativePriSign error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_DerivativePriEnc(byte[] P, byte[] kE, int i, int j) throws CryptoException {
        if (P == null || P.length == 0) {
            throw new CryptoException("Input P data is null.");
        }
        if (kE == null || kE.length == 0) {
            throw new CryptoException("Input kE data is null.");
        }
        if (i > 65535) {
            throw new CryptoException("Input i >65535.");
        }
        if (j > 255) {
            throw new CryptoException("Input j >255.");
        }
        try {
            byte[] qij = HSMCmd.derivativePriEnc(P, kE, i, j);
            return qij;
        }
        catch (CryptoException ex) {
            throw new CryptoException(" do SDF_DerivativePriEnc error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_MakeFullPubKey(byte[] Qij, byte[] C) throws CryptoException {
        if (Qij == null || Qij.length == 0) {
            throw new CryptoException("Input Bij data is null.");
        }
        if (C == null || C.length == 0) {
            throw new CryptoException("Input C data is null.");
        }
        try {
            byte[] Sij = HSMCmd.makeFullPubKey(Qij, C);
            return Sij;
        }
        catch (CryptoException ex) {
            throw new CryptoException(" do SDF_MakeFullPubKey error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] SDF_MakeFullPriKey(byte[] bij, byte[] c) throws CryptoException {
        if (bij == null || bij.length == 0) {
            throw new CryptoException("Input bij data is null.");
        }
        if (c == null || c.length == 0) {
            throw new CryptoException("Input c data is null.");
        }
        try {
            byte[] sij = HSMCmd.makeFullPriKey(bij, c);
            return sij;
        }
        catch (CryptoException ex) {
            throw new CryptoException(" do SDF_MakeFullPriKey error: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void SDF_InitECC_Secp256k1() throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public void SWCSM_GenerateECCKeyPair_ECDSA(int uiKeyNumber, ECCrefCurveParam pECCParam) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public ECCrefKeyPair SDF_GenerateKeyPair_ECDSA(int uiAlgID, int uiKeyBits, ECCrefCurveParam pECCParam) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public ECCSignature SDF_ExternalSign_ECDSA(int uiAlgID, ECCrefPrivateKey pucPrivateKey, byte[] pucData, int uiDataLength) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public boolean SDF_ExternalVerify_ECDSA(int uiAlgID, ECCrefPublicKey pucPublicKey, byte[] pucDataInput, int uiInputLength, ECCSignature pucSignature) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public ECCSignature SDF_InternalSign_ECDSA_Ex(int uiISKIndex, int uiAlgID, byte[] pucData, int uiDataLength) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public boolean SDF_InternalVerify_ECDSA_Ex(int uiISKIndex, int uiAlgID, byte[] pucData, int uiDataLength, ECCSignature pucSignature) throws CryptoException {
        throw new CryptoException("CMDCrypto unrealized method...");
    }

    @Override
    public EdDSArefKeyPair generateEdDSAKeyPair(int keysize, int curetype) throws CryptoException {
        if (curetype != 1) {
            throw new CryptoException("Illegal EdDSA curve parameters( " + curetype + " )");
        }
        if (keysize != 256) {
            throw new CryptoException("Illegal EdDSA curve parameters( " + curetype + " )," + "key modulus( " + keysize + " )");
        }
        try {
            ByteKeyPair keypair = HSMCmd.generateEdDSAKeyPair(keysize, 0x200100, curetype);
            byte[] pubKeyData = keypair.getPubKeyData();
            byte[] priKeyData = keypair.getPriKeyData();
            EdDSArefPublicKey publicKey = new EdDSArefPublicKey();
            EdDSArefPrivateKey privateKey = new EdDSArefPrivateKey();
            publicKey.decode(pubKeyData);
            privateKey.decode(priKeyData);
            return new EdDSArefKeyPair(publicKey, privateKey);
        }
        catch (CryptoException ex) {
            throw new CryptoException("Generate (" + keysize + "bits)EdDSA key pair error:" + ex.getMessage());
        }
    }

    @Override
    public EdDSArefPublicKey getEdDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 2 && keyType != 1) {
            throw new CryptoException("Illegal key type( " + keyType + " )");
        }
        int keyUsage = 0x200200;
        if (keyType == 2) {
            keyUsage = 0x200400;
        }
        try {
            byte[] pubKeyData = HSMCmd.exportPublicKey(keyIndex, keyUsage);
            EdDSArefPublicKey refPublicKey = new EdDSArefPublicKey();
            refPublicKey.decode(pubKeyData);
            return refPublicKey;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Export EdDSA(" + keyIndex + ")" + GBKeyConst.toKeyPairName(keyType) + " error:" + ex.getMessage());
        }
    }

    @Override
    public EdDSArefSignature eddsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 0x200200;
        if (keyType == 2) {
            keyUsage = 0x200400;
        }
        try {
            EdDSArefSignature refSig = HSMCmd.eddsaSign(keyUsage, keyIndex, null, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal EdDSAsign error: " + ex.getMessage());
        }
    }

    @Override
    public EdDSArefSignature eddsaSign(EdDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (refPrivateKey == null) {
            throw new CryptoException("Private key is null");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        int keyUsage = 0x200200;
        try {
            EdDSArefSignature refSig = HSMCmd.eddsaSign(keyUsage, 0, refPrivateKey, input);
            return refSig;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External EdDSA signature error: " + ex.getMessage());
        }
    }

    @Override
    public boolean eddsaVerify(int keyIndex, int keyType, byte[] dataInput, EdDSArefSignature refSig) throws CryptoException {
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            throw new CryptoException("Signed data is null");
        }
        int keyUsage = 0x200200;
        if (keyType == 2) {
            keyUsage = 0x200400;
        }
        try {
            boolean flag = HSMCmd.eddsaVerify(keyUsage, keyIndex, null, dataInput, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("Internal EdDSA verification error " + ex.getMessage());
        }
    }

    @Override
    public boolean eddsaVerify(EdDSArefPublicKey refPublicKey, byte[] dataInput, EdDSArefSignature refSig) throws CryptoException {
        if (refPublicKey == null) {
            throw new CryptoException("Public key is null");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            throw new CryptoException("Signed data is null");
        }
        int keyUsage = 0x200200;
        try {
            boolean flag = HSMCmd.eddsaVerify(keyUsage, 0, refPublicKey, dataInput, refSig);
            return flag;
        }
        catch (CryptoException ex) {
            throw new CryptoException("External EDDSA verification error: " + ex.getMessage());
        }
    }
}

