/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.crypto_hsm.sds.lib.jna.SDFInterface;
import com.sansec.devicev4.gb.GBErrorCode_SDR;
import com.sansec.devicev4.gb.struct.DeviceInfo;
import com.sansec.devicev4.gb.struct.DeviceRunStatus;
import com.sansec.devicev4.gb.struct.key.IDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCSignature;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefCurveParam;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefKeyPair;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefPrivateKey;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECIESrefCipher;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefSignature;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import com.sansec.devicev4.util.ECDSAUtil;
import com.sansec.devicev4.util.JarUtil;
import com.sansec.devicev4.util.SymmetryUtil;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LIBCrypto
implements ISDSCrypto {
    private static Logger logger = CryptoLogger.logger;
    private volatile SDFInterface instanseSDF = null;
    private static volatile PointerByReference phDeviceHandle = null;

    public LIBCrypto(int deviceType) throws CryptoException {
        switch (deviceType) {
            case 2: {
                JarUtil util = new JarUtil(JarUtil.class);
                String jnaLibPath = util.getJarPath();
                System.setProperty("jna.library.path", jnaLibPath);
                logger.fine("jna.library.path:" + jnaLibPath);
                this.instanseSDF = SDFInterface.instanseLib;
                logger.fine("DeviceType.LIB");
                logger.info("LIB ConfigFile use lib's default read path.");
                this.openDevice();
                break;
            }
            default: {
                throw new CryptoException("Illegal Device Type.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openDevice() throws CryptoException {
        if (phDeviceHandle != null) return;
        Class<LIBCrypto> clazz = LIBCrypto.class;
        synchronized (LIBCrypto.class) {
            if (phDeviceHandle != null) return;
            PointerByReference ppDevice = new PointerByReference(Pointer.NULL);
            int flag = this.instanseSDF.SDF_OpenDevice(ppDevice);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            phDeviceHandle = ppDevice;
            logger.info("Device open.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DeviceInfo getDeviceInfo() throws CryptoException {
        logger.info("-> LIBCrypto.getDeviceInfo()...");
        DeviceInfo pstDeviceInfo = new DeviceInfo();
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            int funFlag = this.instanseSDF.SDF_GetDeviceInfo(pSessionHandleHandle, pstDeviceInfo);
            if (funFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(funFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(funFlag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.info("-> LIBCrypto.getDeviceInfo() end.");
        return pstDeviceInfo;
    }

    @Override
    public DeviceRunStatus getDeviceRunStatus() throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public int[] getKeyStatus(int keyType) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] generateRandom(int randomLength) throws CryptoException {
        logger.info("-> LIBCrypto.generateRandom()...");
        logger.fine("randomLength:" + randomLength);
        byte[] random = null;
        if (randomLength <= 0) {
            logger.info("Illegal Random Length.");
            throw new CryptoException("Illegal Random Length.");
        }
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            random = new byte[randomLength];
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_GenerateRandom(pSessionHandle, randomLength, random);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("random:" + BytesUtil.bytes2hex(random));
        logger.info("-> LIBCrypto.generateRandom() end.");
        return random;
    }

    @Override
    public IRSArefPublicKey getRSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        logger.info("-> LIBCrypto.getRSAPublicKey()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        RSArefPublicKeyEx pRsaPubKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            pRsaPubKey = new RSArefPublicKeyEx();
            int flag = 0;
            flag = keyType == 2 ? this.instanseSDF.SDF_ExportEncPublicKey_RSA(pSessionHandle, keyIndex, pRsaPubKey) : this.instanseSDF.SDF_ExportSignPublicKey_RSA(pSessionHandle, keyIndex, pRsaPubKey);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        Structure publicKey = null;
        publicKey = pRsaPubKey.bits <= 2048 ? new RSArefPublicKeyLite(pRsaPubKey.getBits(), BytesUtil.subbytes(pRsaPubKey.getM(), 0, 256), BytesUtil.subbytes(pRsaPubKey.getM(), 256, 256)) : new RSArefPublicKeyEx(pRsaPubKey.getBits(), pRsaPubKey.getM(), pRsaPubKey.getE());
        logger.fine("publicKey:" + ((Object)publicKey).toString());
        logger.info("-> LIBCrypto.getRSAPublicKey() end.");
        return publicKey;
    }

    @Override
    public RSArefKeyPair generateRSAKeyPair(int keysize) throws CryptoException {
        logger.info("-> LIBCrypto.generateRSAKeyPair()...");
        logger.fine("keysize" + keysize);
        if (keysize < 1024 || keysize > 4096 || keysize % 128 != 0) {
            throw new CryptoException("Illegal key length:" + keysize + ".");
        }
        Structure pRsaPubKey = null;
        Structure pRsaPriKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            if (keysize <= 2048) {
                pRsaPubKey = new RSArefPublicKeyLite.ByReference();
                pRsaPriKey = new RSArefPrivateKeyLite.ByReference();
            } else {
                pRsaPubKey = new RSArefPublicKeyEx.ByReference();
                pRsaPriKey = new RSArefPrivateKeyEx.ByReference();
            }
            int flag = this.instanseSDF.SDF_GenerateKeyPair_RSA(pSessionHandle, keysize, (IRSArefPublicKey)((Object)pRsaPubKey), (IRSArefPrivateKey)((Object)pRsaPriKey));
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pRsaPubKey:" + ((Object)pRsaPubKey).toString());
        logger.fine("pRsaPriKey:" + ((Object)pRsaPriKey).toString());
        logger.info("-> LIBCrypto.generateRSAKeyPair() end.");
        return new RSArefKeyPair((IRSArefPublicKey)((Object)pRsaPubKey), (IRSArefPrivateKey)((Object)pRsaPriKey));
    }

    @Override
    public RSArefKeyPair generateRSAKeyPair(int keysize, int exponent) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void generateRSAKeyPair(int keyIndex, int keyType, int keysize) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] rsaPublicKeyOperation(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPublicKeyOperation()...");
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            RSArefPublicKeyEx pRsaPubKey = new RSArefPublicKeyEx();
            int keyFlag = 0;
            keyFlag = keyType == 2 ? this.instanseSDF.SDF_ExportEncPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey) : this.instanseSDF.SDF_ExportSignPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey);
            if (keyFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(keyFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(keyFlag));
            }
            Structure publicKey = null;
            publicKey = pRsaPubKey.bits <= 2048 ? new RSArefPublicKeyLite(pRsaPubKey.getBits(), BytesUtil.subbytes(pRsaPubKey.getM(), 0, 256), BytesUtil.subbytes(pRsaPubKey.getM(), 256, 256)) : new RSArefPublicKeyEx(pRsaPubKey.getBits(), pRsaPubKey.getM(), pRsaPubKey.getE());
            int keyLenth = publicKey.getBits() >> 3;
            if (keyLenth != input.length) {
                logger.info("Illegal input data length[" + keyLenth + "]:" + input.length);
                throw new CryptoException("Illegal input data length[" + keyLenth + "]:" + input.length);
            }
            BigInteger inputInteger = new BigInteger(1, input);
            BigInteger publicM = new BigInteger(1, publicKey.getM());
            if (inputInteger.compareTo(publicM) > 0) {
                logger.info("Illegal input data >publickey.M");
                throw new CryptoException("Illegal input data >publickey.M");
            }
            IntByReference puiOutputLength = new IntByReference(0);
            pucDataOutput = new byte[input.length];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalPublicKeyOperation_RSA(pSessionHandleHandle, keyIndex, 65792, input, input.length, pucDataOutput, puiOutputLength) : this.instanseSDF.SDF_InternalPublicKeyOperation_RSA(pSessionHandleHandle, keyIndex, 66048, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPublicKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] rsaPrivateKeyOperation(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation()...");
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            RSArefPublicKeyEx pRsaPubKey = new RSArefPublicKeyEx();
            int keyFlag = 0;
            keyFlag = keyType == 2 ? this.instanseSDF.SDF_ExportEncPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey) : this.instanseSDF.SDF_ExportSignPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey);
            if (keyFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(keyFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(keyFlag));
            }
            Structure publicKey = null;
            publicKey = pRsaPubKey.bits <= 2048 ? new RSArefPublicKeyLite(pRsaPubKey.getBits(), BytesUtil.subbytes(pRsaPubKey.getM(), 0, 256), BytesUtil.subbytes(pRsaPubKey.getM(), 256, 256)) : new RSArefPublicKeyEx(pRsaPubKey.getBits(), pRsaPubKey.getM(), pRsaPubKey.getE());
            int keyLenth = publicKey.getBits() >> 3;
            if (keyLenth != input.length) {
                logger.info("Illegal input data length[" + keyLenth + "]:" + input.length);
                throw new CryptoException("Illegal input data length[" + keyLenth + "]:" + input.length);
            }
            BigInteger inputInteger = new BigInteger(1, input);
            BigInteger publicM = new BigInteger(1, publicKey.getM());
            if (inputInteger.compareTo(publicM) > 0) {
                logger.info("Illegal input data >publickey.M");
                throw new CryptoException("Illegal input data >publickey.M");
            }
            IntByReference puiOutputLength = new IntByReference(0);
            pucDataOutput = new byte[input.length];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalPrivateKeyOperation_RSA(pSessionHandleHandle, keyIndex, 65792, input, input.length, pucDataOutput, puiOutputLength) : this.instanseSDF.SDF_InternalPrivateKeyOperation_RSA(pSessionHandleHandle, keyIndex, 66048, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] rsaPublicKeyOperation(IRSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPublicKeyOperation()...");
        if (refPublicKey == null) {
            logger.info("The PublicKey data is null.");
            throw new CryptoException("The PublicKey data is null.");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (refPublicKey.getBits() >> 3 != input.length) {
            logger.info("Illegal input data length:" + input.length);
            throw new CryptoException("Illegal input data length:" + input.length);
        }
        logger.fine("refPublicKey:" + refPublicKey);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        BigInteger inputInteger = new BigInteger(1, input);
        BigInteger publicM = new BigInteger(1, refPublicKey.getM());
        if (inputInteger.compareTo(publicM) > 0) {
            logger.info("Illegal input data >publickey.M");
            throw new CryptoException("Illegal input data >publickey.M");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            IntByReference puiOutputLength;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalPublicKeyOperation_RSA(pSessionHandleHandle, refPublicKey, input, input.length, pucDataOutput = new byte[input.length], puiOutputLength = new IntByReference(0));
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPublicKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation()...");
        if (null == refPrivateKey) {
            logger.info("The PrivateKey data is null.");
            throw new CryptoException("The PrivateKey data is null.");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (refPrivateKey.getBits() >> 3 != input.length) {
            logger.info("Illegal input data length:" + input.length);
            throw new CryptoException("Illegal input data length:" + input.length);
        }
        logger.fine("refPrivateKey:" + refPrivateKey.toString());
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        BigInteger inputInteger = new BigInteger(1, input);
        BigInteger publicM = new BigInteger(1, refPrivateKey.getM());
        if (inputInteger.compareTo(publicM) > 0) {
            logger.info("Illegal input data > publickey.M");
            throw new CryptoException("Illegal input data > publickey.M");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            IntByReference puiOutputLength;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalPrivateKeyOperation_RSA(pSessionHandleHandle, refPrivateKey, input, input.length, pucDataOutput = new byte[input.length], puiOutputLength = new IntByReference(0));
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public void rsaImportKeyPair(int keyIndex, int keyType, IRSArefPublicKey refPublicKey, IRSArefPrivateKey refPrivateKey) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public SM2refPublicKey getSM2PublicKey(int keyIndex, int keyType) throws CryptoException {
        logger.info("-> LIBCrypto.getSM2PublicKey()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        SM2refPublicKey pucPublicKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            pucPublicKey = new SM2refPublicKey();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_ExportSignPublicKey_ECC(pSessionHandleHandle, keyIndex, pucPublicKey) : this.instanseSDF.SDF_ExportEncPublicKey_ECC(pSessionHandleHandle, keyIndex, pucPublicKey);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        SM2refPublicKey publicKey = new SM2refPublicKey(pucPublicKey.getX(), pucPublicKey.getY());
        logger.fine("publicKey:" + publicKey.toString());
        logger.info("-> LIBCrypto.getSM2PublicKey() end.");
        return publicKey;
    }

    @Override
    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        logger.info("-> LIBCrypto.generateSM2KeyPair()...");
        logger.fine("keysize:" + keysize);
        if (keysize != 256) {
            logger.info("Illegal SM2 key length:" + keysize + ".");
            throw new CryptoException("Illegal SM2 key length:" + keysize + ".");
        }
        SM2refPublicKey pucPublicKey = null;
        SM2refPrivateKey pucPrivateKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_GenerateKeyPair_ECC(pSessionHandle, 131072, keysize, pucPublicKey = new SM2refPublicKey(), pucPrivateKey = new SM2refPrivateKey());
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucPublicKey:" + pucPublicKey.toString());
        logger.fine("pucPrivateKey:" + pucPrivateKey.toString());
        logger.info("-> LIBCrypto.generateSM2KeyPair() end.");
        return new SM2refKeyPair(pucPublicKey, pucPrivateKey);
    }

    @Override
    public void generateSM2KeyPair(int keyIndex, int keyType, int keysize) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public SM2refCipher sm2Encrypt(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Encrypt()...");
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (input.length > 136) {
            logger.info("Illegal input data length:" + input.length + ".");
            throw new CryptoException("Illegal input data length:" + input.length + ".");
        }
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        SM2refCipher sm2refCipher = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            sm2refCipher = new SM2refCipher();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalEncrypt_ECC(pSessionHandle, keyIndex, 131328, input, input.length, sm2refCipher) : this.instanseSDF.SDF_InternalEncrypt_ECC(pSessionHandle, keyIndex, 132096, input, input.length, sm2refCipher);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refCipher:" + sm2refCipher.toString());
        logger.info("-> LIBCrypto.sm2Encrypt() end.");
        return sm2refCipher;
    }

    @Override
    public byte[] sm2Decrypt(int keyIndex, int keyType, SM2refCipher refCipher) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Decrypt()...");
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (refCipher == null) {
            logger.info("The SM2refCipher data is null.");
            throw new CryptoException("The SM2refCipher data is null.");
        }
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("refCipher:" + refCipher.toString());
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference puiOutputLength = new IntByReference(0);
            pucDataOutput = new byte[refCipher.cLength];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalDecrypt_ECC(pSessionHandle, keyIndex, 131328, refCipher, pucDataOutput, puiOutputLength) : this.instanseSDF.SDF_InternalDecrypt_ECC(pSessionHandle, keyIndex, 132096, refCipher, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.sm2Decrypt() end.");
        return pucDataOutput;
    }

    @Override
    public SM2refCipher sm2Encrypt(SM2refPublicKey publicKey, byte[] dataInput) throws CryptoException {
        if (publicKey == null) {
            logger.info("The SM2refPublicKey data is null.");
            throw new CryptoException("The SM2refPublicKey data is null.");
        }
        if (dataInput == null || 0 == dataInput.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (dataInput.length > 136) {
            logger.info("Illegal input data length:" + dataInput.length + ".");
            throw new CryptoException("Illegal input data length:" + dataInput.length + ".");
        }
        logger.info("-> LIBCrypto.sm2Encrypt()...");
        logger.fine("publicKey:" + publicKey.toString());
        logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        SM2refCipher sm2refCipher = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalEncrypt_ECC(pSessionHandle, 132096, publicKey, dataInput, dataInput.length, sm2refCipher = new SM2refCipher());
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refCipher:" + sm2refCipher.toString());
        logger.info("-> LIBCrypto.sm2Encrypt() end.");
        return sm2refCipher;
    }

    @Override
    public byte[] sm2Decrypt(SM2refPrivateKey privateKey, SM2refCipher refCipher) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Decrypt()...");
        if (privateKey == null) {
            logger.info("The SM2refPrivateKey data is null.");
            throw new CryptoException("The SM2refPrivateKey data is null.");
        }
        if (refCipher == null) {
            logger.info("The SM2refCipher data is null.");
            throw new CryptoException("The SM2refCipher data is null.");
        }
        logger.fine("privateKey:" + privateKey.toString());
        logger.fine("refCipher:" + refCipher.toString());
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            IntByReference puiOutputLength;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalDecrypt_ECC(pSessionHandle, 132096, privateKey, refCipher, pucDataOutput = new byte[refCipher.cLength], puiOutputLength = new IntByReference(0));
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.sm2Decrypt() end.");
        return pucDataOutput;
    }

    @Override
    public SM2refSignature sm2Sign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Sign()...");
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (input.length != 32) {
            logger.info("Illegal input data length:" + input.length + ".");
            throw new CryptoException("Illegal input data length:" + input.length + ".");
        }
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        SM2refSignature sm2refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            sm2refSignature = new SM2refSignature();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalSign_ECC_Ex(pSessionHandle, keyIndex, 131328, input, input.length, sm2refSignature) : this.instanseSDF.SDF_InternalSign_ECC_Ex(pSessionHandle, keyIndex, 132096, input, input.length, sm2refSignature);
            if (flag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refSignature:" + sm2refSignature.toString());
        logger.info("-> LIBCrypto.sm2Sign() end.");
        return sm2refSignature;
    }

    @Override
    public boolean sm2Verify(int keyIndex, int keyType, byte[] dataInput, SM2refSignature refSig) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.sm2Verify()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            }
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (dataInput == null || 0 == dataInput.length) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The input data is null.");
            }
            throw new CryptoException("The input data is null.");
        }
        if (dataInput.length != 32) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal input data length:" + dataInput.length + ".");
            }
            throw new CryptoException("Illegal input data length:" + dataInput.length + ".");
        }
        if (refSig == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The SM2refSignature data is null.");
            }
            throw new CryptoException("The SM2refSignature data is null.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keyIndex:" + keyIndex);
            logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalVerify_ECC_Ex(pSessionHandle, keyIndex, 131328, dataInput, dataInput.length, refSig) : this.instanseSDF.SDF_InternalVerify_ECC_Ex(pSessionHandle, keyIndex, 132096, dataInput, dataInput.length, refSig);
            if (flag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.sm2Verify() end.");
        }
        if (flag != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("result:false");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("result:true");
        }
        return true;
    }

    @Override
    public SM2refSignature sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.sm2Sign()...");
        }
        if (refPrivateKey == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The SM2refPrivateKey data is null.");
            }
            throw new CryptoException("The SM2refPrivateKey data is null.");
        }
        if (input == null || 0 == input.length) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The input data is null.");
            }
            throw new CryptoException("The input data is null.");
        }
        if (input.length != 32) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal input data length:" + input.length + ".");
            }
            throw new CryptoException("Illegal input data length:" + input.length + ".");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refPrivateKey:" + refPrivateKey.toString());
            logger.fine("input:" + BytesUtil.bytes2hex(input));
        }
        SM2refSignature sm2refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalSign_ECC(pSessionHandle, 131328, refPrivateKey, input, input.length, sm2refSignature = new SM2refSignature());
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sm2refSignature:" + sm2refSignature.toString());
            logger.info("-> LIBCrypto.sm2Sign() end.");
        }
        return sm2refSignature;
    }

    @Override
    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] dataInput, SM2refSignature refSig) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.sm2Verify()...");
        }
        if (refPublicKey == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The SM2refPublicKey data is null.");
            }
            throw new CryptoException("The SM2refPublicKey data is null.");
        }
        if (dataInput == null || 0 == dataInput.length) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The input data is null.");
            }
            throw new CryptoException("The input data is null.");
        }
        if (dataInput.length != 32) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal input data length:" + dataInput.length + ".");
            }
            throw new CryptoException("Illegal input data length:" + dataInput.length + ".");
        }
        if (refSig == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The SM2refSignature data is null.");
            }
            throw new CryptoException("The SM2refSignature data is null.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refPublicKey:" + refPublicKey.toString());
            logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
            logger.fine("refSig:" + refSig.toString());
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = this.instanseSDF.SDF_ExternalVerify_ECC(pSessionHandle, 131328, refPublicKey, dataInput, dataInput.length, refSig);
            if (flag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.sm2Verify() end.");
        }
        if (flag != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("result:false");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("result:true");
        }
        return true;
    }

    @Override
    public byte[] keyAgreement_SM2(int flag, int keyIndex, SM2refPublicKey ownTmpPubKey, SM2refPrivateKey ownTmpPriKey, SM2refPublicKey opPubKey, SM2refPublicKey opTmpPubKey, int keyBits, byte[] ownId, byte[] opId) throws Exception {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void sm2ImportKeyPair(int keyIndex, int keyType, SM2refPublicKey refPublicKey, SM2refPrivateKey refPrivateKey) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public ECDSArefKeyPair generateECDSAKeyPair(int keysize, int curetype) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.generateECDSAKeyPair()...");
        }
        if (!ECDSAUtil.checkCurveType(curetype)) {
            throw new CryptoException("Illegal ECDSA curve parameters( " + curetype + " )");
        }
        if (!ECDSAUtil.checkKeyLength(curetype, keysize)) {
            throw new CryptoException("Illegal ECDSA curve parameters( " + curetype + " )," + "key modulus( " + keysize + " )");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keysize:" + keysize);
            logger.fine("curetype:" + curetype);
        }
        ECDSArefPublicKey pucPublicKey = null;
        ECDSArefPrivateKey pucPrivateKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int flag;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            pucPublicKey = new ECDSArefPublicKey();
            pucPrivateKey = new ECDSArefPrivateKey();
            if (curetype == 524289) {
                curetype = 0;
            }
            if ((flag = this.instanseSDF.SDF_GenerateKeyPair_ECDSA(pSessionHandle, 524288, keysize, curetype, pucPublicKey, pucPrivateKey)) != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (pucPublicKey.getCurvetype() == 0) {
            pucPublicKey.setCurvetype(524289);
            pucPrivateKey.setCurvetype(524289);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pucPublicKey:" + pucPublicKey.toString());
            logger.fine("pucPrivateKey:" + pucPrivateKey.toString());
            logger.info("-> LIBCrypto.generateECDSAKeyPair() end.");
        }
        return new ECDSArefKeyPair(pucPublicKey, pucPrivateKey);
    }

    @Override
    public ECDSArefPublicKey getECDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.getECDSAPublicKey()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            }
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keyIndex:" + keyIndex);
            logger.fine("keyType:" + keyType);
        }
        ECDSArefPublicKey pucPublicKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            pucPublicKey = new ECDSArefPublicKey();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_ExportSignPublicKey_ECDSA(pSessionHandleHandle, keyIndex, pucPublicKey) : this.instanseSDF.SDF_ExportEncPublicKey_ECDSA(pSessionHandleHandle, keyIndex, pucPublicKey);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (pucPublicKey.getCurvetype() == 0) {
            pucPublicKey.setCurvetype(524289);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("publicKey:" + pucPublicKey.toString());
            logger.info("-> LIBCrypto.getECDSAPublicKey() end.");
        }
        return pucPublicKey;
    }

    @Override
    public ECIESrefCipher ecdsaEncrypt(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaEncrypt()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            }
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keyIndex:" + keyIndex);
            logger.fine("keyType:" + keyType);
            logger.fine("input :" + BytesUtil.bytes2hex(input));
        }
        ECIESrefCipher eciesrefCipher = new ECIESrefCipher();
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiCipherDataLength = new IntByReference(0);
            byte[] pucCipher = new byte[input.length + eciesrefCipher.size() - 1];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalEncrypt_ECDSA(pSessionHandle, keyIndex, 524544, input, input.length, pucCipher, uiCipherDataLength) : this.instanseSDF.SDF_InternalEncrypt_ECDSA(pSessionHandle, keyIndex, 524800, input, input.length, pucCipher, uiCipherDataLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            eciesrefCipher.decode(pucCipher);
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsa encrypted data:" + BytesUtil.bytes2hex(eciesrefCipher.encode()));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaEncrypt() end.");
        }
        return eciesrefCipher;
    }

    @Override
    public ECIESrefCipher ecdsaEncrypt(ECDSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaEncrypt()...");
        }
        if (refPublicKey == null) {
            throw new CryptoException("ECDSA publicKey is null");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("publicKey :" + BytesUtil.bytes2hex(refPublicKey.encode()));
            logger.fine("input :" + BytesUtil.bytes2hex(input));
        }
        ECIESrefCipher eciesrefCipher = new ECIESrefCipher();
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiCipherDataLength = new IntByReference(0);
            byte[] pucCipher = new byte[input.length + eciesrefCipher.size() - 1];
            int flag = this.instanseSDF.SDF_ExternalEncrypt_ECDSA(pSessionHandle, 524544, refPublicKey, input, input.length, pucCipher, uiCipherDataLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            eciesrefCipher.decode(pucCipher);
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsa encrypted data:" + BytesUtil.bytes2hex(eciesrefCipher.encode()));
            logger.info("-> LIBCrypto.ecdsaEncrypt() end.");
        }
        return eciesrefCipher;
    }

    @Override
    public byte[] ecdsaDecrypt(int keyIndex, int keyType, ECIESrefCipher cipher) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaDecrypt()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            }
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (cipher == null) {
            throw new CryptoException("Input cipher is null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keyIndex:" + keyIndex);
            logger.fine("keyType:" + keyType);
            logger.fine("cipher:" + BytesUtil.bytes2hex(cipher.encode()));
        }
        byte[] data = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiDataLength = new IntByReference(0);
            data = new byte[cipher.cLength];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalDecrypt_ECDSA(pSessionHandle, keyIndex, 524544, cipher.encode(), cipher.size(), data, uiDataLength) : this.instanseSDF.SDF_InternalDecrypt_ECDSA(pSessionHandle, keyIndex, 524800, cipher.encode(), cipher.size(), data, uiDataLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsa decrypt data:" + BytesUtil.bytes2hex(data));
            logger.info("-> LIBCrypto.ecdsaDecrypt() end.");
        }
        return data;
    }

    @Override
    public byte[] ecdsaDecrypt(ECDSArefPrivateKey refPrivateKey, ECIESrefCipher cipher) throws CryptoException {
        if (logger.isLoggable(Level.FINE)) {
            logger.info("-> LIBCrypto.ecdsaDecrypt()...");
        }
        if (refPrivateKey == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.info("The ECDSArefPrivateKey data is null.");
            }
            throw new CryptoException("The ECDSArefPrivateKey data is null.");
        }
        if (cipher == null) {
            throw new CryptoException("Input cipher is null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refPrivateKey:" + BytesUtil.bytes2hex(refPrivateKey.encode()));
            logger.fine("cipher:" + BytesUtil.bytes2hex(cipher.encode()));
        }
        byte[] data = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiDataLength = new IntByReference(0);
            data = new byte[cipher.cLength];
            int flag = this.instanseSDF.SDF_ExternalDecrypt_ECDSA(pSessionHandle, 524544, refPrivateKey, cipher.encode(), cipher.size(), data, uiDataLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsa decrypt data:" + BytesUtil.bytes2hex(data));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaDecrypt() end.");
        }
        return data;
    }

    @Override
    public ECDSArefSignature ecdsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaSign()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            }
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keyIndex:" + keyIndex);
            logger.fine("keyType:" + keyType);
            logger.fine("input:" + BytesUtil.bytes2hex(input));
        }
        ECDSArefSignature refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiSignatureDataLength = new IntByReference(0);
            refSignature = new ECDSArefSignature();
            int flag = 0;
            byte[] signOut = new byte[160];
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalSign_ECDSA(pSessionHandle, keyIndex, 524544, input, input.length, signOut, uiSignatureDataLength) : this.instanseSDF.SDF_InternalSign_ECDSA(pSessionHandle, keyIndex, 524800, input, input.length, signOut, uiSignatureDataLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            int signLen = uiSignatureDataLength.getValue();
            byte[] signResult = new byte[signLen];
            System.arraycopy(signOut, 0, signResult, 0, signLen);
            refSignature.decode(signResult);
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsaRefSignature:" + refSignature.toString());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaSign() end.");
        }
        return refSignature;
    }

    @Override
    public ECDSArefSignature ecdsaSign(ECDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaSign()...");
        }
        if (refPrivateKey == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The ECDSArefPrivateKey data is null.");
            }
            throw new CryptoException("The ECDSArefPrivateKey data is null.");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refPrivateKey:" + refPrivateKey.toString());
            logger.fine("input:" + BytesUtil.bytes2hex(input));
        }
        ECDSArefSignature refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            byte[] signOut;
            int flag;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiSignatureDataLength = new IntByReference(0);
            refSignature = new ECDSArefSignature();
            if (refPrivateKey.getCurvetype() == 524289) {
                refPrivateKey.setCurvetype(0);
            }
            if ((flag = this.instanseSDF.SDF_ExternalSign_ECDSA(pSessionHandle, 524544, refPrivateKey, input, input.length, signOut = new byte[160], uiSignatureDataLength)) != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            int signLen = uiSignatureDataLength.getValue();
            byte[] signResult = new byte[signLen];
            System.arraycopy(signOut, 0, signResult, 0, signLen);
            refSignature.decode(signResult);
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsaRefSignature:" + refSignature.toString());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.sm2Sign() end.");
        }
        return refSignature;
    }

    @Override
    public boolean ecdsaVerify(int keyIndex, int keyType, byte[] dataInput, ECDSArefSignature refSig) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaVerify()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            }
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The ECDSArefSignature data is null.");
            }
            throw new CryptoException("The ECDSArefSignature data is null.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("keyIndex:" + keyIndex);
            logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalVerify_ECDSA(pSessionHandle, keyIndex, 524544, dataInput, dataInput.length, refSig, refSig.size()) : this.instanseSDF.SDF_InternalVerify_ECDSA(pSessionHandle, keyIndex, 524800, dataInput, dataInput.length, refSig, refSig.size());
            if (flag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaVerify() end.");
        }
        if (flag != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("result:false");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("result:true");
        }
        return true;
    }

    @Override
    public boolean ecdsaVerify(ECDSArefPublicKey refPublicKey, byte[] dataInput, ECDSArefSignature refSig) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaVerify()...");
        }
        if (refPublicKey == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The ECDSArefPublicKey data is null.");
            }
            throw new CryptoException("The ECDSArefPublicKey data is null.");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The ECDSArefSignature data is null.");
            }
            throw new CryptoException("The ECDSArefSignature data is null.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refPublicKey:" + refPublicKey.toString());
            logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
            logger.fine("refSig:" + refSig.toString());
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            Pointer pSessionHandle;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            if (refPublicKey.getCurvetype() == 524289) {
                refPublicKey.setCurvetype(0);
            }
            if ((flag = this.instanseSDF.SDF_ExternalVerify_ECDSA(pSessionHandle = ppSessionHandle.getValue(), 524544, refPublicKey, dataInput, dataInput.length, refSig, refSig.size())) != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.ecdsaVerify() end.");
        }
        if (flag != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("result:false");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("result:true");
        }
        return true;
    }

    @Override
    public DSArefKeyPair generateDSAKeyPair(int keysize) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public IDSArefPublicKey getDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public DSArefSignature dsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public DSArefSignature dsaSign(IDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public boolean dsaVerify(int keyIndex, int keyType, byte[] dataInput, DSArefSignature refSig) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public boolean dsaVerify(IDSArefPublicKey refPublicKey, byte[] dataInput, DSArefSignature refSig) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void generateKey(int keyIndex, int keysize) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.encrypt()...");
        }
        if (key == null || 0 == key.length) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The Key data is null.");
            }
            throw new CryptoException("The Key data is null.");
        }
        if (!SymmetryUtil.isRightAlg(algId)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            }
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("IV data length error.");
            }
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Input data length error.");
            }
            throw new CryptoException("Input data length error.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("algId:" + algId);
            logger.fine("key:" + BytesUtil.bytes2hex(key));
            logger.fine("iv:" + BytesUtil.bytes2hex(iv));
            logger.fine("input:" + BytesUtil.bytes2hex(input));
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_ImportKey(pSessionHandle, key, key.length, phKeyHandle);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Encrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.encrypt() end.");
        }
        return pucDataOutput;
    }

    @Override
    public byte[] decrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.decrypt()...");
        }
        if (key == null || 0 == key.length) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The Key data is null.");
            }
            throw new CryptoException("The Key data is null.");
        }
        if (!SymmetryUtil.isRightAlg(algId)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            }
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("IV data length error.");
            }
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Input data length error.");
            }
            throw new CryptoException("Input data length error.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("algId:" + algId);
            logger.fine("key:" + BytesUtil.bytes2hex(key));
            logger.fine("iv:" + BytesUtil.bytes2hex(iv));
            logger.fine("input:" + BytesUtil.bytes2hex(input));
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_ImportKey(pSessionHandle, key, key.length, phKeyHandle);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Decrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.decrypt() end.");
        }
        return pucDataOutput;
    }

    @Override
    public byte[] encrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.encrypt()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (!SymmetryUtil.isRightAlg(algId)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            }
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("IV data length error.");
            }
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Input data length error.");
            }
            throw new CryptoException("Input data length error.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_GetSymmKeyHandle(pSessionHandle, keyIndex, phKeyHandle);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Encrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.encrypt() end.");
        }
        return pucDataOutput;
    }

    @Override
    public byte[] decrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.decrypt()...");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (!SymmetryUtil.isRightAlg(algId)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            }
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("IV data length error.");
            }
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Input data length error.");
            }
            throw new CryptoException("Input data length error.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_GetSymmKeyHandle(pSessionHandle, keyIndex, phKeyHandle);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Decrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.decrypt() end.");
        }
        return pucDataOutput;
    }

    @Override
    public byte[] encrypt_add(int algId, byte[] key, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] decrypt_add(int algId, byte[] key, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt_add(int algId, int keyIndex, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] decrypt_add(int algId, int keyIndex, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void inputKEK(int keyIndex, byte[] key) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void importKeyPair_ECC(int keyIndex, int keyType, int keyPriKeyIndex, byte[] eccPairEnvelopedKey) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void importEncKeyPair_ECC(int keyIndex, byte[] eccPairEnvelopedKey) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] genKCV(int keyIndex) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] generateHMAC(int algId, int keyIndex, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] generateHMAC(int algId, byte[] key, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] genPBKDF2Key(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] genPBKDF2KeyExt(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt, int keyIndex) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] ecdhAgreement(int ecdsIndex, int keyType, byte[] pubKey) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] ecdhAgreement(byte[] priKey, byte[] pubKey) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public int hsmCreateFile(String fileName, int maxLength) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] hsmReadFile(String fileName, int startPosition, int readLength) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public int hsmWriteFile(String fileName, int startPosition, byte[] data) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public int hsmDeleteFile(String fileName) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public IRSArefPublicKey getRSAPublicKey(String keyLabel) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void generateRSAKeyPair(String keyLabel, int keysize) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] rsaPublicKeyOperation(String keyLabel, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] rsaPrivateKeyOperation(String keyLabel, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void rsaImportKeyPair(String keyLabel, IRSArefPublicKey refPublicKey, IRSArefPrivateKey refPrivateKey) throws CryptoException {
    }

    @Override
    public void rsaDeleteKeyPair(String keyLabel) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void generateKey(String keyLabel, int keysize) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt(int algId, String keyLabel, byte[] iv, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] decrypt(int algId, String keyLabel, byte[] iv, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt_add(int algId, String keyLabel, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] decrypt_add(int algId, String keyLabel, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] genPBKDF2KeyExt(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt, String keyLabel) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public List<byte[]> SDF_GenerateEncKeyPairWithKEK(int alg, int bits, int kekIndex, int kekAlg) throws CryptoException {
        return null;
    }

    @Override
    public byte[] SDF_SignWithEncPrivateKey(int signAlg, int hashAlg, int kekAlg, int kekIndex, byte[] encPrivateKey, byte[] data) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_GeneratSymEncKey(int alg, int kekIndex, int keyBits) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_SymEncryptWithEncKey(int alg, byte[] encKey, int paddingType, byte[] iv, int kekAlg, int kekIndex, byte[] data) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_SymDecryptWithEncKey(int alg, byte[] encKey, int paddingType, byte[] iv, int kekAlg, int kekIndex, byte[] data) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_HMACWithKEK(int alg, int kekIndex, byte[] data) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_DerivativePubSign(byte[] A, byte[] kS, int i, int j) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_DerivativePubEnc(byte[] A, byte[] kS, int i, int j) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_DerivativePriSign(byte[] A, byte[] kS, int i, int j) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_DerivativePriEnc(byte[] p, byte[] kE, int i, int j) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_MakeFullPubKey(byte[] Bij, byte[] C) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public byte[] SDF_MakeFullPriKey(byte[] bij, byte[] c) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void deleteKey(String keyLabel) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void importKey(String keyLabel, byte[] key) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public void SDF_InitECC_Secp256k1() throws CryptoException {
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_InitECC_Secp256k1(pSessionHandle);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_InitECC_Secp256k1() end.");
        }
    }

    @Override
    public void SWCSM_GenerateECCKeyPair_ECDSA(int uiKeyNumber, ECCrefCurveParam pECCParam) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SWCSM_GenerateECCKeyPair_ECDSA()...");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("uiKeyNumber:" + uiKeyNumber);
            logger.fine("ECCrefCurveParam:" + pECCParam.toString());
        }
        if (pECCParam == null) {
            throw new CryptoException("Illegal pECCParam(null).");
        }
        if (uiKeyNumber <= 0) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal uiKeyNumber.");
            }
            throw new CryptoException("Illegal uiKeyNumber.");
        }
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SWCSM_GenerateECCKeyPair_ECDSA(pSessionHandle, uiKeyNumber, pECCParam);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SWCSM_GenerateECCKeyPair_ECDSA() end.");
        }
    }

    @Override
    public ECCrefKeyPair SDF_GenerateKeyPair_ECDSA(int uiAlgID, int uiKeyBits, ECCrefCurveParam pECCParam) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_GenerateKeyPair_ECDSA()...");
        }
        if (uiAlgID != 131328 && uiAlgID != 132096) {
            throw new CryptoException("Illegal uiAlgID parameter(" + uiAlgID + ")");
        }
        if (uiKeyBits <= 0) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Illegal uiKeyBits.");
            }
            throw new CryptoException("Illegal uiKeyBits.");
        }
        if (pECCParam == null) {
            throw new CryptoException("Illegal pECCParam(null).");
        }
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        ECCrefPublicKey pucPublicKey = null;
        ECCrefPrivateKey pucPrivateKey = null;
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_GenerateKeyPair_ECDSA(pSessionHandle, uiAlgID, uiKeyBits, pECCParam, pucPublicKey = new ECCrefPublicKey(), pucPrivateKey = new ECCrefPrivateKey());
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("pucPublicKey:" + pucPublicKey.toString());
            logger.fine("pucPrivateKey:" + pucPrivateKey.toString());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_GenerateKeyPair_ECDSA() end.");
        }
        return new ECCrefKeyPair(pucPublicKey, pucPrivateKey);
    }

    @Override
    public ECCSignature SDF_ExternalSign_ECDSA(int uiAlgID, ECCrefPrivateKey pucPrivateKey, byte[] pucData, int uiDataLength) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_ExternalSign_ECDSA()...");
        }
        if (uiAlgID != 131328 && uiAlgID != 132096) {
            throw new CryptoException("Illegal uiAlgID parameter(" + uiAlgID + ")");
        }
        if (pucPrivateKey == null) {
            throw new CryptoException("Illegal pucPrivateKey(null).");
        }
        if (pucData == null || pucData.length == 0) {
            throw new CryptoException("Illegal pucData(null).");
        }
        if (uiDataLength <= 0) {
            throw new CryptoException("Illegal uiDataLength(<0).");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("uiAlgID:" + uiAlgID);
            logger.fine("pucPrivateKey:" + pucPrivateKey.toString());
            logger.fine("pucData:" + BytesUtil.bytes2hex(pucData));
            logger.fine("uiDataLength:" + uiDataLength);
        }
        ECCSignature refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiSignatureDataLength = new IntByReference(0);
            refSignature = new ECCSignature();
            int flag = 0;
            flag = this.instanseSDF.SDF_ExternalSign_ECDSA(pSessionHandle, uiAlgID, pucPrivateKey, pucData, uiDataLength, refSignature);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("eccRefSignature:" + refSignature.toString());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_ExternalSign_ECDSA() end.");
        }
        return refSignature;
    }

    @Override
    public boolean SDF_ExternalVerify_ECDSA(int uiAlgID, ECCrefPublicKey pucPublicKey, byte[] pucDataInput, int uiInputLength, ECCSignature pucSignature) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_ExternalVerify_ECDSA()...");
        }
        if (uiAlgID != 131328 && uiAlgID != 132096) {
            throw new CryptoException("Illegal uiAlgID parameter(" + uiAlgID + ")");
        }
        if (pucPublicKey == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The ECCrefPublicKey data is null.");
            }
            throw new CryptoException("The ECCrefPublicKey data is null.");
        }
        if (pucDataInput == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The pucDataInput data is null.");
            }
            throw new CryptoException("The pucDataInput data is null.");
        }
        if (uiInputLength <= 0) {
            throw new CryptoException("Illegal uiInputLength(<0).");
        }
        if (pucSignature == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The pucSignature data is null.");
            }
            throw new CryptoException("The pucSignature data is null.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("pucPublicKey:" + pucPublicKey.toString());
            logger.fine("pucDataInput:" + BytesUtil.bytes2hex(pucDataInput));
            logger.fine("pucSignature:" + pucSignature.toString());
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = this.instanseSDF.SDF_ExternalVerify_ECDSA(pSessionHandle, uiAlgID, pucPublicKey, pucDataInput, uiInputLength, pucSignature);
            if (flag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_ExternalVerify_ECDSA() end.");
        }
        if (flag != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("result:false");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("result:true");
        }
        return true;
    }

    @Override
    public ECCSignature SDF_InternalSign_ECDSA_Ex(int uiISKIndex, int uiAlgID, byte[] pucData, int uiDataLength) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_InternalSign_ECDSA_Ex()...");
        }
        if (uiISKIndex < 1) {
            throw new CryptoException("Illegal key index( " + uiISKIndex + " )");
        }
        if (uiAlgID != 131328 && uiAlgID != 132096) {
            throw new CryptoException("Illegal uiAlgID parameter(" + uiAlgID + ")");
        }
        if (pucData == null || pucData.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (uiDataLength <= 0) {
            throw new CryptoException("Illegal uiDataLength(<0).");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("uiISKIndex:" + uiISKIndex);
            logger.fine("pucData:" + BytesUtil.bytes2hex(pucData));
        }
        ECCSignature refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            refSignature = new ECCSignature();
            int flag = 0;
            flag = this.instanseSDF.SDF_InternalSign_ECDSA_Ex(pSessionHandle, uiISKIndex, uiAlgID, pucData, pucData.length, refSignature);
            if (flag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ecdsaRefSignature:" + refSignature.toString());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_InternalSign_ECDSA_Ex() end.");
        }
        return refSignature;
    }

    @Override
    public boolean SDF_InternalVerify_ECDSA_Ex(int uiISKIndex, int uiAlgID, byte[] pucData, int uiDataLength, ECCSignature pucSignature) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_InternalVerify_ECDSA_Ex()...");
        }
        if (uiISKIndex < 1) {
            throw new CryptoException("Illegal key index( " + uiISKIndex + " )");
        }
        if (uiAlgID != 131328 && uiAlgID != 132096) {
            throw new CryptoException("Illegal uiAlgID parameter(" + uiAlgID + ")");
        }
        if (pucData == null || pucData.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (uiDataLength <= 0) {
            throw new CryptoException("Illegal uiDataLength(<0).");
        }
        if (pucSignature == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("The ECCSignature data is null.");
            }
            throw new CryptoException("The ECCSignature data is null.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("uiISKIndex:" + uiISKIndex);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("pucData:" + BytesUtil.bytes2hex(pucData));
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                }
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = this.instanseSDF.SDF_InternalVerify_ECDSA_Ex(pSessionHandle, uiISKIndex, uiAlgID, pucData, pucData.length, pucSignature);
            if (flag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != 0 && logger.isLoggable(Level.INFO)) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> LIBCrypto.SDF_InternalVerify_ECDSA_Ex() end.");
        }
        if (flag != 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("result:false");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("result:true");
        }
        return true;
    }

    @Override
    public EdDSArefKeyPair generateEdDSAKeyPair(int keysize, int curetype) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public EdDSArefPublicKey getEdDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public EdDSArefSignature eddsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public EdDSArefSignature eddsaSign(EdDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public boolean eddsaVerify(int keyIndex, int keyType, byte[] dataInput, EdDSArefSignature refSig) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }

    @Override
    public boolean eddsaVerify(EdDSArefPublicKey refPublicKey, byte[] dataInput, EdDSArefSignature refSig) throws CryptoException {
        throw new CryptoException("LIBCrypto unrealized method...");
    }
}

