/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.HSMStateListener;
import com.sansec.devicev4.crypto_hsm.config.ConfigFile;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSession;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.ListenerTast;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.RepairPool;
import com.sansec.devicev4.log.CryptoLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class HSMPool {
    private Logger logger = CryptoLogger.logger;
    private List<HSMSession> allSessions = new ArrayList<HSMSession>();
    private List<HSMSession> sessions = new ArrayList<HSMSession>();
    private static HSMPool pool = new HSMPool();
    private boolean initialize = false;
    private HSMStateListener hsmStateListener = null;
    public String loginPass = null;
    public String keyStorePass = null;
    public String trustKeyStorePass = null;
    public ConfigFile profile = null;

    private HSMPool() {
    }

    public static HSMPool getPool() {
        return pool;
    }

    public void setHsmStateListener(HSMStateListener hsmStateListener, int listenerSleepTime) {
        if (hsmStateListener != null) {
            this.hsmStateListener = hsmStateListener;
            if (listenerSleepTime > 0) {
                ListenerTast listenerTast = new ListenerTast(listenerSleepTime);
                Thread listenerThread = new Thread(listenerTast);
                listenerThread.setDaemon(true);
                listenerThread.setName("listenerTast");
                listenerThread.start();
            }
        }
    }

    public HSMStateListener getHsmStateListener() {
        return this.hsmStateListener;
    }

    public List<HSMSession> getAllSessions() {
        return this.allSessions;
    }

    public void addHsm(ConfigFile configFile, int i, int index) {
        HSMSocket socket = null;
        for (HSMSession session : this.allSessions) {
            socket = session.addHsm(configFile, i, index);
        }
        try {
            RepairPool rt = new RepairPool(socket);
            Thread t1 = new Thread(rt);
            t1.setDaemon(true);
            t1.setName("RepairPool");
            t1.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void release() {
        pool = new HSMPool();
    }

    public synchronized void initialize(ConfigFile profile, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (!this.initialize) {
            try {
                this.profile = profile;
                this.loginPass = loginPass;
                this.keyStorePass = keyStorePass;
                this.trustKeyStorePass = trustStorePass;
                HSMSession session = new HSMSession(profile, loginPass, keyStorePass, trustStorePass);
                this.sessions.add(session);
                this.allSessions.add(session);
            }
            catch (Exception e) {
                HSMSession session = new HSMSession(profile, loginPass, keyStorePass, trustStorePass);
                this.sessions.add(session);
                this.allSessions.add(session);
            }
            this.initialize = true;
            try {
                new Thread(new Pool(profile, loginPass, keyStorePass, trustStorePass)).start();
            }
            catch (Exception e) {
                throw new CryptoException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSMSession getSession() {
        HSMSession session = null;
        List<HSMSession> list = this.sessions;
        synchronized (list) {
            while (this.sessions.size() == 0) {
                try {
                    this.sessions.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            session = this.sessions.remove(0);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(HSMSession session) {
        List<HSMSession> list = this.sessions;
        synchronized (list) {
            this.sessions.add(session);
            if (this.sessions.size() >= 1) {
                this.sessions.notifyAll();
            }
        }
    }

    public synchronized boolean isInitialize() {
        return this.initialize;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = null;
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive()) continue;
            try {
                String groupName = threads[i].getThreadGroup().getName();
                if (!groupName.equalsIgnoreCase("main")) continue;
                String threadName = threads[i].getName();
                if (threadName.length() >= 6) {
                    threadName = threadName.substring(0, 6);
                }
                if (!threadName.equalsIgnoreCase("repair")) continue;
                threads[i].stop();
                continue;
            }
            catch (Throwable e) {
                System.out.println("stop thread error:" + e.getMessage());
            }
        }
        while (this.allSessions.size() > 0) {
            HSMSession session = this.allSessions.remove(0);
            for (int size = session.getSize(); size > 0; --size) {
                HSMSocket socket = session.getHsmSocket();
                socket.close();
            }
        }
    }

    private class Pool
    implements Runnable {
        private ConfigFile profile;
        private String loginPass;
        private String keyStorePass;
        private String trustStorePass;

        public Pool(ConfigFile profile, String loginPass, String keyStorePass, String trustStorePass) {
            this.profile = profile;
            this.loginPass = loginPass;
            this.keyStorePass = keyStorePass;
            this.trustStorePass = trustStorePass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int poolsize = this.profile.getPoolsize();
            for (int i = 0; i < poolsize - 1; ++i) {
                try {
                    HSMSession session = new HSMSession(this.profile, this.loginPass, this.keyStorePass, this.trustStorePass);
                    HSMPool hSMPool = pool;
                    synchronized (hSMPool) {
                        HSMPool.this.sessions.add(session);
                        HSMPool.this.allSessions.add(session);
                        continue;
                    }
                }
                catch (CryptoException ex) {
                    throw new RuntimeException(ex);
                }
            }
            List list = HSMPool.this.sessions;
            synchronized (list) {
                if (HSMPool.this.sessions.size() >= 1) {
                    HSMPool.this.sessions.notifyAll();
                }
            }
        }
    }
}

