/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.crypto_hsm.config.ConfigFile;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocketException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.TLSManagers;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.HSMInfo;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.ReqLogin;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.RespHeader;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Response;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;

public class HSMSocket
implements HandshakeCompletedListener {
    private Logger logger = CryptoLogger.logger;
    private String ip;
    private int port;
    private String passwd;
    private int connectTimeout;
    private int serviceTimeout;
    private volatile int status = 1;
    private Socket socket;
    private OutputStream out;
    private InputStream in;
    private boolean ssl = false;
    private String protocol = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private String trustKeyStore = null;
    private String trustKeyStorePassword = null;
    private String trustKeyStoreType = null;
    private String includeCipherSuiteFilter = null;
    private String excludeCipherSuiteFilter = null;
    private int indexOfSession = 0;

    public void setIndexOfSession(int indexOfSession) {
        this.indexOfSession = indexOfSession;
    }

    public String getIp() {
        return this.ip;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getPort() {
        return this.port;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public int getServiceTimeout() {
        return this.serviceTimeout;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public InputStream getIn() {
        return this.in;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public String getTrustKeyStorePassword() {
        return this.trustKeyStorePassword;
    }

    public String getTrustKeyStoreType() {
        return this.trustKeyStoreType;
    }

    public HSMSocket(String ip, String passwd, int port, int connectTimeout, int serviceTimeout) {
        this.ip = ip;
        this.passwd = passwd;
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.serviceTimeout = serviceTimeout;
        this.ssl = false;
        this.indexOfSession = 1;
    }

    public HSMSocket(ConfigFile profile, HSMInfo hsmInfo, int indexOfSession, String loginPass, String keyStorePass, String trustStorePass) {
        this.ip = hsmInfo.getIp();
        this.passwd = hsmInfo.getConnectPwd();
        if (loginPass != null && loginPass.trim().length() != 0) {
            this.passwd = loginPass;
        }
        if (this.passwd == null || this.passwd.trim().length() == 0) {
            throw new RuntimeException("HSM password cannot be null");
        }
        this.port = hsmInfo.getPort();
        this.connectTimeout = profile.getConnectTimeout();
        this.serviceTimeout = profile.getServiceTimeout();
        this.ssl = profile.isSsl();
        this.protocol = profile.getProtocol();
        this.keyStore = profile.getKeyStore();
        this.keyStorePassword = profile.getKeyStorePassword();
        if (keyStorePass != null) {
            this.keyStorePassword = keyStorePass;
        }
        if (this.ssl && (this.keyStorePassword == null || this.keyStorePassword.trim().length() == 0)) {
            throw new RuntimeException("KeyStore password cannot be null");
        }
        this.keyStoreType = profile.getKeyStoreType();
        this.trustKeyStore = profile.getTrustKeyStore();
        this.trustKeyStorePassword = profile.getTrustKeyStorePassword();
        if (trustStorePass != null) {
            this.trustKeyStorePassword = trustStorePass;
        }
        if (this.ssl && (this.trustKeyStorePassword == null || this.trustKeyStorePassword.trim().length() == 0)) {
            throw new RuntimeException("TrustKeyStore password cannot be null");
        }
        this.trustKeyStoreType = profile.getTrustKeyStoreType();
        this.includeCipherSuiteFilter = profile.getIncludeCipherSuiteFilter();
        this.excludeCipherSuiteFilter = profile.getExcludeCipherSuiteFilter();
        this.indexOfSession = indexOfSession;
    }

    public int getIndexOfSession() {
        return this.indexOfSession;
    }

    public void repair(long threadid) throws HSMSocketException {
        this.logger.info("-> repair()...");
        this.close();
        this.login();
        this.logger.info("<- repair() end");
    }

    public Response sendAndReceive(byte[] command) throws HSMSocketException {
        this.logger.info("-> sendAndReceive()...");
        this.logger.fine("=> command=" + BytesUtil.bytes2hex(command));
        boolean doReapir = false;
        try {
            int available = this.in.available();
            if (available > 0) {
                doReapir = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("=> doReapir=" + doReapir);
            this.logger.fine("=> socket.isClosed()=" + this.socket.isClosed());
            this.logger.fine("=> socket.isConnected()=" + this.socket.isConnected());
        }
        if (doReapir || this.socket.isClosed() || !this.socket.isConnected()) {
            this.repair(Thread.currentThread().getId());
        }
        try {
            this.out.write(command);
            this.out.flush();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "Write command to out error", e);
            }
            throw new HSMSocketException("Send command failed[ " + e.getMessage() + " ]", e);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        RespHeader header = null;
        int retLen = 0;
        try {
            int iLeftLen;
            byte[] buf = new byte[12];
            retLen = this.in.read(buf, 0, buf.length);
            if (buf.length != retLen) {
                throw new HSMSocketException("Read return header error,retLen=" + retLen + ",buf=" + BytesUtil.bytes2hex(buf));
            }
            outStream.write(buf);
            header = new RespHeader(buf);
            buf = new byte[iLeftLen > 8000 ? 8000 : iLeftLen];
            for (iLeftLen = header.getTotalLength() - header.size(); iLeftLen > 0; iLeftLen -= retLen) {
                retLen = this.in.read(buf, 0, buf.length);
                if (retLen == -1) {
                    throw new HSMSocketException("Read response error");
                }
                outStream.write(buf, 0, retLen);
            }
        }
        catch (Exception e) {
            throw new HSMSocketException("Read return response failed[ " + e.getMessage() + " ]", e);
        }
        byte[] outBuffer = outStream.toByteArray();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("=> response=" + BytesUtil.bytes2hex(outBuffer));
        }
        this.logger.info("<- sendAndReceive() end");
        return new Response(outBuffer);
    }

    public void login() throws HSMSocketException {
        this.logger.info("-> login()...");
        this.logger.fine("=> ip=" + this.ip);
        this.logger.fine("=> port=" + this.port);
        this.logger.fine("=> status=" + this.status);
        this.logger.fine("=> connectTimeout=" + this.connectTimeout);
        this.logger.fine("=> serviceTimeout=" + this.serviceTimeout);
        ReqLogin lrh = new ReqLogin();
        try {
            lrh.setConnectPwd(this.passwd.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new HSMSocketException("passwd get UTF-8 bytes error,", e);
        }
        catch (CryptoException e) {
            throw new HSMSocketException("passwd get UTF-8 bytes error,", e);
        }
        Response response = null;
        byte[] sendBuffer = lrh.encode();
        try {
            this.socket = this.createSocket();
            this.socket.setReceiveBufferSize(16384);
            this.socket.setSendBufferSize(16384);
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress(this.ip, this.port), this.connectTimeout * 1000);
            this.socket.setSoTimeout(this.serviceTimeout * 1000);
            this.socket.setKeepAlive(true);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.close();
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "The first connection to hsm failed, try again...", e);
            }
            try {
                this.socket = this.createSocket();
                this.socket.setReceiveBufferSize(16384);
                this.socket.setSendBufferSize(16384);
                this.socket.setTcpNoDelay(true);
                this.socket.connect(new InetSocketAddress(this.ip, this.port), 1000);
                this.socket.setSoTimeout(this.serviceTimeout * 1000);
                this.socket.setKeepAlive(true);
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
            }
            catch (IOException e1) {
                this.close();
                throw new HSMSocketException("Try to connect to hsm failed again", e1);
            }
        }
        try {
            response = this.sendAndReceive(sendBuffer);
        }
        catch (HSMSocketException e) {
            this.close();
            throw new HSMSocketException("Send login request failed", e);
        }
        if (response.getErrorCode() != 0) {
            this.close();
            throw new HSMSocketException("Socket[" + this + "] return [" + response.getErrorInfo() + "]");
        }
        this.status = 0;
        this.logger.info("<- login() end");
    }

    public void close() {
        this.logger.info("-> close()...");
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.info("<- close() end");
    }

    private Socket createSocket() throws HSMSocketException {
        Socket socket = null;
        if (this.ssl) {
            try {
                SSLContext context = TLSManagers.getSSLContext(this.protocol, this.keyStoreType, this.keyStore, this.keyStorePassword, this.trustKeyStoreType, this.trustKeyStore, this.trustKeyStorePassword);
                SSLSocket sslSocket = (SSLSocket)context.getSocketFactory().createSocket();
                sslSocket.setEnabledProtocols(new String[]{this.protocol});
                ArrayList<String> enableCipherSuiteList = new ArrayList<String>();
                String[] cipherSuites = sslSocket.getSupportedCipherSuites();
                if (this.includeCipherSuiteFilter != null && !this.includeCipherSuiteFilter.equals("")) {
                    for (String cipherSuite : cipherSuites) {
                        if (!this.isMatch(this.includeCipherSuiteFilter, cipherSuite)) continue;
                        enableCipherSuiteList.add(cipherSuite);
                    }
                    cipherSuites = enableCipherSuiteList.toArray(new String[0]);
                }
                if (this.excludeCipherSuiteFilter != null && !this.excludeCipherSuiteFilter.equals("")) {
                    enableCipherSuiteList.clear();
                    for (String cipherSuite : cipherSuites) {
                        if (this.isMatch(this.excludeCipherSuiteFilter, cipherSuite)) continue;
                        enableCipherSuiteList.add(cipherSuite);
                    }
                }
                if (!enableCipherSuiteList.isEmpty()) {
                    sslSocket.setEnabledCipherSuites(enableCipherSuiteList.toArray(new String[0]));
                }
                socket = sslSocket;
            }
            catch (Exception e) {
                throw new HSMSocketException("Create SSLSocket error :" + e.getMessage(), e);
            }
        } else {
            socket = new Socket();
        }
        return socket;
    }

    private boolean isMatch(String pattern, String cipherSuite) {
        return Pattern.matches(pattern, cipherSuite);
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        block3: {
            if (this.logger.isLoggable(Level.INFO)) {
                try {
                    this.logger.info("Use SSL protocol is " + event.getSession().getProtocol());
                    this.logger.info("Use SSL cipher suite is " + event.getSession().getCipherSuite());
                    X509Certificate serverCert = (X509Certificate)event.getPeerCertificates()[0];
                    this.logger.info("Server certificate issuer is " + serverCert.getIssuerDN());
                    this.logger.info("Server certificate subject is " + serverCert.getSubjectDN());
                    X509Certificate clientCert = (X509Certificate)event.getLocalCertificates()[0];
                    this.logger.info("Client certificate issuer is " + clientCert.getIssuerDN());
                    this.logger.info("Client certificate subject is " + clientCert.getSubjectDN());
                }
                catch (SSLPeerUnverifiedException ex) {
                    if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                    this.logger.severe("Get Server certifiacte error: " + ex.getMessage());
                }
            }
        }
    }

    public void checkState() {
    }

    public String toString() {
        if (this.socket == null) {
            return "[IP=" + this.ip + ",Port=" + this.port + "]";
        }
        return this.socket.toString();
    }
}

