/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.demo;

import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefSignature;
import com.sansec.devicev4.util.PrintUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;

public class CommonTest {
    static ISDSCrypto crypto = null;
    Random random = new Random();

    public CommonTest() throws CryptoException {
        crypto = SwxaDeviceFactory.getInstance("com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", "C:\\Users\\xujianchao\\Desktop\\swsds.ini");
    }

    private void test_SDF_generateEdDSAKeyPair() throws IOException {
        int keysize = 0;
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit 256)\uff1a");
        String bitsStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        keysize = Integer.parseInt(bitsStr);
        int curetype = 1;
        EdDSArefKeyPair out = null;
        try {
            out = crypto.generateEdDSAKeyPair(keysize, curetype);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->curetype[" + curetype + "]");
        System.out.println("PublicKey:\n" + out.getPublicKey().toString());
        System.out.println("PrivateKey:\n" + out.getPrivateKey().toString());
    }

    private void test_SDF_getEdDSAPublicKey() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int index = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int type = Integer.parseInt(typeStr);
        EdDSArefPublicKey out = null;
        try {
            out = crypto.getEdDSAPublicKey(index, type);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->type[" + type + "]");
        System.out.println("PublicKey:\n" + out.toString());
    }

    private void internalEddsaSign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6(32)\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        this.random.nextBytes(inputData);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int type = Integer.parseInt(typeStr);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        EdDSArefSignature signOut = null;
        try {
            signOut = crypto.eddsaSign(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_EdDSArefSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.eddsaVerify(index, type, inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_flag:" + flag);
    }

    private void externalEddsaSign_Verfiy() throws IOException {
        int keySize = 256;
        System.out.print("\u6570\u636e\u957f\u5ea6(32)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int dataLength = Integer.parseInt(str);
        EdDSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateEdDSAKeyPair(keySize, 1);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(keyPair.toString());
        byte[] inputData = new byte[dataLength];
        this.random.nextBytes(inputData);
        EdDSArefSignature signOut = null;
        try {
            signOut = crypto.eddsaSign(keyPair.getPrivateKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->EdDSArefSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.eddsaVerify(keyPair.getPublicKey(), inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->flag:" + flag);
    }

    public static void main(String[] args) throws Exception {
        CommonTest commonTest = new CommonTest();
        block6: while (true) {
            System.out.println("++++++++++++++++++++++++++++++++++Crypto\u529f\u80fd\u6d4b\u8bd5++++++++++++++++++++++++++++++++");
            System.out.println("1:\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u5bc6\u94a5\u5bf9");
            System.out.println("2:\u5bfc\u51fa\u516c\u94a5\u4fe1\u606f");
            System.out.println("3:\u5185\u90e8EdDSA\u5bc6\u94a5\u7b7e\u540d");
            System.out.println("4:\u5916\u90e8EdDSA\u5bc6\u94a5\u7b7e\u540d");
            System.out.println("0\uff1a\u9000\u51fa");
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.print("\u9009\u62e9\u6d4b\u8bd5\uff1a");
            String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
            int choice = Integer.parseInt(str);
            switch (choice) {
                case 1: {
                    commonTest.test_SDF_generateEdDSAKeyPair();
                    continue block6;
                }
                case 2: {
                    commonTest.test_SDF_getEdDSAPublicKey();
                    continue block6;
                }
                case 3: {
                    commonTest.internalEddsaSign_Verfiy();
                    continue block6;
                }
                case 4: {
                    commonTest.externalEddsaSign_Verfiy();
                    continue block6;
                }
            }
            break;
        }
    }
}

