/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.demo;

import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.util.BytesUtil;

public class DerivativeTest {
    public static byte[] kS = new byte[]{111, 32, -19, 37, -1, 18, 5, -88, 18, -31, -127, 111, -97, -77, -41, -72};
    public static byte[] kE = new byte[]{-96, -10, -15, -89, -3, 107, -95, -11, -47, 15, -90, 2, -92, 12, 106, 18};
    public static byte[] A_Pub = new byte[]{-42, -30, -51, 15, -98, -27, 27, -71, -75, 114, 42, -53, 64, 3, -69, -81, 41, 84, -93, -22, -19, 87, -25, -110, 126, 92, -70, -93, 111, 117, 91, 103, -2, -6, -106, 59, 60, 19, 68, -95, 36, -13, 33, 79, 101, -6, -20, 80, -79, 103, -28, -68, -75, -113, -20, 126, -121, -50, -113, 64, -111, 13, -113, -94};
    public static byte[] a_Pri = new byte[]{-58, -79, 32, 40, 52, 4, 117, -121, 62, 27, -89, 77, 111, 127, 31, 25, -73, 95, 43, -30, -97, -21, -53, 88, -59, -113, 37, 86, 71, 43, 16, 40};
    public static byte[] P_Pub = new byte[]{117, -19, -82, 65, -26, 1, 73, -104, -67, -80, -85, 66, -116, 98, -47, -34, -62, -20, 7, 99, 63, 3, -87, -90, 119, 73, -77, -25, -64, -70, 23, -39, 127, -28, -55, 27, 104, 50, -97, -77, -117, -88, 105, 70, 20, 103, 18, 31, 20, -115, -36, -56, -65, -75, 75, 91, -24, -25, -32, 55, 17, -41, 104, -47};
    public static byte[] p_Pri = new byte[]{29, -49, 15, 91, -120, -25, 12, -43, 114, -104, -122, 72, -22, -13, 1, 116, 0, -124, -54, -28, 73, 105, 15, 108, 28, 58, 32, -63, -114, -80, -11, 68};
    public static byte[] Bij_Pub = new byte[]{-8, -77, -28, 83, -2, 69, 126, 119, -58, 20, -25, 47, 63, 113, 47, 126, 75, 62, 16, 15, 68, -116, -101, 6, -36, -97, -70, 97, 45, -68, 51, -32, -64, 51, 114, -124, -100, -65, 10, 84, -27, -97, 44, 4, -59, 43, -89, 46, 60, 4, 2, 54, -104, 78, 59, 5, 15, -9, 51, -55, 15, 119, 37, -25};
    public static byte[] bij_Pri = new byte[]{-109, 10, 44, -58, 63, -51, 111, 110, -123, 111, 49, -41, 75, -105, 119, -81, 36, -103, -14, -7, 113, -35, -8, 63, 65, -76, 67, 34, 41, 95, 56, -85};
    public static byte[] Qij_Pub = new byte[]{-13, -62, -15, -22, -16, 38, -50, 105, -75, 38, 85, -56, 33, -3, -125, 81, -28, -122, -21, 20, 39, -89, -71, -91, -56, 9, -25, -94, 100, -81, -15, 86, 15, 106, -68, -91, 122, -97, 37, 4, 75, -19, -105, -24, 57, 49, -26, 83, -124, 23, 85, 84, 14, 15, -106, -58, -15, 64, 33, -126, -110, -67, 1, -110};
    public static byte[] qij_Pri = new byte[]{105, 118, 37, -96, -92, 80, 114, 76, 80, -66, 37, -34, 38, -76, 66, -3, -117, -103, 8, -23, -47, -119, 6, -44, 30, -110, -125, -84, -56, -102, 1, 51};
    public static byte[] Sij_Pub = new byte[]{34, -110, -61, 62, 52, -91, -101, 31, -85, 50, -55, 35, 102, 67, -43, 13, -8, 33, -73, 27, -22, -91, -82, 50, -27, -121, -76, 21, -47, -23, 37, 25, 17, 2, 127, 50, 37, 121, -70, -22, 57, 23, 97, 119, -31, 112, -56, -25, 25, -23, -100, 63, -2, -36, -64, 25, 46, -47, -99, 55, 8, -121, 93, 95};
    public static byte[] sij_Pri = new byte[]{-94, -101, -29, -104, -38, -23, 110, 86, -4, -114, 18, -40, -49, 18, -76, -87, -42, -67, -2, 102, -11, -100, 88, 92, 78, -96, 55, -45, -48, 41, -71, 56};
    public static byte[] C_Pub = new byte[]{1, 79, -99, 116, -13, -3, 85, 19, 9, -93, -128, 52, 3, -52, 47, 90, 12, 89, 106, -115, 48, 2, -49, -64, -102, 118, -33, -53, 19, 16, -99, 104, -112, 113, 122, 61, 23, 41, -110, -58, 112, 45, -9, 94, -94, -63, 69, 119, -32, -32, 44, -78, -105, -49, -115, 111, 18, 125, -101, 76, 62, 117, 49, 106};
    public static byte[] c_Pri = new byte[]{57, 37, -67, -8, 54, -104, -4, 10, -85, -49, -20, -6, -88, 94, 113, -84, 75, 36, -11, 125, 36, 19, 81, -120, 48, 13, -76, 39, 7, -113, -72, 5};

    public static void main(String[] args) throws CryptoException {
        ISDSCrypto crypto = SwxaDeviceFactory.getInstance("com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", "C:\\Users\\xujianchao\\Desktop\\swsds.ini");
        byte[] Bij = crypto.SDF_DerivativePubSign(A_Pub, kS, 0, 0);
        System.out.println("Bij:\n" + BytesUtil.bytes2hex(Bij));
        byte[] Qij = crypto.SDF_DerivativePubEnc(P_Pub, kE, 0, 0);
        System.out.println("Qij:\n" + BytesUtil.bytes2hex(Qij));
        byte[] bij = crypto.SDF_DerivativePriSign(a_Pri, kS, 0, 0);
        System.out.println("bij:\n" + BytesUtil.bytes2hex(bij));
        byte[] qij = crypto.SDF_DerivativePriEnc(p_Pri, kE, 0, 0);
        System.out.println("qij:\n" + BytesUtil.bytes2hex(qij));
        byte[] Sij_Pub = crypto.SDF_MakeFullPubKey(Qij_Pub, C_Pub);
        System.out.println("Sij_Pub:\n" + BytesUtil.bytes2hex(Sij_Pub));
        byte[] sij_Pri = crypto.SDF_MakeFullPriKey(qij_Pri, c_Pri);
        System.out.println("sij_Pri:\n" + BytesUtil.bytes2hex(sij_Pri));
    }
}

