/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct;

import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class DeviceInfo
extends Structure {
    private static Logger logger = CryptoLogger.logger;
    public byte[] issuerName = new byte[40];
    public byte[] deviceName = new byte[16];
    public byte[] deviceSerial = new byte[16];
    public int deviceVersion;
    public int standardVersion;
    public int[] asymAlgAbility = new int[2];
    public int symAlgAbility;
    public int hashAlgAbility;
    public int bufferSize;

    public void decode(byte[] deviceData) {
        int offset = 0;
        System.arraycopy(deviceData, 0, this.issuerName, 0, 40);
        System.arraycopy(deviceData, offset += 40, this.deviceName, 0, 16);
        System.arraycopy(deviceData, offset += 16, this.deviceSerial, 0, 16);
        this.deviceVersion = BytesUtil.bytes2int(deviceData, offset += 16);
        this.standardVersion = BytesUtil.bytes2int(deviceData, offset += 4);
        this.asymAlgAbility[0] = BytesUtil.bytes2int(deviceData, offset += 4);
        this.asymAlgAbility[1] = BytesUtil.bytes2int(deviceData, offset += 4);
        this.symAlgAbility = BytesUtil.bytes2int(deviceData, offset += 4);
        this.hashAlgAbility = BytesUtil.bytes2int(deviceData, offset += 4);
        this.hashAlgAbility |= 0xBF;
        this.bufferSize = BytesUtil.bytes2int(deviceData, offset += 4);
        offset += 4;
    }

    protected List getFieldOrder() {
        return Arrays.asList("issuerName", "deviceName", "deviceSerial", "deviceVersion", "standardVersion", "asymAlgAbility", "symAlgAbility", "hashAlgAbility", "bufferSize");
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("    |    Project          |   Value  ").append(nl);
        buf.append("   _|_____________________|______________________________________________________").append(nl);
        try {
            buf.append("   1| Issuer Name         | ").append(new String(this.issuerName, "UTF-8")).append(nl);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            buf.append("   2| Device Name         | ").append(new String(this.deviceName, "UTF-8")).append(nl);
            buf.append("   3| Device Serial       | ").append(new String(this.deviceSerial, "utf-8")).append(nl);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buf.append("   4| Device Version      | ").append("v" + Integer.toHexString(this.deviceVersion)).append(nl);
        buf.append("   5| Standard version    | ").append("v" + Integer.toHexString(this.standardVersion)).append(nl);
        buf.append("   6| Asymmetric algorithm| ").append(DeviceInfo.getSuportAsymAlg(this.asymAlgAbility[0])).append(nl);
        buf.append("   7| Symmetric algorithm | ").append(DeviceInfo.getSuportSymAlg(this.symAlgAbility)).append(nl);
        buf.append("   8| Hash algorithm      | ").append(DeviceInfo.getSuportHashAlg(this.hashAlgAbility)).append(nl);
        buf.append("   9| User memory space   | ").append(this.bufferSize / 1024 + "KB").append(nl);
        return buf.toString();
    }

    private static String getSuportAsymAlg(int asymAlgAbility) {
        StringBuilder suportSymAlg = new StringBuilder();
        logger.fine("asymAlgAbility:" + asymAlgAbility);
        if ((asymAlgAbility & 0x10000 & 0xFFFF0000) != 0) {
            suportSymAlg.append(" RSA");
        }
        if ((asymAlgAbility & 0x20000 & 0xFFFF0000) != 0) {
            suportSymAlg.append(" SM2");
        }
        if ((asymAlgAbility & 0x40000 & 0xFFFF0000) != 0) {
            suportSymAlg.append(" DSA");
        }
        if ((asymAlgAbility & 0x80000 & 0xFFFF0000) != 0) {
            suportSymAlg.append(" ECDSA");
        }
        return suportSymAlg.toString();
    }

    private static String getSuportSymAlg(int symAlgAbility) {
        StringBuilder suportSymAlg = new StringBuilder();
        logger.fine("symAlgAbility:" + symAlgAbility);
        if ((symAlgAbility & 0x101 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" SM1");
        }
        if ((symAlgAbility & 0x8001 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" SM7");
        }
        if ((symAlgAbility & 0x201 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" SSF33");
        }
        if ((symAlgAbility & 0x401 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" AES");
        }
        if ((symAlgAbility & 0x801 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" 3DES");
        }
        if ((symAlgAbility & 0x2001 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" SM4");
        }
        if ((symAlgAbility & 0x4002 & 0xFFFFFF00) != 0) {
            suportSymAlg.append(" DES");
        }
        return suportSymAlg.toString();
    }

    private static String getSuportHashAlg(int hsahAlgAbility) {
        StringBuilder suportHashAlg = new StringBuilder();
        logger.fine("hsahAlgAbility:" + hsahAlgAbility);
        if ((hsahAlgAbility & 1) != 0) {
            suportHashAlg.append(" SM3");
        }
        if ((hsahAlgAbility & 2) != 0) {
            suportHashAlg.append(" SHA1");
        }
        if ((hsahAlgAbility & 4) != 0) {
            suportHashAlg.append(" SHA256");
        }
        if ((hsahAlgAbility & 8) != 0) {
            suportHashAlg.append(" SHA512");
        }
        if ((hsahAlgAbility & 0x10) != 0) {
            suportHashAlg.append(" SHA384");
        }
        if ((hsahAlgAbility & 0x20) != 0) {
            suportHashAlg.append(" SHA224");
        }
        if ((hsahAlgAbility & 0x80) != 0) {
            suportHashAlg.append(" MD5");
        }
        return suportHashAlg.toString();
    }

    public static class ByReference
    extends DeviceInfo
    implements Structure.ByReference {
    }
}

