/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.dsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DSArefPublicKeyEx
extends Structure
implements IDSArefPublicKey {
    public int bits;
    public byte[] p = new byte[512];
    public byte[] q = new byte[32];
    public byte[] g = new byte[512];
    public byte[] pubkey = new byte[512];

    public DSArefPublicKeyEx() {
    }

    public DSArefPublicKeyEx(int bits, byte[] p, byte[] q, byte[] g, byte[] pubkey) {
        if (p.length > 513) {
            throw new RuntimeException("p length[ " + p.length + " ]");
        }
        this.bits = bits;
        if (p[0] == 0 && p.length % 64 == 1) {
            System.arraycopy(p, 1, this.p, 512 - (p.length - 1), p.length - 1);
        } else {
            System.arraycopy(p, 0, this.p, 512 - p.length, p.length);
        }
        if (q.length > 33) {
            throw new RuntimeException("q length[ " + q.length + " ]");
        }
        if (q[0] == 0 && q.length % 8 == 1) {
            System.arraycopy(q, 1, this.q, 32 - (q.length - 1), q.length - 1);
        } else {
            System.arraycopy(q, 0, this.q, 32 - q.length, q.length);
        }
        if (g.length > 513) {
            throw new RuntimeException("g length[ " + g.length + " ]");
        }
        if (g[0] == 0 && g.length % 64 == 1) {
            System.arraycopy(g, 1, this.g, 512 - (g.length - 1), g.length - 1);
        } else {
            System.arraycopy(g, 0, this.g, 512 - g.length, g.length);
        }
        if (pubkey.length > 513) {
            throw new RuntimeException("q length[ " + q.length + " ]");
        }
        if (pubkey[0] == 0 && pubkey.length % 64 == 1) {
            System.arraycopy(pubkey, 1, this.pubkey, 512 - (pubkey.length - 1), pubkey.length - 1);
        } else {
            System.arraycopy(pubkey, 0, this.pubkey, 512 - pubkey.length, pubkey.length);
        }
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public byte[] getP() {
        return this.p;
    }

    @Override
    public byte[] getQ() {
        return this.q;
    }

    @Override
    public byte[] getG() {
        return this.g;
    }

    @Override
    public byte[] getPubkey() {
        return this.pubkey;
    }

    @Override
    public void decode(byte[] bytes) throws CryptoException {
        this.bits = BytesUtil.bytes2int(bytes);
        int pos = 4;
        System.arraycopy(bytes, pos, this.p, 0, 512);
        System.arraycopy(bytes, pos += this.p.length, this.q, 0, 32);
        System.arraycopy(bytes, pos += this.q.length, this.g, 0, 512);
        System.arraycopy(bytes, pos += this.g.length, this.pubkey, 0, 512);
        if ((pos += this.pubkey.length) != bytes.length) {
            throw new CryptoException("inputData length != DSArefPublicKeyEx length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(this.p);
            buf.write(this.q);
            buf.write(this.g);
            buf.write(this.pubkey);
        }
        catch (IOException e) {
            throw new CryptoException("DSArefPublicKeyEx encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public String toString() {
        return "DSArefPublicKeyEx{bits=" + this.bits + ", p=" + BytesUtil.bytes2hex(this.p) + ", q=" + BytesUtil.bytes2hex(this.q) + ", g=" + BytesUtil.bytes2hex(this.g) + ", pubkey=" + BytesUtil.bytes2hex(this.pubkey) + '}';
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("bits", "p", "q", "g", "pubkey");
    }
}

