/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.ecdsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ECDSArefPrivateKey
extends Structure
implements IKeyPair {
    public int bits;
    public int curvetype;
    public byte[] D = new byte[80];

    public ECDSArefPrivateKey() {
    }

    public ECDSArefPrivateKey(int bits, int curvetype, byte[] D) {
        this.bits = bits;
        this.curvetype = curvetype;
        if (D.length > 80) {
            System.arraycopy(D, D.length - 80, this.D, 0, this.D.length);
        } else {
            System.arraycopy(D, 0, this.D, this.D.length - D.length, D.length);
        }
    }

    public int getBits() {
        return this.bits;
    }

    public int getCurvetype() {
        return this.curvetype;
    }

    public void setCurvetype(int curvetype) {
        this.curvetype = curvetype;
    }

    public byte[] getD() {
        return this.D;
    }

    @Override
    public void decode(byte[] privateKey) throws CryptoException {
        this.bits = BytesUtil.bytes2int(privateKey);
        int pos = 4;
        byte[] tmpBuffer = new byte[4];
        System.arraycopy(privateKey, pos, tmpBuffer, 0, tmpBuffer.length);
        this.curvetype = BytesUtil.bytes2int(tmpBuffer);
        System.arraycopy(privateKey, pos += tmpBuffer.length, this.D, 0, 80);
        if ((pos += this.D.length) != privateKey.length) {
            throw new CryptoException("inputData length != ECDSAPrivateKey length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(BytesUtil.int2bytes(this.curvetype));
            buf.write(this.D);
        }
        catch (IOException e) {
            throw new CryptoException("ECDSArefPrivateKey encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 88;
    }

    @Override
    public String toString() {
        return "ECDSArefPrivateKey{bits=" + this.bits + ", curvetype=" + Integer.toHexString(this.curvetype) + ", D=" + BytesUtil.bytes2hex(this.D) + '}';
    }

    protected List getFieldOrder() {
        return Arrays.asList("bits", "curvetype", "D");
    }

    public static class ByValue
    extends ECDSArefPrivateKey
    implements Structure.ByValue {
    }

    public static class ByReference
    extends ECDSArefPrivateKey
    implements Structure.ByReference {
    }
}

