/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.ed;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class EdDSArefPublicKey
extends Structure
implements IKeyPair {
    public int bits;
    public int curvetype;
    public byte[] A = new byte[80];

    public int getBits() {
        return this.bits;
    }

    public int getCurvetype() {
        return this.curvetype;
    }

    public void setCurvetype(int curvetype) {
        this.curvetype = curvetype;
    }

    public byte[] getA() {
        return this.A;
    }

    public EdDSArefPublicKey() {
    }

    public EdDSArefPublicKey(int bits, int curvetype, byte[] A) {
        this.bits = bits;
        this.curvetype = curvetype;
        if (A.length > 80) {
            System.arraycopy(A, A.length - 80, this.A, 0, this.A.length);
        } else {
            System.arraycopy(A, 0, this.A, this.A.length - A.length, A.length);
        }
    }

    @Override
    public int size() {
        return 88;
    }

    public static int sizeof() {
        return 88;
    }

    @Override
    public void decode(byte[] publicKey) throws CryptoException {
        this.bits = BytesUtil.bytes2int(publicKey);
        int pos = 4;
        byte[] tmpBuffer = new byte[4];
        System.arraycopy(publicKey, pos, tmpBuffer, 0, tmpBuffer.length);
        this.curvetype = BytesUtil.bytes2int(tmpBuffer);
        System.arraycopy(publicKey, pos += tmpBuffer.length, this.A, 0, 80);
        if ((pos += this.A.length) != publicKey.length) {
            throw new CryptoException("inputData length != EdDSArefPublicKey length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(BytesUtil.int2bytes(this.curvetype));
            buf.write(this.A);
        }
        catch (IOException e) {
            throw new CryptoException("EdDSArefPublicKey encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public String toString() {
        return "EdDSArefPublicKey{bits=" + this.bits + ", curvetype=" + Integer.toHexString(this.curvetype) + ", X=" + BytesUtil.bytes2hex(this.A) + '}';
    }

    protected List getFieldOrder() {
        return Arrays.asList("bits", "curvetype", "A");
    }

    public static class ByValue
    extends EdDSArefPublicKey
    implements Structure.ByValue {
    }

    public static class ByReference
    extends EdDSArefPublicKey
    implements Structure.ByReference {
    }
}

