/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.log;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CryptoLogger {
    public static final Logger logger = Logger.getLogger("SWSDSCrypto");

    public static Level toLevel(int n) {
        Level level = null;
        switch (n) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.CONFIG;
                break;
            }
            case 5: {
                level = Level.FINE;
                break;
            }
            case 6: {
                level = Level.ALL;
                break;
            }
            default: {
                level = Level.ALL;
            }
        }
        return level;
    }

    public static boolean isFullPath(String filePath) {
        if (filePath.startsWith("/")) {
            return true;
        }
        return filePath.contains(":\\") && filePath.substring(1).startsWith(":\\");
    }

    public static String getEnvPath(String oldPath, String filePath) {
        String newPath = null;
        String[] paths = null;
        paths = oldPath.split("}");
        String envPath = System.getenv(paths[0].substring(2));
        newPath = envPath == null ? CryptoLogger.getParentPath(filePath) + paths[1] : envPath + paths[1];
        return newPath;
    }

    public static String getParentPath(String filePath) {
        File f = new File(filePath);
        return f.getParent();
    }

    static {
        logger.setLevel(Level.SEVERE);
    }
}

