/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.cryptoDevice;

import com.sheca.cryptoDevice.shecaCryptoDevice;
import com.sheca.safeengine.javasafeengine;
import com.sheca.safeengine.shcaSM2PublicKey;
import com.sheca.safeengine.shecaCsrUtils;
import com.sheca.safeengine.shecaEnvelopeStructure;
import com.sheca.safeengine.shecaOcspBuilder;
import com.sheca.safeengine.shecaTimeStampBuilder;
import com.sheca.safeengine.shecaUtils;
import com.sheca.safeengine.shecaX509v2CRLBuilder;
import com.sheca.safeengine.shecaX509v3CertBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.Store;
import org.json.JSONObject;

public class shecaDatechStd
extends javasafeengine
implements shecaCryptoDevice {
    private static Logger a = null;
    private static shecaDatechStd b = null;
    private static JcaSignerInfoGeneratorBuilder c = null;
    private static ContentSigner d = null;

    public shecaDatechStd() {
        if (a == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                a = Logger.getLogger(shecaDatechStd.class);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = null;
                classNotFoundException.printStackTrace();
            }
        }
    }

    public static shecaDatechStd getInstance() {
        if (b == null) {
            b = new shecaDatechStd();
        }
        return b;
    }

    public int calcDeviceSM2signIndexFromGmSM2Index(int n) {
        n = n > 0 ? 2 * n + 2 : 0;
        return n;
    }

    public int calcDeviceSM2encryptIndexFromGmSM2Index(int n) {
        n = n > 0 ? 2 * n + 1 : 0;
        return n;
    }

    public int calcRSAsignIndexFromCryptoDevice(int n) {
        return n;
    }

    public int calcRSAencryptIndexFromCryptoDevice(int n) {
        return n;
    }

    public int calcSM2signIndexFromCryptoDevice(int n) {
        return this.calcDeviceSM2signIndexFromGmSM2Index(n);
    }

    public int calcSM2encryptIndexFromCryptoDevice(int n) {
        return this.calcDeviceSM2encryptIndexFromGmSM2Index(n);
    }

    public int calcECCsignIndexFromCryptoDevice(int n) {
        return 0;
    }

    public int calcECCencryptIndexFromCryptoDevice(int n) {
        return 0;
    }

    public KeyPair genRSAKeyPairFromCryptoDevice(int n, int n2) {
        KeyPair keyPair = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("RsaKey".concat(String.valueOf(n)), "DatechCrypto");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "DatechCrypto");
            keyPairGenerator.initialize(n2, secureRandom);
            keyPair = keyPairGenerator.genKeyPair();
        }
        catch (Exception exception) {
            shecaLastErrorCode = -1;
            exception.printStackTrace();
        }
        return keyPair;
    }

    public KeyPair genSM2KeyPairFromCryptoDevice(int n) {
        KeyPair keyPair = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("EccKey".concat(String.valueOf(n)), "DatechCrypto");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("Ecc", "DatechCrypto");
            keyPairGenerator.initialize(7, secureRandom);
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return keyPair;
    }

    public void genSM2InfoSignerWithDeviceKeyPair(KeyPair keyPair) {
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("DatechCrypto").build());
            keyPair = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(keyPair.getPrivate());
            c = jcaSignerInfoGeneratorBuilder;
            d = keyPair;
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public byte[] genRandomBytesByDevice(int n, int n2) {
        byte[] byArray = null;
        int n3 = 0;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("DevRandom", "DatechCrypto");
            if (n2 > 1024) {
                byArray = new byte[n2];
                while (n3 < n2) {
                    byte[] byArray2 = secureRandom.generateSeed(1024);
                    System.arraycopy(byArray2, 0, byArray, n3, 1024);
                    n3 += 1024;
                }
            } else {
                byArray = secureRandom.generateSeed(n2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] doSymEncryptByDevice(byte[] byArray, int n, byte[] object) {
        byte[] byArray2 = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("DevRandom", "DatechCrypto");
            if (257 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SM1");
                Cipher cipher = Cipher.getInstance("SM1/ECB/PKCS5Padding", "DatechCrypto");
                object = cipher;
                cipher.init(1, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else if (513 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SSF33");
                Cipher cipher = Cipher.getInstance("SSF33/ECB/PKCS5Padding", "DatechCrypto");
                object = cipher;
                cipher.init(1, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else {
                byArray2 = this.doSymEncrypt(n, byArray, (byte[])object, 0);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSymDecryptByDevice(byte[] byArray, int n, byte[] object) {
        byte[] byArray2 = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("DevRandom", "DatechCrypto");
            if (257 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SM1");
                Cipher cipher = Cipher.getInstance("SM1/ECB/PKCS5Padding", "DatechCrypto");
                object = cipher;
                cipher.init(2, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else if (513 == n) {
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "SSF33");
                Cipher cipher = Cipher.getInstance("SSF33/ECB/PKCS5Padding", "DatechCrypto");
                object = cipher;
                cipher.init(2, (Key)secretKeySpec, secureRandom);
                byArray2 = ((Cipher)object).doFinal(byArray);
            } else {
                byArray2 = this.doSymDecrypt(n, byArray, (byte[])object, 0);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSADecryptWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "DatechCrypto");
            cipher.init(2, keyPair.getPrivate());
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2DecryptWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("ECC/ECB/PKCS1Padding", "DatechCrypto");
            cipher.init(2, keyPair.getPrivate());
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] encodePKCS7EnveloperByDevice(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = javasafeengine.genPKCS7enveloperWithCert(byArray, byArray2, n);
        if (byArray3 == null) {
            if (1025 == n) {
                byArray3 = this.encodeEnveloper(byArray2, 1025, byArray);
            } else if (257 == n) {
                shecaUtils.logger_info(a, "SM1 not support.");
            } else {
                shecaUtils.logger_info(a, "symAlgID : " + n + " not support.");
            }
        }
        return byArray3;
    }

    public byte[] decodePKCS7EnveloperWithDeviceKeyPair(KeyPair object, byte[] object2) {
        byte[] byArray = null;
        try {
            shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloper((byte[])object2);
            object2 = shecaEnvelopeStructure2;
            if (shecaEnvelopeStructure2.retCode == 0 && object2.asymAlgoID == 131328) {
                object = this.doSM2DecryptWithDeviceKeyPair((KeyPair)object, object2.symkeyCipher);
                if (object2.symAlgoID != 257) {
                    byArray = this.doSymDecrypt(object2.symAlgoID, object2.cipherText, (byte[])object, 0);
                }
            }
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] doRSASignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n) {
        byte[] byArray2 = null;
        String string = "";
        if (n == 65538) {
            string = "SHA1/RSA";
        } else if (n == 65540) {
            string = "SHA-256/RSA/PKCS#1";
        } else if (n == 65541) {
            string = "SHA-384/RSA/PKCS#1";
        } else if (n == 65542) {
            string = "SHA-512/RSA/PKCS#1";
        }
        Object object = string;
        try {
            object = Signature.getInstance((String)object, "DatechCrypto");
            ((Signature)object).initSign(keyPair.getPrivate());
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2SignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Signature signature = Signature.getInstance("SM3/ECC", "DatechCrypto");
            signature.initSign(keyPair.getPrivate());
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doRSASignWithDeviceKeyPairByStream(KeyPair keyPair, InputStream inputStream, int n) {
        return null;
    }

    public byte[] doSM2SignWithDeviceKeyPairByStream(KeyPair keyPair, InputStream inputStream) {
        return null;
    }

    public byte[] doRSAPKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, int n, boolean bl) {
        byte[] byArray2 = null;
        try {
            String string = javasafeengine.getAlgNameWithAlgID(n);
            serializable = new JcaContentSignerBuilder(string).setProvider("DatechCrypto").build(serializable.getPrivate());
            string = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            string.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("DatechCrypto").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            string.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = string.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doSM2PKCS7signWithDeviceKeyPair(KeyPair serializable, byte[] object, byte[] byArray, boolean bl) {
        byte[] byArray2 = null;
        try {
            serializable = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(((KeyPair)serializable).getPrivate());
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            object = new X509CertificateHolder(object);
            cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("DatechCrypto").build()).build((ContentSigner)serializable, (X509CertificateHolder)object));
            serializable = new ArrayList<byte[]>();
            serializable.add(object);
            serializable = new JcaCertStore((Collection)((Object)serializable));
            cMSSignedDataGenerator.addCertificates((Store)serializable);
            serializable = new CMSProcessableByteArray(byArray);
            serializable = cMSSignedDataGenerator.generate((CMSTypedData)serializable, bl);
            serializable = new DEROctetString((ASN1Encodable)serializable.toASN1Structure().toASN1Primitive());
            byArray2 = serializable.getOctets();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] doECCPKCS7signWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, byte[] byArray2, int n, boolean bl) {
        return null;
    }

    public byte[] generateRSACertWithDeviceKeyPair(KeyPair object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            shecaUtils.logger_debug(a, "genRSACertWithDeviceKeyPair start...");
            object2 = object2 != null ? (Object)shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, ((KeyPair)object).getPublic(), shecaDatechStd.getRSAPublicKey((byte[])object2)) : (Object)shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, null, ((KeyPair)object).getPublic());
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            object = new JcaContentSignerBuilder(string2).setProvider("DatechCrypto").build(((KeyPair)object).getPrivate());
            object = object2.build((ContentSigner)object);
            object2 = CertificateFactory.getInstance("X.509");
            object = new ByteArrayInputStream(object.toASN1Structure().getEncoded());
            object2 = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object);
            ((InputStream)object).close();
            byArray = ((Certificate)object2).getEncoded();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CertWithDeviceKeyPair(KeyPair keyPair, byte[] object, String string) {
        byte[] byArray = null;
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(keyPair.getPrivate());
            if (object != null) {
                object = shecaUtils.toAsn1EncodeWithSM2Pubkey(object);
                shcaSM2PublicKey shcaSM2PublicKey2 = new shcaSM2PublicKey((byte[])object);
                object = shcaSM2PublicKey2;
                object = shcaSM2PublicKey2;
                keyPair = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, keyPair.getPublic(), (PublicKey)object);
            } else {
                object = keyPair.getPublic();
                keyPair = shecaX509v3CertBuilder.genX509v3CertificateBuilder(string, null, (PublicKey)object);
            }
            X509CertificateHolder x509CertificateHolder = keyPair.build(contentSigner);
            object = x509CertificateHolder;
            byArray = x509CertificateHolder.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, int n, String string) {
        object = (X509Certificate)shecaDatechStd.getCertificateFromBuffer(object);
        return this.generateRSACrlWithDeviceKeyPair(keyPair, (X509Certificate)object, n, string);
    }

    public byte[] generateRSACrlWithDeviceKeyPair(KeyPair keyPair, X509Certificate serializable, int n, String string) {
        byte[] byArray = null;
        try {
            serializable = shecaX509v2CRLBuilder.genX509v2CRLBuilder(serializable, string);
            String string2 = javasafeengine.getAlgNameWithAlgID(n);
            keyPair = new JcaContentSignerBuilder(string2).setProvider("DatechCrypto").build(keyPair.getPrivate());
            keyPair = serializable.build((ContentSigner)keyPair);
            byArray = keyPair.toASN1Structure().getEncoded();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPair(KeyPair keyPair, byte[] object, String string) {
        object = (X509Certificate)shecaDatechStd.getCertificateFromBuffer(object);
        return this.generateSM2CrlWithDeviceKeyPair(keyPair, (X509Certificate)object, string);
    }

    public byte[] generateRSACsrWithDeviceKeyPair(KeyPair object, int n, String object2) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            object2 = new X500Principal((String)object2);
            object2 = shecaCsrUtils2.makeCertReqInfo((X500Principal)object2, ((KeyPair)object).getPublic());
            byte[] byArray2 = object2.getEncoded();
            byte[] byArray3 = this.doRSASignWithDeviceKeyPair((KeyPair)object, byArray2, n);
            object = byArray3;
            if (byArray3 != null) {
                object = new DERBitString((byte[])object);
                AlgorithmIdentifier algorithmIdentifier = shecaCsrUtils2.makeCertReqAlgo(n);
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)object2, algorithmIdentifier, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CsrWithDeviceKeyPair(KeyPair object, String string) {
        byte[] byArray = null;
        try {
            shecaCsrUtils shecaCsrUtils2 = new shecaCsrUtils();
            Object object2 = ((KeyPair)object).getPublic().getEncoded();
            string = shecaCsrUtils2.makeSM2CertReqInfo(string, (byte[])object2);
            object2 = string.getEncoded();
            byte[] byArray2 = this.doSM2SignWithDeviceKeyPair((KeyPair)object, (byte[])object2);
            object = byArray2;
            if (byArray2 != null) {
                object = shecaCsrUtils2.makeSM2CertReqSign((byte[])object);
                object2 = shecaCsrUtils2.makeSM2CertReqAlgo();
                object = shecaCsrUtils2.makeCertReq((CertificationRequestInfo)string, (AlgorithmIdentifier)object2, (DERBitString)object);
                byArray = object.getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPair(KeyPair keyPair, X509Certificate x509Certificate, String string) {
        return null;
    }

    public byte[] generateECCCrlWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n, String string) {
        return null;
    }

    public byte[] generateRSAocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                object2 = javasafeengine.getAlgNameWithAlgID(n);
                keyPair = new JcaContentSignerBuilder((String)object2).setProvider("DatechCrypto").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2ocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, byArray);
                keyPair = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray2 = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateECCocspWithDeviceKeyPair(KeyPair keyPair, byte[] object, byte[] object2, int n, String string) {
        byte[] byArray = null;
        try {
            OCSPRespBuilder oCSPRespBuilder = new OCSPRespBuilder();
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("response")) {
                object = shecaOcspBuilder.genBasicOCSPRespBuilder(string, object, object2);
                object2 = javasafeengine.getAlgNameWithAlgID(n);
                keyPair = new JcaContentSignerBuilder((String)object2).setProvider("DatechCrypto").build(keyPair.getPrivate());
                keyPair = object.build((ContentSigner)keyPair, shecaOcspBuilder.genX509CertificateHolderListFromJSON(string), new Date());
                keyPair = oCSPRespBuilder.build(0, (Object)keyPair);
            } else {
                keyPair = oCSPRespBuilder.build(jSONObject.getInt("responseStatus"), null);
            }
            byArray = keyPair.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateRSACrlWithDeviceKeyPairByPreviousCrlPath(KeyPair serializable, byte[] byArray, int n, String string, String string2) {
        byte[] byArray2 = null;
        try {
            String string3 = javasafeengine.getAlgNameWithAlgID(n);
            string3 = new JcaContentSignerBuilder(string3).setProvider("DatechCrypto").build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(byArray);
            serializable = shecaX509v2CRLBuilder.genX509v2CRLBuilderByFullSizeCrl(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                serializable = serializable.build((ContentSigner)string3);
                byArray2 = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateRSACrlWithDeviceKeyPairByHistoryCrlFolder(KeyPair serializable, byte[] object, int n, String string, String string2) {
        byte[] byArray = null;
        try {
            String string3 = javasafeengine.getAlgNameWithAlgID(n);
            string3 = new JcaContentSignerBuilder(string3).setProvider("DatechCrypto").build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
            shecaX509v2CRLBuilder shecaX509v2CRLBuilder2 = new shecaX509v2CRLBuilder();
            object = shecaX509v2CRLBuilder2;
            serializable = shecaX509v2CRLBuilder2.genX509v2CRLBuilderByCrlList(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                serializable = serializable.build((ContentSigner)string3);
                byArray = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generateSM2CrlWithDeviceKeyPairByPreviousCrlPath(KeyPair serializable, byte[] byArray, String string, String string2) {
        byte[] byArray2 = null;
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(byArray);
            serializable = shecaX509v2CRLBuilder.genX509v2CRLBuilderByFullSizeCrl(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                serializable = serializable.build(contentSigner);
                byArray2 = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] generateSM2CrlWithDeviceKeyPairByHistoryCrlFolder(KeyPair serializable, byte[] object, String string, String string2) {
        byte[] byArray = null;
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(serializable.getPrivate());
            serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer((byte[])object);
            object = new shecaX509v2CRLBuilder();
            shecaUtils.logger_info(a, "genX509v2CRLBuilderByCrlList start in datech device.");
            serializable = ((shecaX509v2CRLBuilder)object).genX509v2CRLBuilderByCrlList(string2, (X509Certificate)serializable, string);
            if (serializable != null) {
                shecaUtils.logger_info(a, "build crl by datech device.");
                serializable = serializable.build(contentSigner);
                byArray = serializable.toASN1Structure().getEncoded();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] decodeRSAEnveloperBySHECAStandard(KeyPair object, byte[] object2, int n) {
        byte[] byArray = null;
        shecaEnvelopeStructure shecaEnvelopeStructure2 = this.parseEnveloperBySHECAStandard((KeyPair)object, (byte[])object2, n);
        object2 = shecaEnvelopeStructure2;
        if (shecaEnvelopeStructure2.retCode == 0) {
            byte[] byArray2 = this.doRSADecryptWithDeviceKeyPair((KeyPair)object, object2.symkeyCipher);
            object = byArray2;
            if (byArray2 != null) {
                byArray = this.doSymDecryptByDevice(object2.cipherText, object2.symAlgoID, (byte[])object);
            }
        }
        return byArray;
    }

    public byte[] rebuildSM2CrlWithDeviceKeyPair(KeyPair object, byte[] object2) {
        byte[] byArray = null;
        try {
            X509CRL x509CRL = shecaX509v2CRLBuilder.getX509CRLFromBuffer((byte[])object2);
            object2 = x509CRL;
            if (x509CRL != null) {
                byte[] byArray2 = this.doSM2SignWithDeviceKeyPair((KeyPair)object, ((X509CRL)object2).getTBSCertList());
                object = byArray2;
                if (byArray2 != null) {
                    byArray = shecaX509v2CRLBuilder.rebuildX509CRLWithSignData((byte[])object, (X509CRL)object2);
                }
            }
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] rebuildRsaCrlWithDeviceKeyPair(KeyPair object, byte[] object2, int n) {
        byte[] byArray = null;
        try {
            X509CRL x509CRL = shecaX509v2CRLBuilder.getX509CRLFromBuffer((byte[])object2);
            object2 = x509CRL;
            if (x509CRL != null) {
                byte[] byArray2 = this.doRSASignWithDeviceKeyPair((KeyPair)object, ((X509CRL)object2).getTBSCertList(), n);
                object = byArray2;
                if (byArray2 != null) {
                    byArray = shecaX509v2CRLBuilder.rebuildX509CRLWithSignData((byte[])object, (X509CRL)object2);
                }
            }
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] genrateRSAtimeStampResWithDeviceKeyPair(KeyPair object, byte[] byArray, byte[] byArray2, Date date, int n, String string) {
        String string2 = javasafeengine.getAlgNameWithAlgID(n);
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("DatechCrypto").build());
            object = new JcaContentSignerBuilder(string2).setProvider("DatechCrypto").build(((KeyPair)object).getPrivate());
            object = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(jcaSignerInfoGeneratorBuilder, (ContentSigner)object, byArray2, string);
            object = shecaTimeStampBuilder.buildShecaRsaTsResp((TimeStampTokenGenerator)object, byArray, string, date);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            object = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return object;
    }

    public byte[] genrateSM2timeStampResWithDeviceKeyPair(byte[] byArray, byte[] object, Date date, String string) {
        try {
            if (c != null && d != null) {
                TimeStampTokenGenerator timeStampTokenGenerator = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(c, d, object, string);
                object = timeStampTokenGenerator;
                byArray = shecaTimeStampBuilder.buildShecaRsaTsResp(timeStampTokenGenerator, byArray, string, date);
            } else {
                byArray = javasafeengine.b64tohex("MAwwCgIBAgMFBgAAAEA=");
            }
        }
        catch (Exception exception) {
            object = exception;
            byArray = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return byArray;
    }

    public byte[] genrateSM2timeStampResWithDeviceKeyPair(KeyPair object, byte[] byArray, byte[] byArray2, Date date, String string) {
        try {
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("DatechCrypto").build());
            object = new JcaContentSignerBuilder("SM3withSM2").setProvider("DatechCrypto").build(((KeyPair)object).getPrivate());
            object = shecaTimeStampBuilder.getShecaRsaTsTokenGenerator(jcaSignerInfoGeneratorBuilder, (ContentSigner)object, byArray2, string);
            object = shecaTimeStampBuilder.buildShecaRsaTsResp((TimeStampTokenGenerator)object, byArray, string, date);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            object = shecaTimeStampBuilder.genShecaRejectedTimeStamp(exception);
        }
        return object;
    }

    public KeyPair genECCKeyPairFromCryptoDevice(int n, int n2) {
        return null;
    }

    public byte[] doECCSignWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n) {
        return null;
    }

    public byte[] generateECCCsrWithDeviceKeyPair(KeyPair keyPair, int n, String string) {
        return null;
    }

    public byte[] generateECCCertWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, int n, String string) {
        return null;
    }

    public byte[] genrateECCtimeStampResWithDeviceKeyPair(KeyPair keyPair, byte[] byArray, byte[] byArray2, Date date, int n, String string) {
        return null;
    }
}

