/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Memoable;

public class SM3Digest
extends GeneralDigest {
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int[] i = new int[64];
    private int j;
    private int[] k = new int[68];
    private int[] l = new int[64];

    public SM3Digest() {
        this.reset();
    }

    public SM3Digest(SM3Digest sM3Digest) {
        super((GeneralDigest)sM3Digest);
        this.a = sM3Digest.a;
        this.b = sM3Digest.b;
        this.c = sM3Digest.c;
        this.d = sM3Digest.d;
        this.e = sM3Digest.e;
        this.f = sM3Digest.f;
        this.g = sM3Digest.g;
        this.h = sM3Digest.h;
        System.arraycopy(sM3Digest.i, 0, this.i, 0, sM3Digest.i.length);
        this.j = sM3Digest.j;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    protected void processWord(byte[] byArray, int n) {
        int n2 = byArray[n] << 24;
        n2 |= (byArray[++n] & 0xFF) << 16;
        n2 |= (byArray[++n] & 0xFF) << 8;
        this.i[this.j] = n2 |= byArray[++n] & 0xFF;
        if (++this.j == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l) {
        if (this.j > 14) {
            this.processBlock();
        }
        this.i[14] = (int)(l >>> 32);
        this.i[15] = (int)l;
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.intToBigEndian((int)this.a, (byte[])byArray, (int)n);
        Pack.intToBigEndian((int)this.b, (byte[])byArray, (int)(n + 4));
        Pack.intToBigEndian((int)this.c, (byte[])byArray, (int)(n + 8));
        Pack.intToBigEndian((int)this.d, (byte[])byArray, (int)(n + 12));
        Pack.intToBigEndian((int)this.e, (byte[])byArray, (int)(n + 16));
        Pack.intToBigEndian((int)this.f, (byte[])byArray, (int)(n + 20));
        Pack.intToBigEndian((int)this.g, (byte[])byArray, (int)(n + 24));
        Pack.intToBigEndian((int)this.h, (byte[])byArray, (int)(n + 28));
        this.reset();
        return 32;
    }

    public void reset() {
        super.reset();
        this.a = 1937774191;
        this.b = 1226093241;
        this.c = 388252375;
        this.d = -628488704;
        this.e = -1452330820;
        this.f = 372324522;
        this.g = -477237683;
        this.h = -1325724082;
        this.j = 0;
        int n = 0;
        while (n != this.i.length) {
            this.i[n] = 0;
            ++n;
        }
    }

    protected void processBlock() {
        int n;
        int n2 = 0;
        while (n2 < 16) {
            this.k[n2] = this.i[n2];
            ++n2;
        }
        n2 = 16;
        while (n2 <= 67) {
            n = this.k[n2 - 16] ^ this.k[n2 - 9] ^ SM3Digest.a(this.k[n2 - 3], 15);
            this.k[n2] = n ^ (n << 15 | n >>> 17) ^ (n << 23 | n >>> 9) ^ SM3Digest.a(this.k[n2 - 13], 7) ^ this.k[n2 - 6];
            ++n2;
        }
        n2 = 0;
        while (n2 <= 63) {
            this.l[n2] = this.k[n2] ^ this.k[n2 + 4];
            ++n2;
        }
        int n3 = this.a;
        int n4 = this.b;
        int n5 = this.c;
        int n6 = this.d;
        int n7 = this.e;
        int n8 = this.f;
        int n9 = this.g;
        int n10 = this.h;
        int n11 = 2043430169;
        n2 = 0;
        while (n2 < 64) {
            if (n2 >= 16) {
                n11 = 2055708042;
            }
            int n12 = SM3Digest.a(n3, 12) + n7 + SM3Digest.a(n11, n2);
            n12 = SM3Digest.a(n12, 7);
            int n13 = n12 ^ SM3Digest.a(n3, 12);
            int n14 = n2;
            int n15 = n5;
            int n16 = n4;
            n = n3;
            n13 = (n14 <= 15 ? n ^ n16 ^ n15 : n & n16 | n & n15 | n16 & n15) + n6 + n13 + this.l[n2];
            n14 = n2;
            n15 = n9;
            n16 = n8;
            n = n7;
            n12 = (n14 <= 15 ? n ^ n16 ^ n15 : n & n16 | ~n & n15) + n10 + n12 + this.k[n2];
            n6 = n5;
            n5 = SM3Digest.a(n4, 9);
            n4 = n3;
            n3 = n13;
            n10 = n9;
            n9 = SM3Digest.a(n8, 19);
            n8 = n7;
            n = n12;
            n7 = n ^ (n << 9 | n >>> 23) ^ (n << 17 | n >>> 15);
            ++n2;
        }
        this.a ^= n3;
        this.b ^= n4;
        this.c ^= n5;
        this.d ^= n6;
        this.e ^= n7;
        this.f ^= n8;
        this.g ^= n9;
        this.h ^= n10;
        this.j = 0;
        n2 = 0;
        while (n2 < 16) {
            this.i[n2] = 0;
            ++n2;
        }
    }

    private static int a(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public static void main(String[] objectArray) {
        objectArray = new byte[64];
        int n = 0;
        while (n < 64) {
            objectArray[n] = (String)((byte)(97 + n % 4));
            ++n;
        }
        SM3Digest sM3Digest = new SM3Digest();
        sM3Digest.update((byte[])objectArray, 0, 64);
        objectArray = new byte[32];
        sM3Digest.doFinal((byte[])objectArray, 0);
        int n2 = 0;
        while (n2 < 32) {
            System.out.printf("%02X ", (byte)objectArray[n2]);
            if (n2 == 15) {
                System.out.println();
            }
            ++n2;
        }
    }

    public Memoable copy() {
        return null;
    }

    public void reset(Memoable memoable) {
    }
}

