/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.SM2;
import com.sheca.safeengine.SM3Digest;
import com.sheca.safeengine.SM4;
import com.sheca.safeengine.Sdbi;
import com.sheca.safeengine.g;
import com.sheca.safeengine.h;
import com.sheca.safeengine.i;
import com.sheca.safeengine.shcaOcsp;
import com.sheca.safeengine.shecaEnvelopeStructure;
import com.sheca.safeengine.shecaUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;

public class javasafeengine {
    protected static int shecaLastErrorCode = 0;
    private static Logger a = null;
    private static javasafeengine b = null;
    public static final String K_SHECA_PRIKEY_NAME = "prikey";
    public static final String K_SHECA_PUBKEY_NAME = "pubkey";
    public static final String K_SHECA_SHA1_RSASIGN = "SHA1withRSA";
    public static final String K_SHECA_SHA256_RSASIGN = "SHA256withRSA";
    public static final String K_SHECA_SHA384_RSASIGN = "SHA384withRSA";
    public static final String K_SHECA_SHA512_RSASIGN = "SHA512withRSA";
    public static final String K_SHECA_SM3WITHSM2 = "SM3withSM2";
    private static SM2 c = null;
    private static SM3Digest d = null;
    private static X9ECParameters e = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECDomainParameters f = new ECDomainParameters(e.getCurve(), e.getG(), e.getN());
    private static ECParameterSpec g = new ECParameterSpec(e.getCurve(), e.getG(), e.getN());

    static {
        if (a == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                a = Logger.getLogger(javasafeengine.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = null;
                classNotFoundException.printStackTrace();
            }
        }
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public javasafeengine() {
        c = new SM2();
        d = new SM3Digest();
        shecaLastErrorCode = 0;
    }

    public static int getLastErrorCode() {
        return shecaLastErrorCode;
    }

    public static javasafeengine getInstance() {
        if (b == null) {
            b = new javasafeengine();
        }
        return b;
    }

    public String base64Encode(byte[] byArray) {
        String string = null;
        if ((byArray = Base64.encode((byte[])byArray)) != null) {
            string = new String(byArray);
        } else {
            shecaUtils.logger_error(a, "base64Encode is null");
        }
        return string;
    }

    public static String getAlgNameWithAlgID(int n) {
        String string = "SHA1WithRSA";
        if (n == 65540) {
            string = "SHA256WithRSA";
        } else if (n == 65541) {
            string = "SHA384WithRSA";
        } else if (n == 65542) {
            string = "SHA512WithRSA";
        } else if (n == 524290) {
            string = "SHA224WITHECDSA";
        } else if (n == 524292) {
            string = "SHA256WITHECDSA";
        } else if (n == 524293) {
            string = "SHA384WITHECDSA";
        } else if (n == 524294) {
            string = "SHA512WITHECDSA";
        }
        return string;
    }

    public static String getAlgNameWithOID(String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("1.2.840.113549.1.1.5") || string.equalsIgnoreCase("1.2.840.113549.1.1.1")) {
            string2 = "SHA1WithRSA";
        } else if (string.equalsIgnoreCase("1.2.840.113549.1.1.11")) {
            string2 = "SHA256WithRSA";
        } else if (string.equalsIgnoreCase("1.2.840.113549.1.1.12")) {
            string2 = "SHA384WithRSA";
        } else if (string.equalsIgnoreCase("1.2.840.113549.1.1.13")) {
            string2 = "SHA512WithRSA";
        } else if (string.equalsIgnoreCase("1.2.156.10197.1.501")) {
            string2 = "SM3WithSM2";
        } else if (string.equalsIgnoreCase("1.2.840.10045.4.3.1")) {
            string2 = "SHA224WithECDSA";
        } else if (string.equalsIgnoreCase("1.2.840.10045.4.3.2")) {
            string2 = "SHA256WithECDSA";
        } else if (string.equalsIgnoreCase("1.2.840.10045.4.3.3")) {
            string2 = "SHA384WithECDSA";
        } else if (string.equalsIgnoreCase("1.2.840.10045.4.3.4")) {
            string2 = "SHA512WithECDSA";
        }
        return string2;
    }

    public static String getAlgNameWithShcaAlgID(int n) {
        String string = "SHA1WithRSA";
        if (n == 4) {
            string = "SHA256WithRSA";
        } else if (n == 5) {
            string = "SHA384WithRSA";
        } else if (n == 6) {
            string = "SHA512WithRSA";
        }
        return string;
    }

    public byte[] base64Decode(String string) {
        return Base64.decode((byte[])string.getBytes());
    }

    public static String hex2b64(byte[] byArray) {
        String string = null;
        if ((byArray = Base64.encode((byte[])byArray)) != null) {
            string = new String(byArray);
        } else {
            shecaUtils.logger_error(a, "base64Encode is null");
        }
        return string;
    }

    public static byte[] b64tohex(String string) {
        return Base64.decode((byte[])string.getBytes());
    }

    public byte[] digest(byte[] byArray, String object, String object2) {
        object2 = null;
        try {
            if (((String)object).equalsIgnoreCase("SM3")) {
                object = new SM3Digest();
                object.update(byArray, 0, byArray.length);
                byArray = new byte[32];
                ((SM3Digest)((Object)object)).doFinal(byArray, 0);
                object2 = byArray;
            } else {
                object = MessageDigest.getInstance((String)object, "BC");
                object2 = ((MessageDigest)object).digest(byArray);
            }
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
        }
        return object2;
    }

    public static byte[] digestMessage(byte[] byArray, String object) {
        byte[] byArray2 = null;
        try {
            if (((String)object).equalsIgnoreCase("SM3")) {
                object = new SM3Digest();
                object.update(byArray, 0, byArray.length);
                byArray = new byte[32];
                ((SM3Digest)((Object)object)).doFinal(byArray, 0);
                byArray2 = byArray;
            } else {
                object = MessageDigest.getInstance((String)object, "BC");
                byArray2 = ((MessageDigest)object).digest(byArray);
            }
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
        }
        return byArray2;
    }

    public static byte[] digestWithAlgNameByStream(String object, InputStream inputStream) {
        byte[] byArray = null;
        try {
            int n;
            object = MessageDigest.getInstance((String)object, "BC");
            byte[] byArray2 = new byte[0x100000];
            while ((n = inputStream.read(byArray2)) != -1) {
                ((MessageDigest)object).update(byArray2, 0, n);
            }
            byArray = ((MessageDigest)object).digest();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] digestWithAlgNameByFile(String object, String string) {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byArray = javasafeengine.digestWithAlgNameByStream((String)object, fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return byArray;
    }

    public byte[] digest(byte[] byArray, String string) {
        return this.digest(byArray, string, "BC");
    }

    private static ECPoint a(byte[] object) {
        if (((byte[])object).length == 64) {
            object = c.subByte((byte[])object, 0, 64);
        } else if (((byte[])object).length > 64) {
            object = c.subByte((byte[])object, 1, 64);
        } else {
            return null;
        }
        Object object2 = c.subByte((byte[])object, 0, 32);
        object = c.subByte((byte[])object, 32, 32);
        object2 = new BigInteger(1, (byte[])object2);
        object = new BigInteger(1, (byte[])object);
        object2 = new ECFieldElement.Fp(SM2.a, (BigInteger)object2);
        object = new ECFieldElement.Fp(SM2.a, (BigInteger)object);
        ECPoint.Fp fp = new ECPoint.Fp(SM2.b, (ECFieldElement)object2, (ECFieldElement)object, false);
        object = fp;
        return fp;
    }

    public static PublicKey genSM2PublicKey(byte[] object) {
        BCECPublicKey bCECPublicKey = null;
        try {
            object = javasafeengine.a(object);
            object = new ECPublicKeyParameters((ECPoint)object, SM2.c);
            BCECPublicKey bCECPublicKey2 = new BCECPublicKey("SM2", (ECPublicKeyParameters)object, BouncyCastleProvider.CONFIGURATION);
            object = bCECPublicKey2;
            bCECPublicKey = bCECPublicKey2;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return bCECPublicKey;
    }

    public byte[] random(int n, String object, String object2) {
        object = null;
        try {
            object2 = new SecureRandom();
            object = ((SecureRandom)object2).generateSeed(n);
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
        }
        return object;
    }

    public byte[] random(int n) {
        return this.random(n, "", "BC");
    }

    protected KeyPair generateRSAKeyPair(int n) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(n, new SecureRandom());
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.getStackTrace().toString());
        }
        return keyPair;
    }

    protected KeyPair generateSM2KeyPair() {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)g, new SecureRandom());
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, exception2.toString());
        }
        return keyPair;
    }

    protected KeyPair generateECCKeyPair(int n) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize(n);
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, exception2.toString());
        }
        return keyPair;
    }

    public static byte[] getSM2PrivateKeyBuffer(KeyPair serializable) {
        byte[] byArray = null;
        try {
            byArray = serializable.getPrivate().getEncoded();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public PrivateKey getSM2PrivateKey(byte[] object) {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec((byte[])object));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return privateKey;
    }

    public static BCECPublicKey genSM2PublicKeyWithGM(byte[] object) {
        BCECPublicKey bCECPublicKey = null;
        try {
            object = javasafeengine.a(object);
            object = new ECPublicKeySpec((ECPoint)object, SM2.ecParameterSpec);
            bCECPublicKey = new BCECPublicKey("EC", (ECPublicKeySpec)object, BouncyCastleProvider.CONFIGURATION);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return bCECPublicKey;
    }

    public static BCECPrivateKey genSM2PrivateKeyWithGM(byte[] object, byte[] object2) {
        BCECPrivateKey bCECPrivateKey = null;
        try {
            object = new BigInteger((byte[])object);
            object2 = javasafeengine.genSM2PublicKeyWithGM(object2);
            object = new ECPrivateKeyParameters((BigInteger)object, f);
            bCECPrivateKey = new BCECPrivateKey("EC", (ECPrivateKeyParameters)object, (BCECPublicKey)object2, g, BouncyCastleProvider.CONFIGURATION);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return bCECPrivateKey;
    }

    public static KeyPair genSM2KeyPairWithGM(byte[] object, byte[] byArray) {
        BCECPublicKey bCECPublicKey = javasafeengine.genSM2PublicKeyWithGM(byArray);
        object = javasafeengine.genSM2PrivateKeyWithGM(object, byArray);
        KeyPair keyPair = new KeyPair((PublicKey)bCECPublicKey, (PrivateKey)object);
        object = keyPair;
        return keyPair;
    }

    public static byte[] getSM2PublicKey(PublicKey serializable) {
        byte[] byArray = null;
        try {
            serializable = (BCECPublicKey)serializable;
            byArray = serializable.getQ().getEncoded(false);
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, ((Throwable)serializable).toString());
        }
        return byArray;
    }

    public static byte[] getSM2PublicKeyBuffer(KeyPair serializable) {
        byte[] byArray = null;
        try {
            byArray = serializable.getPublic().getEncoded();
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static PublicKey getSM2PublicKey(byte[] object) {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec((byte[])object));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return publicKey;
    }

    public PrivateKey getRSAPrivateKey(byte[] byArray) {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, exception2.toString());
        }
        return privateKey;
    }

    public static PublicKey getRSAPublicKey(byte[] byArray) {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, exception2.toString());
        }
        return publicKey;
    }

    public static PublicKey getECCPublicKey(byte[] byArray) {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, exception2.toString());
        }
        return publicKey;
    }

    public static java.security.cert.Certificate getCertificateFromBuffer(byte[] byArray) {
        java.security.cert.Certificate certificate;
        block11: {
            certificate = null;
            Object object = null;
            try {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    object = new ByteArrayInputStream(byArray);
                    certificate = certificateFactory.generateCertificate((InputStream)object);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    shecaUtils.logger_error(a, exception2.toString());
                    try {
                        ((ByteArrayInputStream)object).close();
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                        shecaUtils.logger_error(a, ((Throwable)object).toString());
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((ByteArrayInputStream)object).close();
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    shecaUtils.logger_error(a, ((Throwable)object).toString());
                }
                throw throwable;
            }
            try {
                ((ByteArrayInputStream)object).close();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                shecaUtils.logger_error(a, ((Throwable)object).toString());
            }
        }
        return certificate;
    }

    public static Certificate getX509FromBufferWithBC(byte[] object) {
        Certificate certificate = null;
        try {
            object = new ByteArrayInputStream((byte[])object);
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            certificate = Certificate.getInstance((Object)aSN1Primitive);
            ((ByteArrayInputStream)object).close();
            aSN1InputStream.close();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
        }
        return certificate;
    }

    public static X509CertificateStructure getX509FromBuffer(byte[] object) {
        X509CertificateStructure x509CertificateStructure = null;
        try {
            object = new ByteArrayInputStream((byte[])object);
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            x509CertificateStructure = X509CertificateStructure.getInstance((Object)aSN1Primitive);
            ((ByteArrayInputStream)object).close();
            aSN1InputStream.close();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
        }
        return x509CertificateStructure;
    }

    public static String getJSONofDetailFromCert(byte[] object) {
        Object object2 = null;
        Certificate certificate = javasafeengine.getX509FromBufferWithBC(object);
        object = certificate;
        if (certificate != null) {
            RDN[] rDNArray;
            object2 = new JSONObject();
            object2.put("version", (Object)object.getVersion().toString());
            object2.put("SN", (Object)shecaUtils.hex2ascii(object.getSerialNumber().getValue().toByteArray()));
            object2.put("signAlg", (Object)object.getSignatureAlgorithm().getAlgorithm().getId());
            object2.put("startDate", (Object)object.getStartDate().getTime());
            object2.put("endDate", (Object)object.getEndDate().getTime());
            JSONObject jSONObject = new JSONObject();
            X500Name x500Name = object.getSubject();
            if (x500Name != null) {
                rDNArray = x500Name.getRDNs(X509ObjectIdentifiers.commonName);
                if (rDNArray != null && rDNArray.length > 0) {
                    jSONObject.put("CN", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = x500Name.getRDNs(X509ObjectIdentifiers.countryName)) != null && rDNArray.length > 0) {
                    jSONObject.put("C", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = x500Name.getRDNs(X509ObjectIdentifiers.organization)) != null && rDNArray.length > 0) {
                    jSONObject.put("O", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = x500Name.getRDNs(X509ObjectIdentifiers.organizationalUnitName)) != null && rDNArray.length > 0) {
                    jSONObject.put("OU", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = x500Name.getRDNs(X509ObjectIdentifiers.stateOrProvinceName)) != null && rDNArray.length > 0) {
                    jSONObject.put("ST", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = x500Name.getRDNs(X509ObjectIdentifiers.localityName)) != null && rDNArray.length > 0) {
                    jSONObject.put("L", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = x500Name.getRDNs(PKCSObjectIdentifiers.pkcs_9_at_emailAddress)) != null && rDNArray.length > 0) {
                    jSONObject.put("E", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                object2.put("subject", (Object)jSONObject);
            }
            jSONObject = new JSONObject();
            X500Name x500Name2 = object.getIssuer();
            object = x500Name2;
            if (x500Name2 != null) {
                rDNArray = object.getRDNs(X509ObjectIdentifiers.commonName);
                if (rDNArray != null && rDNArray.length > 0) {
                    jSONObject.put("CN", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = object.getRDNs(X509ObjectIdentifiers.countryName)) != null && rDNArray.length > 0) {
                    jSONObject.put("C", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = object.getRDNs(X509ObjectIdentifiers.organization)) != null && rDNArray.length > 0) {
                    jSONObject.put("O", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = object.getRDNs(X509ObjectIdentifiers.organizationalUnitName)) != null && rDNArray.length > 0) {
                    jSONObject.put("OU", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = object.getRDNs(X509ObjectIdentifiers.stateOrProvinceName)) != null && rDNArray.length > 0) {
                    jSONObject.put("ST", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = object.getRDNs(X509ObjectIdentifiers.localityName)) != null && rDNArray.length > 0) {
                    jSONObject.put("L", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                if ((rDNArray = object.getRDNs(PKCSObjectIdentifiers.pkcs_9_at_emailAddress)) != null && rDNArray.length > 0) {
                    jSONObject.put("E", (Object)rDNArray[0].getFirst().getValue().toString());
                }
                object2.put("issuer", (Object)jSONObject);
            }
            object2 = object2.toString();
        }
        return object2;
    }

    public static String getSubjectDnStrFromCert(byte[] object) {
        Certificate certificate = javasafeengine.getX509FromBufferWithBC(object);
        object = certificate;
        String string = certificate.getSubject().toString();
        object = string;
        return string;
    }

    public static String getIssuerDnStrFromCert(byte[] object) {
        Certificate certificate = javasafeengine.getX509FromBufferWithBC(object);
        object = certificate;
        String string = certificate.getIssuer().toString();
        object = string;
        return string;
    }

    public static String getDetailFromCert(int n, byte[] object) {
        String string = null;
        Certificate certificate = javasafeengine.getX509FromBufferWithBC(object);
        object = certificate;
        if (certificate != null) {
            if (n == 1) {
                string = object.getVersion().toString();
            } else if (n == 2) {
                string = shecaUtils.hex2ascii(object.getSerialNumber().getValue().toByteArray());
            } else if (n == 3) {
                string = object.getSignatureAlgorithm().getAlgorithm().getId();
            } else if (n == 4) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.countryName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 5) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.organization);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 6) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.organizationalUnitName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 7) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.stateOrProvinceName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 8) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.commonName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 9) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.localityName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 10) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.pkcs_9_at_emailAddress);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 11) {
                string = object.getStartDate().getTime();
            } else if (n == 12) {
                string = object.getEndDate().getTime();
            } else if (n == 13) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.countryName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 14) {
                RDN[] rDNArray = object.getIssuer().getRDNs(X509CertificateStructure.organization);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 15) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.organizationalUnitName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 16) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.stateOrProvinceName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 17) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.commonName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 18) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.localityName);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 19) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.pkcs_9_at_emailAddress);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else if (n == 20) {
                Object object2 = object.getSubjectPublicKeyInfo();
                byte[] byArray = object2.getPublicKeyData().getBytes();
                object2 = byArray;
                string = javasafeengine.hex2b64(byArray);
            } else if (n == 21) {
                RDN[] rDNArray = object.getSubject().getRDNs(X509CertificateStructure.id_at_telephoneNumber);
                if (rDNArray != null && rDNArray.length > 0) {
                    string = rDNArray[0] != null ? rDNArray[0].getFirst().getValue().toString() : "";
                }
            } else {
                string = javasafeengine.hex2b64(object.getSignature().getBytes());
            }
        }
        return string;
    }

    public int verifyCertificate(byte[] byArray, int n) {
        return this.verifyCertificateWithCertChain(null, byArray, n);
    }

    public int verifyCertificateWithCertChainByOCSP(byte[] object, byte[] object2) {
        int n = this.a((X509Certificate)(object2 = (Object)((X509Certificate)javasafeengine.getCertificateFromBuffer(object2))), (List)(object = (Object)javasafeengine.b(object)));
        if (n == 1) {
            n = 0;
        }
        return n;
    }

    public int verifyCertificateWithCertChain(byte[] object, byte[] object2, int n) {
        int n2;
        object2 = (X509Certificate)javasafeengine.getCertificateFromBuffer((byte[])object2);
        try {
            ((X509Certificate)object2).checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return -2113667054;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return -2113667057;
        }
        List list = null;
        int n3 = -1;
        if (object != null) {
            list = javasafeengine.b(object);
            n3 = !K_SHECA_SM3WITHSM2.equalsIgnoreCase(((X509Certificate)object2).getSigAlgName()) ? javasafeengine.b(list, (X509Certificate)object2) : javasafeengine.a(list, (X509Certificate)object2);
        }
        if (n3 != -1) {
            if (n == 1) {
                int n4 = n;
                g g2 = new g();
                object = object2;
                int n5 = g2.a((X509Certificate)object);
                if (n5 != 1) {
                    shecaUtils.logger_debug(a, "verify failture from local CRL.");
                    if (n4 == 1) {
                        n5 = new h().a((X509Certificate)object);
                        if (n5 == 1) {
                            shecaUtils.logger_debug(a, "verify CRL completed,userCert not revoked");
                        } else if (n5 == -2113667050) {
                            shecaUtils.logger_debug(a, "verify CRL completed,userCert be revoked!!!");
                        } else {
                            n5 = new i().a((X509Certificate)object);
                        }
                    }
                }
                n2 = n5;
            } else {
                n2 = n == 8 ? this.a((X509Certificate)object2, list) : (n == 0 ? 1 : -2113666981);
            }
        } else {
            n2 = -2113667051;
        }
        if (n2 == 1) {
            n2 = 0;
        }
        return n2;
    }

    private static List b(byte[] object) {
        List<? extends java.security.cert.Certificate> list;
        block11: {
            list = null;
            object = new ByteArrayInputStream((byte[])object);
            try {
                try {
                    Object object2 = CertificateFactory.getInstance("X.509", "BC");
                    object2 = ((CertificateFactory)object2).generateCertPath((InputStream)object, "PKCS7");
                    list = ((CertPath)object2).getCertificates();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    try {
                        ((ByteArrayInputStream)object).close();
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((ByteArrayInputStream)object).close();
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
                throw throwable;
            }
            try {
                ((ByteArrayInputStream)object).close();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
        return list;
    }

    private static int a(List list, X509Certificate x509Certificate) {
        int n = 1;
        if (list == null) {
            return -1;
        }
        int n2 = list.size();
        if (n2 <= 0) {
            return -1;
        }
        int n3 = 0;
        while (n2 > 0) {
            X509Certificate x509Certificate2 = (X509Certificate)list.get(n3);
            try {
                byte[] byArray = x509Certificate.getTBSCertificate();
                byte[] byArray2 = x509Certificate.getSignature();
                n = javasafeengine.verifySignWithCert(x509Certificate2.getEncoded(), byArray, byArray2, K_SHECA_SM3WITHSM2);
                n = n == 0 ? 1 : -1;
                break;
            }
            catch (Exception exception) {
                n = -1;
                if (n3 == list.size()) break;
                ++n3;
            }
        }
        return n;
    }

    private static int b(List list, X509Certificate x509Certificate) {
        int n = -1;
        if (list == null) {
            return -1;
        }
        int n2 = list.size();
        if (n2 <= 0) {
            return -1;
        }
        int n3 = 0;
        while (n2 > 0) {
            ++n3;
            Object object = (X509Certificate)list.get(0);
            String string = ((X509Certificate)object).getIssuerDN().getName();
            object = ((X509Certificate)object).getSubjectDN().getName();
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            if (!string.equals(object)) {
                int n4 = list.size() - 1;
                while (n4 >= 0) {
                    arrayList.add((X509Certificate)list.get(n4));
                    --n4;
                }
                object = (X509Certificate)arrayList.get(n2 - 1);
            } else {
                object = (X509Certificate)list.get(n2 - 1);
            }
            --n2;
            try {
                object = ((java.security.cert.Certificate)object).getPublicKey();
                x509Certificate.verify((PublicKey)object);
                n = 1;
                break;
            }
            catch (Exception exception) {
                n = -1;
                if (n3 == list.size()) break;
            }
        }
        return n;
    }

    private int a(X509Certificate x509Certificate, List object) {
        int n;
        List list = object;
        Object object2 = x509Certificate;
        object = this;
        X509Certificate x509Certificate2 = null;
        object2 = ((javasafeengine)object).digest(((X509Certificate)object2).getIssuerX500Principal().getEncoded(), "SHA1", "BC");
        object2 = new String(Base64.encode((byte[])object2));
        int n2 = 0;
        while (n2 < list.size()) {
            X509Certificate x509Certificate3 = (X509Certificate)list.get(n2);
            Object object3 = ((javasafeengine)object).digest(x509Certificate3.getSubjectX500Principal().getEncoded(), "SHA1", "BC");
            String string = new String(Base64.encode((byte[])object3));
            object3 = string;
            if (string.equals(object2)) {
                x509Certificate2 = x509Certificate3;
                break;
            }
            ++n2;
        }
        object = x509Certificate2;
        try {
            n = shcaOcsp.check(x509Certificate, (X509Certificate)object);
            if (n == 0) {
                n = 1;
            }
        }
        catch (Exception exception) {
            n = -2113667046;
            exception.printStackTrace();
        }
        return n;
    }

    public static int verifySignWithRSAPublicKey(PublicKey publicKey, byte[] byArray, byte[] byArray2, String object) {
        int n = -1;
        try {
            Provider provider = Security.getProvider("BC");
            object = Signature.getInstance((String)object, provider);
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(byArray);
            boolean bl = ((Signature)object).verify(byArray2);
            n = bl ? 0 : -1;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, ((Throwable)object).toString());
        }
        return n;
    }

    public static int verifySignWithECCPublicKey(PublicKey publicKey, byte[] byArray, byte[] byArray2, String object) {
        int n = -1;
        try {
            Provider provider = Security.getProvider("BC");
            object = Signature.getInstance((String)object, provider);
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(byArray);
            boolean bl = ((Signature)object).verify(byArray2);
            n = bl ? 0 : -1;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            shecaUtils.logger_error(a, ((Throwable)object).toString());
        }
        return n;
    }

    public static boolean isDetachedSignatureInPKCS7(byte[] object) {
        boolean bl = true;
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(object);
            object = cMSSignedData;
            bl = cMSSignedData.isDetachedSignature();
        }
        catch (CMSException cMSException) {
            object = (Object)cMSException;
            cMSException.printStackTrace();
        }
        return bl;
    }

    public static String parseInfoWithPKCS7(byte[] object) {
        String string = null;
        try {
            JSONObject jSONObject = new JSONObject();
            CMSSignedData cMSSignedData = new CMSSignedData(object);
            object = cMSSignedData;
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
                Collection collection = object.getCertificates().getMatches((Selector)signerInformation.getSID());
                if (collection.isEmpty()) break;
                Object object2 = signerInformation.getSignature();
                jSONObject.put("signData", (Object)javasafeengine.hex2b64(object2));
                if (!object.isDetachedSignature()) {
                    object2 = (byte[])object.getSignedContent().getContent();
                    jSONObject.put("rawData", (Object)javasafeengine.hex2b64(object2));
                }
                jSONObject.put("signAlgo", (Object)signerInformation.getEncryptionAlgOID());
                object2 = (X509CertificateHolder)collection.iterator().next();
                jSONObject.put("signCert", (Object)javasafeengine.hex2b64(object2.getEncoded()));
            }
            string = jSONObject.toString();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static int verifySignatureWithPKCS7(byte[] object) {
        int n = -1;
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(object);
            object = cMSSignedData;
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
                Collection collection = object.getCertificates().getMatches((Selector)signerInformation.getSID());
                if (!collection.isEmpty()) {
                    collection = (X509CertificateHolder)collection.iterator().next();
                    boolean bl = signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build((X509CertificateHolder)collection));
                    int n2 = n = bl ? 0 : -1;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return n;
    }

    public static int verifySignatureWithPKCS7(byte[] object, byte[] object2) {
        int n = -1;
        try {
            CMSSignedData cMSSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray((byte[])object2), object);
            object = cMSSignedData;
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            object2 = signerInformationStore;
            object2 = signerInformationStore.getSigners().iterator();
            while (object2.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)object2.next();
                Collection collection = object.getCertificates().getMatches((Selector)signerInformation.getSID());
                if (!collection.isEmpty()) {
                    collection = (X509CertificateHolder)collection.iterator().next();
                    boolean bl = signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build((X509CertificateHolder)collection));
                    int n2 = n = bl ? 0 : -1;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return n;
    }

    public static int verifySignWithRSAPublicKey(byte[] object, byte[] byArray, byte[] byArray2, String string) {
        shecaUtils.logger_info(a, "rsa_pubkey:" + javasafeengine.hex2b64(object));
        PublicKey publicKey = javasafeengine.getRSAPublicKey(object);
        object = publicKey;
        return javasafeengine.verifySignWithRSAPublicKey(publicKey, byArray, byArray2, string);
    }

    public static int verifySignWithECCPublicKey(byte[] object, byte[] byArray, byte[] byArray2, String string) {
        shecaUtils.logger_info(a, "ecc_pubkey:" + javasafeengine.hex2b64(object));
        PublicKey publicKey = javasafeengine.getECCPublicKey(object);
        object = publicKey;
        return javasafeengine.verifySignWithECCPublicKey(publicKey, byArray, byArray2, string);
    }

    public static int verifySignWithCert(byte[] object, byte[] byArray, byte[] byArray2, String string) {
        object = javasafeengine.getCertificateFromBuffer(object).getPublicKey();
        int n = string.equalsIgnoreCase(K_SHECA_SM3WITHSM2) || string.equalsIgnoreCase("SM2withSM3") ? javasafeengine.verifySignWithSM2PublicKey((PublicKey)object, byArray, byArray2) : (string.indexOf("ECDSA") > 0 ? javasafeengine.verifySignWithECCPublicKey((PublicKey)object, byArray, byArray2, string) : javasafeengine.verifySignWithRSAPublicKey((PublicKey)object, byArray, byArray2, string));
        return n;
    }

    public static int verifySignWithCertByShcaAlgID(byte[] object, byte[] byArray, byte[] byArray2, int n) {
        object = javasafeengine.getCertificateFromBuffer((byte[])object).getPublicKey();
        shecaUtils.logger_info(a, "verifySignWithCertByShcaAlgID.signAlg=" + object.getAlgorithm());
        int n2 = object.getAlgorithm().equalsIgnoreCase("RSA") ? javasafeengine.verifySignWithRSAPublicKey((PublicKey)object, byArray, byArray2, javasafeengine.getAlgNameWithShcaAlgID(n)) : javasafeengine.verifySignWithSM2PublicKey((PublicKey)object, byArray, byArray2);
        return n2;
    }

    public static byte[] sm2Sign(byte[] object, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            ASN1Encodable[] aSN1EncodableArray;
            BigInteger bigInteger;
            Object object2;
            d.reset();
            Object object3 = javasafeengine.a(byArray);
            object3 = c.Sm2GetZ("1234567812345678".getBytes(), (ECPoint)object3);
            d.update((byte[])object3, 0, ((ECPoint)object3).length);
            d.update((byte[])object, 0, ((byte[])object).length);
            object = new byte[32];
            d.doFinal((byte[])object, 0);
            object = new BigInteger(1, (byte[])object);
            while (true) {
                object3 = new BigInteger(1, byArray2);
                object2 = javasafeengine.a(byArray);
                bigInteger = new BigInteger(1, byArray2);
                object2 = ((BigInteger)object).add(object2.getXCoord().toBigInteger());
                if (((BigInteger)(object2 = ((BigInteger)object2).mod(SM2.ecc_n))).equals(BigInteger.ZERO) || ((BigInteger)object2).add((BigInteger)object3).equals(SM2.ecc_n)) continue;
                aSN1EncodableArray = bigInteger.add(BigInteger.ONE);
                aSN1EncodableArray = aSN1EncodableArray.modInverse(SM2.ecc_n);
                bigInteger = ((BigInteger)object2).multiply(bigInteger);
                bigInteger = ((BigInteger)object3).subtract(bigInteger).mod(SM2.ecc_n);
                if (!(bigInteger = aSN1EncodableArray.multiply(bigInteger).mod(SM2.ecc_n)).equals(BigInteger.ZERO)) break;
            }
            ASN1Encodable[] aSN1EncodableArray2 = new ASN1Encodable[2];
            aSN1EncodableArray = aSN1EncodableArray2;
            aSN1EncodableArray2[0] = new ASN1Integer((BigInteger)object2);
            aSN1EncodableArray[1] = new ASN1Integer(bigInteger);
            object = new DERSequence(aSN1EncodableArray);
            byArray3 = object.getEncoded();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray3;
    }

    public static int verifySignWithSM2PublicKey(PublicKey publicKey, byte[] byArray, byte[] byArray2) {
        int n = -1;
        try {
            if (!publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                SM2ParameterSpec sM2ParameterSpec = new SM2ParameterSpec("1234567812345678".getBytes());
                Signature signature = Signature.getInstance(K_SHECA_SM3WITHSM2, "BC");
                signature.setParameter((AlgorithmParameterSpec)sM2ParameterSpec);
                signature.initVerify(publicKey);
                signature.update(byArray, 0, byArray.length);
                n = signature.verify(byArray2) ? 0 : -1;
            } else {
                shecaUtils.logger_error(a, "verifySignWithSM2PublicKey with RSA Publickey.");
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return n;
    }

    public static int verifySignWithSM2PublicKey(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return javasafeengine.verifySignWithSM2PublicKey(javasafeengine.genSM2PublicKey(byArray), byArray2, byArray3);
    }

    public static String getCertExtInfo(String object, X509Certificate x509Certificate) {
        String string = null;
        if ((object = ((String)object).startsWith("1.2.156.1.8888") ? (Object)javasafeengine.b((String)object, x509Certificate) : (Object)javasafeengine.a((String)object, x509Certificate)) != null) {
            string = new String((byte[])object);
        }
        return string;
    }

    private static byte[] a(String object, X509Certificate x509Certificate) {
        byte[] byArray = null;
        try {
            byArray = x509Certificate.getExtensionValue((String)object);
            object = (DEROctetString)DEROctetString.fromByteArray((byte[])byArray);
            byArray = object.getOctets();
            object = ASN1Primitive.fromByteArray((byte[])byArray);
            object = object.getClass().getName();
            if ("org.bouncycastle.asn1.DERPrintableString".equals(object)) {
                object = (DERPrintableString)DERPrintableString.fromByteArray((byte[])byArray);
                byArray = object.getString().getBytes();
            } else if ("org.bouncycastle.asn1.DERTaggedObject".equals(object)) {
                object = (DERTaggedObject)DERTaggedObject.fromByteArray((byte[])byArray);
                int n = object.getTagNo();
                switch (n) {
                    case 1: {
                        object = (DERUTF8String)object.getObject();
                        byArray = object.getString().getBytes();
                        break;
                    }
                    case 0: 
                    case 2: {
                        object = (DERPrintableString)object.getObject();
                        byArray = object.getString().getBytes();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    private static byte[] b(String object, X509Certificate object2) {
        byte[] byArray = null;
        try {
            shecaUtils.logger_debug(a, "getShecaCertInfo start.");
            byte[] byArray2 = object2.getExtensionValue("1.2.156.1.8888");
            object2 = byArray2;
            if (byArray2 != null) {
                int n;
                int n2 = object2[1] & 0xFF;
                int n3 = 0;
                if (n2 >= 128) {
                    n3 = n2 - 128;
                    n2 = 0;
                    n = 0;
                    while (n < n3) {
                        n2 <<= 8;
                        n2 += object2[n + 2] & 0xFF;
                        ++n;
                    }
                }
                n3 += 2;
                byte[] byArray3 = new byte[n2];
                n = 0;
                while (n < n2) {
                    byArray3[n] = (byte)object2[n3 + n];
                    ++n;
                }
                object2 = byArray3;
                object2 = new ByteArrayInputStream((byte[])object2);
                object2 = new ASN1InputStream((InputStream)object2);
                object2 = (ASN1Sequence)object2.readObject();
                object2 = new X509Extensions((ASN1Sequence)object2);
                object = new ASN1ObjectIdentifier((String)object);
                object = object2.getExtension((ASN1ObjectIdentifier)object);
                byArray = object.getValue().getOctets();
            } else {
                shecaUtils.logger_debug(a, "OID:8888 is null");
            }
            shecaUtils.logger_debug(a, "getShecaCertInfo end.");
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static String getCertInfoByOID(String string, byte[] object) {
        object = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
        return javasafeengine.getCertExtInfo(string, (X509Certificate)object);
    }

    private static X509CertificateStructure c(byte[] object) {
        X509CertificateStructure x509CertificateStructure;
        block13: {
            x509CertificateStructure = null;
            ASN1InputStream aSN1InputStream = null;
            try {
                try {
                    aSN1InputStream = new ASN1InputStream(object);
                    ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
                    object = aSN1Primitive;
                    x509CertificateStructure = X509CertificateStructure.getInstance((Object)aSN1Primitive);
                }
                catch (Exception exception) {
                    shecaUtils.logger_error(a, exception.toString());
                    exception.printStackTrace();
                    if (aSN1InputStream != null) {
                        try {
                            aSN1InputStream.close();
                        }
                        catch (IOException iOException) {
                            shecaUtils.logger_error(a, iOException.toString());
                            iOException.printStackTrace();
                        }
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (aSN1InputStream != null) {
                    try {
                        aSN1InputStream.close();
                    }
                    catch (IOException iOException) {
                        shecaUtils.logger_error(a, iOException.toString());
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                aSN1InputStream.close();
            }
            catch (IOException iOException) {
                shecaUtils.logger_error(a, iOException.toString());
                iOException.printStackTrace();
            }
        }
        return x509CertificateStructure;
    }

    public byte[] genRandomBytes(int n, String object, String object2) {
        object2 = null;
        try {
            object = SecureRandom.getInstance((String)object);
            object2 = ((SecureRandom)object).generateSeed(n);
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return object2;
    }

    protected byte[] genRandomBytes(int n) {
        return this.genRandomBytes(n, "SHA1PRNG", "BC");
    }

    public byte[] doSymEncrypt(int n, byte[] object, byte[] byArray, int n2) {
        byte[] byArray2 = null;
        if (n == 1025) {
            SM4 sM4 = new SM4();
            if ((object = sM4.File_P5pad((byte[])object, ((byte[])object).length, n2)) != null) {
                byte[] byArray3 = new byte[((byte[])object).length];
                Object object2 = object;
                int n3 = sM4.sms4((byte[])object2, ((byte[])object2).length, byArray, byArray3, 1);
                if (n3 == 0) {
                    byArray2 = byArray3;
                }
            }
        } else if (n == 6) {
            Sdbi sdbi = new Sdbi();
            try {
                byArray2 = sdbi.SDBIEncryptData((byte[])object, byArray);
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        } else if (n == 8) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            object = new ByteArrayOutputStream();
            try {
                javasafeengine.doSymmetricAlgorithmWithAlgNameBySteam("AES", true, byArray, byteArrayInputStream, (OutputStream)object);
                byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                ((OutputStream)object).flush();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        return byArray2;
    }

    public byte[] doSymDecrypt(int n, byte[] object, byte[] byArray, int n2) {
        byte[] byArray2 = null;
        if (n == 1025) {
            SM4 sM4 = new SM4();
            byte[] byArray3 = new byte[((byte[])object).length];
            int n3 = sM4.sms4((byte[])object, ((byte[])object).length, byArray, byArray3, 0);
            if (n3 == 0) {
                byArray2 = sM4.File_P5unpad(byArray3, byArray3.length, n2);
            }
        } else if (n == 6) {
            System.out.println("do SDBI start...");
            Sdbi sdbi = new Sdbi();
            try {
                byArray2 = sdbi.SDBIDecryptData((byte[])object, byArray);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        } else if (n == 8) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                javasafeengine.doSymmetricAlgorithmWithAlgNameBySteam("AES", false, byArray, byteArrayInputStream, byteArrayOutputStream);
                byArray2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.flush();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        }
        return byArray2;
    }

    public shecaEnvelopeStructure genKeyWithEPK_RSA(byte[] byArray, int n, byte[] byArray2) {
        shecaEnvelopeStructure shecaEnvelopeStructure2 = new shecaEnvelopeStructure();
        try {
            PublicKey publicKey = javasafeengine.getCertificateFromBuffer(byArray2).getPublicKey();
            byte[] byArray3 = this.genRandomBytes(16);
            shecaEnvelopeStructure2.cert = byArray2;
            shecaEnvelopeStructure2.asymAlgoID = 65536;
            shecaEnvelopeStructure2.symkeyCipher = javasafeengine.encryptByPublicKey(publicKey, byArray3);
            shecaEnvelopeStructure2.symAlgoID = n;
            shecaEnvelopeStructure2.cipherText = this.doSymEncrypt(shecaEnvelopeStructure2.symAlgoID, byArray, byArray3, 0);
            shecaEnvelopeStructure2.retCode = 0;
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return shecaEnvelopeStructure2;
    }

    protected shecaEnvelopeStructure genKeyWithEPK(byte[] byArray, int n, byte[] byArray2) {
        shecaEnvelopeStructure shecaEnvelopeStructure2 = new shecaEnvelopeStructure();
        try {
            Serializable serializable = (X509Certificate)javasafeengine.getCertificateFromBuffer(byArray2);
            serializable = ((java.security.cert.Certificate)serializable).getPublicKey();
            byte[] byArray3 = this.genRandomBytes(16);
            shecaEnvelopeStructure2.cert = byArray2;
            if (serializable.getAlgorithm().equals("RSA")) {
                shecaEnvelopeStructure2.asymAlgoID = 65536;
                shecaEnvelopeStructure2.symkeyCipher = javasafeengine.encryptByPublicKey((PublicKey)serializable, byArray3);
            } else {
                shecaEnvelopeStructure2.asymAlgoID = 131328;
                byArray2 = javasafeengine.sm2Encrypt(byArray3, (PublicKey)serializable);
                shecaEnvelopeStructure2.symkeyCipher = shecaUtils.toAns1EncodeWithSM2Cipher(byArray2);
            }
            shecaEnvelopeStructure2.symAlgoID = n;
            shecaEnvelopeStructure2.cipherText = this.doSymEncrypt(shecaEnvelopeStructure2.symAlgoID, byArray, byArray3, 0);
            shecaEnvelopeStructure2.retCode = 0;
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return shecaEnvelopeStructure2;
    }

    public byte[] encodeEnveloper(shecaEnvelopeStructure shecaEnvelopeStructure2) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Object object;
        String string;
        byte[] byArray;
        block5: {
            byArray = null;
            if (shecaEnvelopeStructure2.symAlgoID != 1025) {
                return null;
            }
            string = "1.2.156.10197.1.104";
            object = javasafeengine.getCertificateFromBuffer(shecaEnvelopeStructure2.cert);
            aSN1ObjectIdentifier = javasafeengine.c(shecaEnvelopeStructure2.cert);
            if (object != null && aSN1ObjectIdentifier != null) break block5;
            return null;
        }
        try {
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[4];
            ASN1Integer aSN1Integer = new ASN1Integer(1L);
            aSN1EncodableArray[0] = aSN1Integer;
            aSN1ObjectIdentifier = aSN1ObjectIdentifier.getSerialNumber();
            object = ((X509Certificate)object).getSubjectX500Principal().getName();
            object = new X509Name((String)object);
            object = new IssuerAndSerialNumber((X509Name)object, (ASN1Integer)aSN1ObjectIdentifier);
            aSN1EncodableArray[1] = object.toASN1Primitive();
            object = shecaEnvelopeStructure2.asymAlgoID == 131328 ? new ASN1ObjectIdentifier("1.2.156.10197.1.301.3") : new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
            aSN1EncodableArray[2] = new DERSequence((ASN1Encodable)object);
            aSN1EncodableArray[3] = new DEROctetString(shecaEnvelopeStructure2.symkeyCipher);
            object = new DERSequence(aSN1EncodableArray);
            object = new DERSet((ASN1Encodable)object);
            aSN1ObjectIdentifier = shecaEnvelopeStructure2.asymAlgoID == 65536 ? new ASN1ObjectIdentifier("1.2.840.113549.1.7.1") : new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1");
            ASN1Encodable[] aSN1EncodableArray2 = new ASN1Encodable[2];
            aSN1EncodableArray = aSN1EncodableArray2;
            aSN1EncodableArray2[0] = new ASN1ObjectIdentifier(string);
            aSN1EncodableArray[1] = shecaEnvelopeStructure2.symCipherIV != null ? new DEROctetString(shecaEnvelopeStructure2.symCipherIV) : DERNull.INSTANCE;
            string = new DERSequence(aSN1EncodableArray);
            string = AlgorithmIdentifier.getInstance((Object)string);
            string = new EncryptedContentInfo(aSN1ObjectIdentifier, (AlgorithmIdentifier)string, (ASN1OctetString)new DEROctetString(shecaEnvelopeStructure2.cipherText));
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = new ASN1Encodable[3];
            aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
            aSN1ObjectIdentifier2[0] = new ASN1Integer(0L);
            aSN1ObjectIdentifier[1] = object;
            aSN1ObjectIdentifier[2] = string;
            string = new DERSequence((ASN1Encodable[])aSN1ObjectIdentifier);
            shecaEnvelopeStructure2 = shecaEnvelopeStructure2.asymAlgoID == 65536 ? new ASN1ObjectIdentifier("1.2.840.113549.1.7.3") : new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.3");
            shecaEnvelopeStructure2 = new ContentInfo((ASN1ObjectIdentifier)shecaEnvelopeStructure2, (ASN1Encodable)string);
            shecaEnvelopeStructure2 = new DEROctetString((ASN1Encodable)shecaEnvelopeStructure2.toASN1Primitive());
            byArray = shecaEnvelopeStructure2.getOctets();
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] generatePKCS10ofRSA(KeyPair keyPair, String string) {
        return null;
    }

    public byte[] generatePKCS10ofSM2(KeyPair keyPair, String string) {
        return null;
    }

    public byte[] encodeEnveloper(byte[] object, int n, byte[] byArray) {
        byte[] byArray2 = null;
        shecaEnvelopeStructure shecaEnvelopeStructure2 = this.genKeyWithEPK((byte[])object, n, byArray);
        object = shecaEnvelopeStructure2;
        if (shecaEnvelopeStructure2.retCode == 0) {
            byArray2 = this.encodeEnveloper((shecaEnvelopeStructure)object);
        }
        return byArray2;
    }

    protected shecaEnvelopeStructure parseEnveloperBySHECAStandard(KeyPair keyPair, byte[] byArray, int n) {
        int n2;
        int n3;
        shecaEnvelopeStructure shecaEnvelopeStructure2 = new shecaEnvelopeStructure();
        if ((keyPair = (RSAPublicKey)keyPair.getPublic()) != null && (n3 = byArray.length - (n2 = (keyPair.getModulus().bitLength() + 7) / 8)) > 0 && n2 > 0) {
            byte[] byArray2 = new byte[n2];
            int n4 = 0;
            while (n4 < n2) {
                byArray2[n4] = byArray[n4];
                ++n4;
            }
            byte[] byArray3 = new byte[n3];
            int n5 = 0;
            while (n5 < n3) {
                byArray3[n5] = byArray[n5 + n2];
                ++n5;
            }
            shecaEnvelopeStructure2.asymAlgoID = 65536;
            shecaEnvelopeStructure2.symAlgoID = n;
            shecaEnvelopeStructure2.cipherText = byArray3;
            shecaEnvelopeStructure2.symkeyCipher = byArray2;
            shecaEnvelopeStructure2.retCode = 0;
        }
        return shecaEnvelopeStructure2;
    }

    protected shecaEnvelopeStructure parseEnveloperBySHECAStandard(int n, byte[] byArray, int n2) {
        shecaEnvelopeStructure shecaEnvelopeStructure2 = new shecaEnvelopeStructure();
        int n3 = byArray.length - n;
        if (n3 > 0 && n > 0) {
            byte[] byArray2 = new byte[n];
            int n4 = 0;
            while (n4 < n) {
                byArray2[n4] = byArray[n4];
                ++n4;
            }
            byte[] byArray3 = new byte[n3];
            int n5 = 0;
            while (n5 < n3) {
                byArray3[n5] = byArray[n5 + n];
                ++n5;
            }
            shecaEnvelopeStructure2.asymAlgoID = 65536;
            shecaEnvelopeStructure2.symAlgoID = n2;
            shecaEnvelopeStructure2.cipherText = byArray3;
            shecaEnvelopeStructure2.symkeyCipher = byArray2;
            shecaEnvelopeStructure2.retCode = 0;
        } else {
            System.out.println("enveloper's buffer is error. ");
        }
        return shecaEnvelopeStructure2;
    }

    protected shecaEnvelopeStructure parseEnveloper2(byte[] byArray) {
        new shecaEnvelopeStructure();
        return null;
    }

    protected shecaEnvelopeStructure parseEnveloper(byte[] object) {
        shecaEnvelopeStructure shecaEnvelopeStructure2 = new shecaEnvelopeStructure();
        try {
            object = ContentInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.2.840.113549.1.7.3");
            shecaEnvelopeStructure2.asymAlgoID = object.getContentType().equals((Object)aSN1ObjectIdentifier) ? 65536 : 131328;
            EnvelopedData envelopedData = new EnvelopedData((ASN1Sequence)((DERSequence)object.getContent()));
            object = envelopedData;
            aSN1ObjectIdentifier = (DERSet)envelopedData.getRecipientInfos();
            aSN1ObjectIdentifier = (DERSequence)aSN1ObjectIdentifier.getObjectAt(0);
            aSN1ObjectIdentifier = (DEROctetString)aSN1ObjectIdentifier.getObjectAt(3);
            shecaEnvelopeStructure2.symkeyCipher = aSN1ObjectIdentifier.getOctets();
            EncryptedContentInfo encryptedContentInfo = object.getEncryptedContentInfo();
            object = encryptedContentInfo;
            aSN1ObjectIdentifier = encryptedContentInfo.getContentEncryptionAlgorithm();
            ASN1OctetString aSN1OctetString = null;
            if (aSN1ObjectIdentifier.getParameters() != null && !aSN1ObjectIdentifier.getParameters().equals(DERNull.INSTANCE)) {
                aSN1OctetString = (ASN1OctetString)aSN1ObjectIdentifier.getParameters();
            }
            if (aSN1OctetString != null) {
                shecaEnvelopeStructure2.symCipherIV = aSN1OctetString.getOctets();
            }
            shecaEnvelopeStructure2.symAlgoID = 1025;
            object = object.getEncryptedContent();
            shecaEnvelopeStructure2.cipherText = object.getOctets();
            shecaEnvelopeStructure2.retCode = 0;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return shecaEnvelopeStructure2;
    }

    public static byte[] encryptByPublicKey(PublicKey publicKey, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            if (publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
                cipher.init(1, publicKey);
                byArray2 = cipher.doFinal(byArray);
            } else if (publicKey.getAlgorithm().equalsIgnoreCase("EC")) {
                byte[] byArray3 = javasafeengine.sm2Encrypt(byArray, publicKey);
                byArray2 = shecaUtils.toAns1EncodeWithSM2Cipher(byArray3);
            }
        }
        catch (Exception exception) {
            shecaUtils.logger_error(a, exception.toString());
        }
        return byArray2;
    }

    public static PublicKey getPublicKeyWithCert(byte[] byArray) {
        return javasafeengine.getCertificateFromBuffer(byArray).getPublicKey();
    }

    public byte[] decryptByPrivateKey(PrivateKey privateKey, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            if (privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                System.out.println("BC_VER:" + new BouncyCastleProvider().getVersion());
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
                cipher.init(2, privateKey);
                byArray2 = cipher.doFinal(byArray);
            } else if (privateKey.getAlgorithm().equalsIgnoreCase("EC")) {
                System.out.println("ECC not support in decryptByPrivateKey");
            } else {
                System.out.println("UNKNOW not support in decryptByPrivateKey");
            }
        }
        catch (Exception exception) {
            System.out.println("decryptByPrivateKey ERROR:" + exception.toString());
        }
        return byArray2;
    }

    public byte[] decryptByPrivateKeyWithSunJCE(PrivateKey privateKey, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            if (privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(2, privateKey);
                byArray2 = cipher.doFinal(byArray);
            } else if (privateKey.getAlgorithm().equalsIgnoreCase("EC")) {
                System.out.println("ECC not support in decryptByPrivateKey");
            } else {
                System.out.println("UNKNOW not support in decryptByPrivateKey");
            }
        }
        catch (Exception exception) {
            System.out.println("decryptByPrivateKey ERROR:" + exception.toString());
        }
        return byArray2;
    }

    public static String getJSONStringOfP10FromCSR(byte[] object) {
        String string;
        block31: {
            string = null;
            Object object2 = null;
            ASN1InputStream aSN1InputStream = null;
            try {
                try {
                    int n;
                    Object object3;
                    int n2;
                    object2 = new ByteArrayInputStream((byte[])object);
                    aSN1InputStream = new ASN1InputStream((InputStream)object2);
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                    object = aSN1Sequence;
                    CertificationRequest certificationRequest = CertificationRequest.getInstance((Object)aSN1Sequence);
                    shecaUtils.logger_debug(a, certificationRequest.getSignatureAlgorithm().getAlgorithm().getId());
                    byte[] byArray = certificationRequest.getCertificationRequestInfo().getEncoded();
                    byte[] byArray2 = certificationRequest.getSignature().getBytes();
                    if ("1.2.156.10197.1.501".equalsIgnoreCase(certificationRequest.getSignatureAlgorithm().getAlgorithm().getId())) {
                        n2 = 131328;
                        object3 = certificationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo().getPublicKeyData();
                        object = object3.getBytes();
                        n = javasafeengine.verifySignWithSM2PublicKey(object, byArray, byArray2);
                    } else if (certificationRequest.getSignatureAlgorithm().getAlgorithm().getId().indexOf("1.2.840.10045") >= 0) {
                        n2 = 524288;
                        object = certificationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo().getEncoded();
                        object3 = certificationRequest.getSignatureAlgorithm().getAlgorithm().toString();
                        shecaUtils.logger_debug(a, (String)object3);
                        n = javasafeengine.verifySignWithECCPublicKey(object, byArray, byArray2, (String)object3);
                    } else {
                        n2 = 65536;
                        object = certificationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo().getEncoded();
                        object3 = certificationRequest.getSignatureAlgorithm().getAlgorithm().toString();
                        shecaUtils.logger_debug(a, (String)object3);
                        n = javasafeengine.verifySignWithRSAPublicKey(object, byArray, byArray2, (String)object3);
                    }
                    if (n == 0) {
                        object3 = new JSONObject();
                        object3.put("ASYM_ALG_ID", n2);
                        if (65536 == n2) {
                            object3.put("KEYSIZE", javasafeengine.getRSAPubkeyKeySize(object));
                        }
                        object3.put("PUBKEY", (Object)javasafeengine.hex2b64(object));
                        RDN[] rDNArray = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509ObjectIdentifiers.countryName);
                        object = rDNArray;
                        if (rDNArray.length > 0) {
                            object3.put("C", (Object)object[0].getFirst().getValue().toString());
                        }
                        RDN[] rDNArray2 = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509ObjectIdentifiers.commonName);
                        object = rDNArray2;
                        if (rDNArray2.length > 0) {
                            object3.put("CN", (Object)object[0].getFirst().getValue().toString());
                        }
                        RDN[] rDNArray3 = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509ObjectIdentifiers.organization);
                        object = rDNArray3;
                        if (rDNArray3.length > 0) {
                            object3.put("O", (Object)object[0].getFirst().getValue().toString());
                        }
                        RDN[] rDNArray4 = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509ObjectIdentifiers.organizationalUnitName);
                        object = rDNArray4;
                        if (rDNArray4.length > 0) {
                            object3.put("OU", (Object)object[0].getFirst().getValue().toString());
                        }
                        RDN[] rDNArray5 = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509CertificateStructure.pkcs_9_at_emailAddress);
                        object = rDNArray5;
                        if (rDNArray5.length > 0) {
                            object3.put("E", (Object)object[0].getFirst().getValue().toString());
                        }
                        RDN[] rDNArray6 = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509ObjectIdentifiers.localityName);
                        object = rDNArray6;
                        if (rDNArray6.length > 0) {
                            object3.put("L", (Object)object[0].getFirst().getValue().toString());
                        }
                        RDN[] rDNArray7 = certificationRequest.getCertificationRequestInfo().getSubject().getRDNs(X509ObjectIdentifiers.stateOrProvinceName);
                        object = rDNArray7;
                        if (rDNArray7.length > 0) {
                            object3.put("ST", (Object)object[0].getFirst().getValue().toString());
                        }
                        string = object3.toString();
                    } else {
                        shecaUtils.logger_debug(a, String.valueOf(n));
                    }
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        object2 = iOException;
                        iOException.printStackTrace();
                    }
                    try {
                        aSN1InputStream.close();
                    }
                    catch (IOException iOException) {
                        object2 = iOException;
                        iOException.printStackTrace();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)object2).close();
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace();
                }
                try {
                    aSN1InputStream.close();
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace();
                }
                throw throwable;
            }
            try {
                ((InputStream)object2).close();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
            try {
                aSN1InputStream.close();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        return string;
    }

    public static byte[] getPublicKeyBufferFromCSR(byte[] object) {
        byte[] byArray = null;
        String string = javasafeengine.getJSONStringOfP10FromCSR(object);
        object = string;
        if (string != null) {
            JSONObject jSONObject = new JSONObject((String)object);
            object = jSONObject;
            byArray = javasafeengine.b64tohex(jSONObject.getString("PUBKEY"));
        }
        return byArray;
    }

    private static byte[] d(byte[] byArray) {
        int n = ((e.getCurve().getFieldSize() + 7) / 8 << 1) + 1;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        System.arraycopy(byArray, byArray.length - 32, byArray2, n, 32);
        System.arraycopy(byArray, n, byArray2, n + 32, byArray.length - n - 32);
        return byArray2;
    }

    private static byte[] e(byte[] byArray) {
        int n = ((e.getCurve().getFieldSize() + 7) / 8 << 1) + 1;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        System.arraycopy(byArray, n + 32, byArray2, n, byArray.length - n - 32);
        System.arraycopy(byArray, n, byArray2, byArray.length - 32, 32);
        return byArray2;
    }

    private static byte[] a(byte[] byArray, PublicKey publicKey) {
        publicKey = (BCECPublicKey)publicKey;
        publicKey = new ECPublicKeyParameters(publicKey.getQ(), f);
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKey, new SecureRandom()));
        try {
            return sM2Engine.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException);
        }
    }

    protected static byte[] sm2Encrypt(byte[] object, ECPoint eCPoint) {
        byte[] byArray = null;
        try {
            byArray = javasafeengine.d(javasafeengine.a(object, eCPoint));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    private static byte[] a(byte[] byArray, ECPoint eCPoint) {
        eCPoint = new ECPublicKeyParameters(eCPoint, f);
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)eCPoint, new SecureRandom()));
        try {
            return sM2Engine.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException);
        }
    }

    public static byte[] sm2Encrypt(byte[] object, PublicKey publicKey) {
        byte[] byArray = null;
        try {
            byArray = javasafeengine.d(javasafeengine.a(object, publicKey));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    private static byte[] a(byte[] byArray, PrivateKey privateKey) {
        privateKey = (BCECPrivateKey)privateKey;
        privateKey = new ECPrivateKeyParameters(privateKey.getD(), f);
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(false, (CipherParameters)privateKey);
        try {
            return sM2Engine.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException);
        }
    }

    private static byte[] a(byte[] byArray, BigInteger bigInteger) {
        bigInteger = new ECPrivateKeyParameters(bigInteger, f);
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(false, (CipherParameters)bigInteger);
        try {
            return sM2Engine.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new RuntimeException(invalidCipherTextException);
        }
    }

    protected byte[] sm2Decrypt(byte[] object, PrivateKey privateKey) {
        byte[] byArray = null;
        try {
            byArray = javasafeengine.a(javasafeengine.e(object), privateKey);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] sm2Decrypt(byte[] object, BigInteger bigInteger) {
        byte[] byArray = null;
        try {
            byArray = javasafeengine.a(javasafeengine.e(object), bigInteger);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] generatePKCS7ofCertChain(List list) {
        byte[] byArray = null;
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < list.size()) {
                object = (String)list.get(n);
                byte[] byArray2 = javasafeengine.b64tohex((String)object);
                object = byArray2;
                object = javasafeengine.getCertificateFromBuffer(byArray2);
                arrayList.add(object);
                ++n;
            }
            if (arrayList.size() > 0) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                object = certificateFactory.generateCertPath(arrayList);
                byArray = ((CertPath)object).getEncoded("PKCS7");
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static void doSymmetricAlgorithmWithAlgNameBySteam(String object, boolean bl, byte[] object2, InputStream inputStream, OutputStream outputStream) {
        int n;
        object2 = new SecretKeySpec((byte[])object2, (String)object);
        object = Cipher.getInstance((String)object, "BC");
        if (bl) {
            ((Cipher)object).init(1, (Key)object2);
        } else {
            ((Cipher)object).init(2, (Key)object2);
        }
        byte[] byArray = new byte[0x100000];
        object = new CipherInputStream(inputStream, (Cipher)object);
        while ((n = ((CipherInputStream)object).read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        ((CipherInputStream)object).close();
    }

    public static byte[] doSymmetricAlgoWithAlgName(String object, boolean bl, byte[] object2, byte[] byArray) {
        object2 = new SecretKeySpec((byte[])object2, (String)object);
        object = Cipher.getInstance((String)object, "BC");
        if (bl) {
            ((Cipher)object).init(1, (Key)object2);
        } else {
            ((Cipher)object).init(2, (Key)object2);
        }
        byte[] byArray2 = ((Cipher)object).doFinal(byArray);
        object = byArray2;
        return byArray2;
    }

    public static byte[] doSymmetricAlgoWithAlgName(String object, byte[] object2, boolean bl, byte[] byArray, byte[] byArray2) {
        Cipher cipher = Cipher.getInstance((String)object, "BC");
        object2 = new IvParameterSpec((byte[])object2);
        object = new SecretKeySpec(byArray, (String)object);
        if (bl) {
            cipher.init(1, (Key)object, (AlgorithmParameterSpec)object2);
        } else {
            cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        object = byArray3;
        return byArray3;
    }

    public static void doHexStrSymDecodeWithAlgNameBySteam(String object, byte[] object2, InputStream object3, OutputStream outputStream) {
        int n;
        object2 = new SecretKeySpec((byte[])object2, (String)object);
        object = Cipher.getInstance((String)object, "BC");
        ((Cipher)object).init(2, (Key)object2);
        object2 = new byte[0x100000];
        object = new CipherInputStream((InputStream)object3, (Cipher)object);
        while ((n = ((CipherInputStream)object).read((byte[])object2)) != -1) {
            object3 = shecaUtils.ascii2hex(new String((byte[])object2, 0, n));
            outputStream.write((byte[])object3, 0, ((Object)object3).length);
        }
        ((CipherInputStream)object).close();
    }

    public static void doSymmetricAlgorithmWithAlgNameByFile(String string, boolean bl, byte[] byArray, String object, String object2) {
        object = new FileInputStream((String)object);
        object2 = new FileOutputStream((String)object2);
        javasafeengine.doSymmetricAlgorithmWithAlgNameBySteam(string, bl, byArray, (InputStream)object, (OutputStream)object2);
        ((OutputStream)object2).close();
        ((FileInputStream)object).close();
    }

    public static byte[] calc128bitSymkey(String string) {
        return javasafeengine.f(string.getBytes());
    }

    public static byte[] calc128bitSymkey(byte[] byArray) {
        return javasafeengine.f(byArray);
    }

    public static byte[] calc128bitSymkeyWithB64(String object) {
        byte[] byArray = javasafeengine.b64tohex((String)object);
        object = byArray;
        return javasafeengine.f(byArray);
    }

    private static byte[] f(byte[] byArray) {
        byte[] byArray2 = null;
        if ((byArray = javasafeengine.digestMessage(byArray, "SHA256")).length == 32) {
            byArray2 = new byte[16];
            int n = 0;
            while (n < 16) {
                byArray2[n] = (byte)(byArray[n] ^ byArray[n + 16]);
                ++n;
            }
        }
        return byArray2;
    }

    public static byte[] genPKCS7enveloperWithCert(byte[] object, byte[] object2, int n) {
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator;
        byte[] byArray;
        block6: {
            byArray = null;
            object2 = new CMSProcessableByteArray(object2);
            cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            object = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
            cMSEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator((X509Certificate)object).setProvider("BC"));
            if (1 == n) {
                object = CMSAlgorithm.DES_CBC;
                break block6;
            }
            if (2 == n) {
                object = CMSAlgorithm.DES_EDE3_CBC;
                break block6;
            }
            if (8 == n) {
                object = CMSAlgorithm.AES128_CBC;
                break block6;
            }
            return null;
        }
        try {
            object = cMSEnvelopedDataGenerator.generate((CMSTypedData)object2, new JceCMSContentEncryptorBuilder((ASN1ObjectIdentifier)object).setProvider("BC").build());
            DEROctetString dEROctetString = new DEROctetString((ASN1Encodable)object.toASN1Structure().toASN1Primitive());
            object = dEROctetString;
            byArray = dEROctetString.getOctets();
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static int getRSAPubkeyKeySize(byte[] object) {
        int n = 0;
        try {
            PublicKey publicKey = javasafeengine.getRSAPublicKey(object);
            object = publicKey;
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            RSAPublicKeySpec rSAPublicKeySpec = keyFactory.getKeySpec((Key)object, RSAPublicKeySpec.class);
            object = rSAPublicKeySpec;
            n = rSAPublicKeySpec.getModulus().bitLength();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return n;
    }

    public static int getRSAPubkeyKeySizeWithCert(byte[] object) {
        int n = 0;
        try {
            PublicKey publicKey = javasafeengine.getPublicKeyWithCert(object);
            object = publicKey;
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            RSAPublicKeySpec rSAPublicKeySpec = keyFactory.getKeySpec((Key)object, RSAPublicKeySpec.class);
            object = rSAPublicKeySpec;
            n = rSAPublicKeySpec.getModulus().bitLength();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return n;
    }

    public static String getVersion() {
        return "javasafeengine-jdk6-bc160on-0.9.8.build20200730A";
    }

    public static void showVersion() {
        System.out.println(javasafeengine.getVersion());
    }

    public byte[] encodeRSAEnveloperBySHECAStandard(byte[] object, byte[] byArray) {
        byte[] byArray2 = null;
        shecaEnvelopeStructure shecaEnvelopeStructure2 = this.genKeyWithEPK_RSA((byte[])object, 6, byArray);
        object = shecaEnvelopeStructure2;
        if (shecaEnvelopeStructure2 != null && object.retCode == 0 && object.symkeyCipher.length > 0 && object.cipherText.length > 0) {
            byArray2 = shecaUtils.mergeBytes(object.symkeyCipher, object.cipherText);
        }
        return byArray2;
    }
}

