/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.shecaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.encoders.Base64;

public class shecaCsrUtils {
    public CertificationRequest makeCertReq(CertificationRequestInfo certificationRequestInfo, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString) {
        certificationRequestInfo = new CertificationRequest(certificationRequestInfo, algorithmIdentifier, dERBitString);
        return certificationRequestInfo;
    }

    public DERBitString makeSM2CertReqSign(byte[] object) {
        DERBitString dERBitString = null;
        try {
            if (((byte[])object).length == 64) {
                ASN1Integer aSN1Integer = ASN1Integer.getInstance((Object)shecaUtils.subByte(object, 0, 32));
                object = ASN1Integer.getInstance((Object)shecaUtils.subByte(object, 32, 32));
                ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[2];
                ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
                aSN1EncodableArray[0] = aSN1Integer;
                aSN1EncodableArray2[1] = (ASN1Encodable)object;
                object = ASN1Sequence.getInstance((Object)aSN1EncodableArray2);
                dERBitString = new DERBitString(object.getEncoded());
            } else if (((byte[])object).length > 64) {
                try {
                    ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])object);
                    dERBitString = new DERBitString((ASN1Encodable)aSN1Primitive);
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return dERBitString;
    }

    public DERBitString makeCertReqSign(byte[] object) {
        DERBitString dERBitString = new DERBitString(object);
        object = dERBitString;
        return dERBitString;
    }

    public AlgorithmIdentifier makeSM2CertReqAlgo() {
        return this.makeCertReqAlgo("1.2.156.10197.1.501");
    }

    public AlgorithmIdentifier makeCertReqAlgo() {
        return this.makeCertReqAlgo("1.2.840.113549.1.1.5");
    }

    public AlgorithmIdentifier makeCertReqAlgo(int n) {
        AlgorithmIdentifier algorithmIdentifier = null;
        if (n == 65538) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.113549.1.1.5");
        } else if (n == 65540) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.113549.1.1.11");
        } else if (n == 65541) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.113549.1.1.12");
        } else if (n == 65542) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.113549.1.1.13");
        } else if (n == 524290) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.10045.4.3.1");
        } else if (n == 524292) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.10045.4.3.2");
        } else if (n == 524293) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.10045.4.3.3");
        } else if (n == 524294) {
            algorithmIdentifier = this.makeCertReqAlgo("1.2.840.10045.4.3.4");
        }
        return algorithmIdentifier;
    }

    public AlgorithmIdentifier makeRSACertReqAlgo() {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"), (ASN1Encodable)DERNull.INSTANCE);
        return algorithmIdentifier;
    }

    public AlgorithmIdentifier makeCertReqAlgo(String string) {
        string = new AlgorithmIdentifier(new ASN1ObjectIdentifier(string));
        return string;
    }

    private static X509Name a(X500Principal x500Principal) {
        try {
            return new X509Principal(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't convert name");
        }
    }

    public CertificationRequestInfo makeSM2CertReqInfo(X500Principal x500Principal, byte[] byArray) {
        return this.makeSM2CertReqInfo(shecaCsrUtils.a(x500Principal), byArray);
    }

    public CertificationRequestInfo makeCertReqInfo(X500Principal x500Principal, PublicKey publicKey) {
        return this.makeCertReqInfo(shecaCsrUtils.a(x500Principal), publicKey);
    }

    public CertificationRequestInfo makeSM2CertReqInfo(String object, byte[] byArray) {
        object = new X500Principal((String)object);
        return this.makeSM2CertReqInfo((X500Principal)object, byArray);
    }

    public CertificationRequestInfo makeCertReqInfo(X500Principal x500Principal, byte[] byArray) {
        return this.makeCertReqInfo(shecaCsrUtils.a(x500Principal), byArray);
    }

    public CertificationRequestInfo makeCertReqInfo(byte[] object) {
        object = new ByteArrayInputStream((byte[])object);
        object = new ASN1InputStream((InputStream)object);
        try {
            return this.makeCertReqInfo((ASN1Sequence)object.readObject());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public CertificationRequestInfo makeCertReqInfo(ASN1Sequence aSN1Sequence) {
        aSN1Sequence = new CertificationRequestInfo(aSN1Sequence);
        return aSN1Sequence;
    }

    public CertificationRequestInfo makeCertReqInfo(X509Name x509Name, byte[] object) {
        try {
            object = new SubjectPublicKeyInfo(this.makeRSACertReqAlgo(), object);
            x509Name = new CertificationRequestInfo(x509Name, (SubjectPublicKeyInfo)object, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.valueOf(exception.toString()) + "&can't encode public key");
        }
        return x509Name;
    }

    public CertificationRequestInfo makeCertReqInfo(X509Name x509Name, PublicKey publicKey) {
        try {
            publicKey = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            x509Name = new CertificationRequestInfo(x509Name, (SubjectPublicKeyInfo)publicKey, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.valueOf(exception.toString()) + "&can't encode public key");
        }
        return x509Name;
    }

    public CertificationRequestInfo makeSM2CertReqInfo(X509Name x509Name, byte[] object) {
        try {
            object = SubjectPublicKeyInfo.getInstance((Object)object);
            x509Name = new CertificationRequestInfo(x509Name, (SubjectPublicKeyInfo)object, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.valueOf(exception.toString()) + "&can't encode public key");
        }
        return x509Name;
    }

    public String makeSM2Pkcs10String(CertificationRequestInfo object, byte[] object2) {
        object2 = this.makeSM2CertReqSign((byte[])object2);
        AlgorithmIdentifier algorithmIdentifier = this.makeSM2CertReqAlgo();
        object = this.makeCertReq((CertificationRequestInfo)object, algorithmIdentifier, (DERBitString)object2);
        object = new String(Base64.encode((byte[])object.getEncoded()));
        return object;
    }
}

