/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.javasafeengine;
import com.sheca.safeengine.shecaUtils;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.Req;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.json.JSONObject;

public class shecaOcspBuilder {
    public static final String K_SHECA_OCSP_responseStatus = "responseStatus";
    public static final String K_SHECA_OCSP_response = "response";
    public static final String K_SHECA_OCSP_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String K_SHECA_OCSP_thisUpdate = "thisUpdate";
    public static final String K_SHECA_OCSP_nextUpdate = "nextUpdate";
    public static final String K_SHECA_OCSP_certs = "certs";

    public static X509CertificateHolder[] genX509CertificateHolderListFromJSON(String object) {
        X509CertificateHolder[] x509CertificateHolderArray = null;
        try {
            object = new JSONObject((String)object);
            if (object.has(K_SHECA_OCSP_certs)) {
                object = object.getJSONArray(K_SHECA_OCSP_certs);
                x509CertificateHolderArray = new X509CertificateHolder[object.length()];
                int n = 0;
                while (n < object.length()) {
                    X509CertificateHolder x509CertificateHolder;
                    x509CertificateHolderArray[n] = x509CertificateHolder = new X509CertificateHolder(javasafeengine.b64tohex(object.getString(n)));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return x509CertificateHolderArray;
    }

    public static BasicOCSPRespBuilder genBasicOCSPRespBuilder(String string, byte[] object, byte[] object2) {
        BasicOCSPRespBuilder basicOCSPRespBuilder = null;
        try {
            OCSPReq oCSPReq = new OCSPReq(object2);
            object2 = oCSPReq;
            Req[] reqArray = oCSPReq.getRequestList();
            object2 = reqArray;
            if (reqArray.length > 0) {
                Object object3 = javasafeengine.getX509FromBufferWithBC(object);
                object = (X509Certificate)javasafeengine.getCertificateFromBuffer(object);
                JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
                jcaDigestCalculatorProviderBuilder = jcaDigestCalculatorProviderBuilder.build();
                jcaDigestCalculatorProviderBuilder = jcaDigestCalculatorProviderBuilder.get(CertificateID.HASH_SHA1);
                object = new CertificateID((DigestCalculator)jcaDigestCalculatorProviderBuilder, (X509CertificateHolder)new JcaX509CertificateHolder((X509Certificate)object), object2[0].getCertID().getSerialNumber());
                X509CertificateHolder[] x509CertificateHolderArray = shecaOcspBuilder.genX509CertificateHolderListFromJSON(string);
                object2 = x509CertificateHolderArray;
                basicOCSPRespBuilder = x509CertificateHolderArray != null && ((byte[])object2).length > 0 ? new BasicOCSPRespBuilder(new RespID(object2[0].getSubject())) : new BasicOCSPRespBuilder(new RespID(object3.getSubject()));
                string = new JSONObject(string);
                string = string.getJSONObject(K_SHECA_OCSP_response);
                object2 = shecaUtils.genDateFromStringWithFormat(string.getString(K_SHECA_OCSP_thisUpdate), K_SHECA_OCSP_DATE_FORMAT);
                object3 = shecaUtils.genDateFromStringWithFormat(string.getString(K_SHECA_OCSP_nextUpdate), K_SHECA_OCSP_DATE_FORMAT);
                int n = (string = string.getJSONObject("certStatus")).getInt("status");
                if (n == 0) {
                    basicOCSPRespBuilder.addResponse((CertificateID)object, CertificateStatus.GOOD, (Date)object2, (Date)object3);
                } else if (n == 1) {
                    string = string.getJSONObject("revokedInfo");
                    Date date = shecaUtils.genDateFromStringWithFormat(string.getString("revocationDate"), K_SHECA_OCSP_DATE_FORMAT);
                    string = new RevokedStatus(date, string.getInt("reason"));
                    basicOCSPRespBuilder.addResponse((CertificateID)object, (CertificateStatus)string, (Date)object2, (Date)object3);
                } else {
                    basicOCSPRespBuilder.addResponse((CertificateID)object, (CertificateStatus)new UnknownStatus(), (Date)object2, (Date)object3);
                }
            }
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
        }
        return basicOCSPRespBuilder;
    }
}

