/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1OctetStringParser;
import com.sansec.asn1.ASN1OutputStream;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.BEROctetString;
import com.sansec.asn1.BERTaggedObject;
import com.sansec.asn1.DEROctetString;
import com.sansec.util.Arrays;
import com.sansec.util.Strings;
import com.sansec.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1OctetString
extends ASN1Primitive
implements ASN1OctetStringParser {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        if (explicit) {
            if (!taggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return ASN1OctetString.getInstance(taggedObject.getObject());
        }
        ASN1Primitive o = taggedObject.getObject();
        if (taggedObject.isExplicit()) {
            ASN1OctetString singleSegment = ASN1OctetString.getInstance(o);
            if (taggedObject instanceof BERTaggedObject) {
                return new BEROctetString(new ASN1OctetString[]{singleSegment});
            }
            return (ASN1OctetString)new BEROctetString(new ASN1OctetString[]{singleSegment}).toDLObject();
        }
        if (o instanceof ASN1OctetString) {
            ASN1OctetString s = (ASN1OctetString)o;
            if (taggedObject instanceof BERTaggedObject) {
                return s;
            }
            return (ASN1OctetString)s.toDLObject();
        }
        if (o instanceof ASN1Sequence) {
            ASN1Sequence s = (ASN1Sequence)o;
            if (taggedObject instanceof BERTaggedObject) {
                return BEROctetString.fromSequence(s);
            }
            return (ASN1OctetString)BEROctetString.fromSequence(s).toDLObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + taggedObject.getClass().getName());
    }

    public static ASN1OctetString getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1OctetString) {
            return (ASN1OctetString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1OctetString.getInstance(ASN1OctetString.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct OCTET STRING from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1OctetString) {
            return (ASN1OctetString)primitive;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public ASN1OctetString(byte[] string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = string;
    }

    @Override
    public InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public ASN1OctetStringParser parser() {
        return this;
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString other = (ASN1OctetString)o;
        return Arrays.areEqual(this.string, other.string);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DEROctetString(this.string);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DEROctetString(this.string);
    }

    @Override
    abstract void encode(ASN1OutputStream var1, boolean var2) throws IOException;

    public String toString() {
        return "#" + Strings.fromByteArray(Hex.encode(this.string));
    }
}

