/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1ApplicationSpecificParser;
import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1ParsingException;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1StreamParser;
import com.sansec.asn1.BERApplicationSpecific;
import java.io.IOException;

public class BERApplicationSpecificParser
implements ASN1ApplicationSpecificParser {
    private final int tag;
    private final ASN1StreamParser parser;

    BERApplicationSpecificParser(int tag, ASN1StreamParser parser) {
        this.tag = tag;
        this.parser = parser;
    }

    @Override
    public ASN1Encodable readObject() throws IOException {
        return this.parser.readObject();
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return new BERApplicationSpecific(this.tag, this.parser.readVector());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException(e.getMessage(), e);
        }
    }
}

