/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.cms;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1Set;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.asn1.cms.EncryptedContentInfo;
import java.util.Enumeration;

public class SignedAndEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private ASN1Set digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;

    public static SignedAndEnvelopedData getInstance(Object o) {
        if (o == null || o instanceof SignedAndEnvelopedData) {
            return (SignedAndEnvelopedData)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SignedAndEnvelopedData((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory:".concat(String.valueOf(String.valueOf(o.getClass().getName()))));
    }

    public SignedAndEnvelopedData(ASN1Integer _version, ASN1Set _recipientInfos, ASN1Set _digestAlgorithms, EncryptedContentInfo _encryptedContentInfo, ASN1Set _certificates, ASN1Set _crls, ASN1Set _signerInfos) {
        this.version = _version;
        this.recipientInfos = _recipientInfos;
        this.digestAlgorithms = _digestAlgorithms;
        this.encryptedContentInfo = _encryptedContentInfo;
        this.certificates = _certificates;
        this.crls = _crls;
        this.signerInfos = _signerInfos;
    }

    public SignedAndEnvelopedData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (ASN1Integer)e.nextElement();
        this.recipientInfos = (ASN1Set)e.nextElement();
        this.digestAlgorithms = (ASN1Set)e.nextElement();
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(e.nextElement());
        while (e.hasMoreElements()) {
            ASN1Object o = (ASN1Object)e.nextElement();
            if (o instanceof DERTaggedObject) {
                DERTaggedObject tagged = (DERTaggedObject)o;
                switch (tagged.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance(tagged, false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(tagged, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value ".concat(String.valueOf(String.valueOf(tagged.getTagNo()))));
                    }
                }
                continue;
            }
            this.signerInfos = (ASN1Set)o;
        }
    }

    public ASN1Integer getVersin() {
        return this.version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCrls() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.recipientInfos);
        v.add(this.digestAlgorithms);
        v.add(this.encryptedContentInfo);
        if (this.certificates != null) {
            v.add(new DERTaggedObject(false, 0, this.certificates));
        }
        if (this.crls != null) {
            v.add(new DERTaggedObject(false, 1, this.crls));
        }
        v.add(this.signerInfos);
        return new DERSequence(v);
    }
}

