/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.crmf;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.asn1.crmf.POPOSigningKeyInput;
import com.sansec.asn1.x509.AlgorithmIdentifier;

public class POPOSigningKey
extends ASN1Object {
    private POPOSigningKeyInput poposkInput;
    private AlgorithmIdentifier algorithmIdentifier;
    private DERBitString signature;

    private POPOSigningKey(ASN1Sequence seq) {
        int index = 0;
        if (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj;
            if ((tagObj = (ASN1TaggedObject)seq.getObjectAt(index++)).getTagNo() != 0) {
                throw new IllegalArgumentException("Unknown POPOSigningKeyInput tag: " + tagObj.getTagNo());
            }
            this.poposkInput = POPOSigningKeyInput.getInstance(tagObj.getObject());
        }
        this.algorithmIdentifier = AlgorithmIdentifier.getInstance(seq.getObjectAt(index++));
        this.signature = DERBitString.getInstance(seq.getObjectAt(index));
    }

    public static POPOSigningKey getInstance(Object o) {
        if (o instanceof POPOSigningKey) {
            return (POPOSigningKey)o;
        }
        if (o != null) {
            return new POPOSigningKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public static POPOSigningKey getInstance(ASN1TaggedObject obj, boolean explicit) {
        return POPOSigningKey.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public POPOSigningKey(POPOSigningKeyInput poposkIn, AlgorithmIdentifier aid, DERBitString signature) {
        this.poposkInput = poposkIn;
        this.algorithmIdentifier = aid;
        this.signature = signature;
    }

    public POPOSigningKeyInput getPoposkInput() {
        return this.poposkInput;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        if (this.poposkInput != null) {
            v.add(new DERTaggedObject(false, 0, this.poposkInput));
        }
        v.add(this.algorithmIdentifier);
        v.add(this.signature);
        return new DERSequence(v);
    }
}

