/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class DSASignStructure
extends ASN1Object {
    private BigInteger r;
    private BigInteger s;

    public static DSASignStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DSASignStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DSASignStructure getInstance(Object obj) {
        if (obj instanceof DSASignStructure) {
            return (DSASignStructure)obj;
        }
        if (obj != null) {
            return new DSASignStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DSASignStructure(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public DSASignStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.r = ((ASN1Integer)e.nextElement()).getValue();
        this.s = ((ASN1Integer)e.nextElement()).getValue();
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.getR()));
        v.add(new ASN1Integer(this.getS()));
        return new DERSequence(v);
    }
}

