/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.pkcs.DSASignStructure;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.util.BigIntegerUitl;
import java.math.BigInteger;

public class DSAStructureUtil {
    public static DSASignStructure convert(BigInteger r, BigInteger s) {
        r = BigIntegerUitl.toPositiveInteger(r.toByteArray());
        s = BigIntegerUitl.toPositiveInteger(s.toByteArray());
        DSASignStructure signatureSt = new DSASignStructure(r, s);
        return signatureSt;
    }

    public static DSASignStructure convert(byte[] br, byte[] bs) {
        BigInteger r = BigIntegerUitl.toPositiveInteger(br);
        BigInteger s = BigIntegerUitl.toPositiveInteger(bs);
        DSASignStructure signatureSt = new DSASignStructure(r, s);
        return signatureSt;
    }

    public static DSASignStructure convert(DSArefSignature signature) {
        BigInteger r = BigIntegerUitl.toPositiveInteger(signature.getR());
        BigInteger s = BigIntegerUitl.toPositiveInteger(signature.getS());
        DSASignStructure signatureSt = new DSASignStructure(r, s);
        return signatureSt;
    }

    public static DSArefSignature convert(int bits, DSASignStructure signatureSt) {
        DSArefSignature signature = null;
        signature = bits == 1024 ? new DSArefSignature(BigIntegerUitl.asUnsignedNByteArray(signatureSt.getR(), 20), BigIntegerUitl.asUnsignedNByteArray(signatureSt.getS(), 20)) : new DSArefSignature(BigIntegerUitl.asUnsigned32ByteArray(signatureSt.getR()), BigIntegerUitl.asUnsigned32ByteArray(signatureSt.getS()));
        return signature;
    }
}

