/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM2CipherStructure
extends ASN1Object {
    private BigInteger x;
    private BigInteger y;
    private byte[] C;
    private byte[] M;

    public static SM2CipherStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2CipherStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SM2CipherStructure getInstance(Object obj) {
        if (obj instanceof SM2CipherStructure) {
            return (SM2CipherStructure)obj;
        }
        if (obj != null) {
            return new SM2CipherStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SM2CipherStructure(BigInteger x, BigInteger y, byte[] C, byte[] M) {
        this.x = x;
        this.y = y;
        this.C = C;
        this.M = M;
    }

    public SM2CipherStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.x = ((ASN1Integer)e.nextElement()).getValue();
        this.y = ((ASN1Integer)e.nextElement()).getValue();
        this.M = ((DEROctetString)e.nextElement()).getOctets();
        this.C = ((DEROctetString)e.nextElement()).getOctets();
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getC() {
        return this.C;
    }

    public byte[] getM() {
        return this.M;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.getX()));
        v.add(new ASN1Integer(this.getY()));
        v.add(new DEROctetString(this.getM()));
        v.add(new DEROctetString(this.getC()));
        return new DERSequence(v);
    }
}

