/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.util.BigIntegerUitl;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM2PrivateKeyStructure
extends ASN1Object {
    private ASN1Sequence seq;

    public static SM2PrivateKeyStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2PrivateKeyStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SM2PrivateKeyStructure getInstance(Object obj) {
        if (obj instanceof SM2PrivateKeyStructure) {
            return (SM2PrivateKeyStructure)obj;
        }
        if (obj != null) {
            return new SM2PrivateKeyStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SM2PrivateKeyStructure(ASN1Sequence seq) {
        this.seq = seq;
    }

    public SM2PrivateKeyStructure(BigInteger key) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(1L));
        v.add(new ASN1Integer(key));
        this.seq = new DERSequence(v);
    }

    public SM2PrivateKeyStructure(BigInteger key, ASN1Encodable parameters) {
        this(key, null, parameters);
    }

    public SM2PrivateKeyStructure(BigInteger key, DERBitString publicKey, ASN1Encodable parameters) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(1L));
        v.add(new ASN1Integer(key));
        if (parameters != null) {
            v.add(new DERTaggedObject(true, 0, parameters));
        }
        if (publicKey != null) {
            v.add(new DERTaggedObject(true, 1, publicKey));
        }
        this.seq = new DERSequence(v);
    }

    public BigInteger getKey() {
        ASN1Encodable key = this.seq.getObjectAt(1);
        if (key instanceof ASN1Integer) {
            return ((ASN1Integer)key).getValue();
        }
        if (key instanceof ASN1OctetString) {
            return BigIntegerUitl.toPositiveInteger(((ASN1OctetString)key).getOctets());
        }
        return null;
    }

    public DERBitString getPublicKey() {
        return (DERBitString)this.getObjectInTag(1);
    }

    public ASN1Object getParameters() {
        return this.getObjectInTag(0);
    }

    private ASN1Object getObjectInTag(int tagNo) {
        Enumeration e = this.seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject tag;
            ASN1Primitive obj = (ASN1Primitive)e.nextElement();
            if (!(obj instanceof ASN1TaggedObject) || (tag = (ASN1TaggedObject)obj).getTagNo() != tagNo) continue;
            return tag.getObject().toASN1Primitive();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

