/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DEROctetString;
import com.sansec.util.BigIntegerUitl;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import java.util.Enumeration;

public class SM2PublicKeyStructure
extends ASN1Object {
    private BigInteger x;
    private BigInteger y;

    public static SM2PublicKeyStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2PublicKeyStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SM2PublicKeyStructure getInstance(Object obj) {
        if (obj instanceof SM2PublicKeyStructure) {
            return (SM2PublicKeyStructure)obj;
        }
        if (obj != null) {
            return new SM2PublicKeyStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SM2PublicKeyStructure(ECPoint Q) {
        this.x = Q.getAffineX();
        this.y = Q.getAffineY();
    }

    public SM2PublicKeyStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        byte[] octets = ((DEROctetString)e.nextElement()).getOctets();
        byte[] tmp = new byte[32];
        System.arraycopy(octets, 0, tmp, 0, 32);
        this.x = BigIntegerUitl.toPositiveInteger(tmp);
        System.arraycopy(octets, 32, tmp, 0, 32);
        this.y = BigIntegerUitl.toPositiveInteger(tmp);
    }

    public SM2PublicKeyStructure(DERBitString publicKeyData) {
        byte[] octets = publicKeyData.getBytes();
        byte[] tmp = new byte[32];
        System.arraycopy(octets, 1, tmp, 0, 32);
        this.x = BigIntegerUitl.toPositiveInteger(tmp);
        System.arraycopy(octets, 33, tmp, 0, 32);
        this.y = BigIntegerUitl.toPositiveInteger(tmp);
    }

    public SM2PublicKeyStructure(byte[] octets) {
        byte[] tmp = new byte[32];
        System.arraycopy(octets, 1, tmp, 0, 32);
        this.x = BigIntegerUitl.toPositiveInteger(tmp);
        System.arraycopy(octets, 33, tmp, 0, 32);
        this.y = BigIntegerUitl.toPositiveInteger(tmp);
    }

    public ECPoint getQ() {
        return new ECPoint(this.x, this.y);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        byte[] tmp = new byte[64];
        System.arraycopy(BigIntegerUitl.asUnsigned32ByteArray(this.x), 0, tmp, 0, 32);
        System.arraycopy(BigIntegerUitl.asUnsigned32ByteArray(this.y), 0, tmp, 32, 32);
        return new DEROctetString(tmp);
    }

    public byte[] getPublicKey() {
        byte[] publicKey = new byte[65];
        publicKey[0] = 4;
        System.arraycopy(BigIntegerUitl.asUnsigned32ByteArray(this.x), 0, publicKey, 1, 32);
        System.arraycopy(BigIntegerUitl.asUnsigned32ByteArray(this.y), 0, publicKey, 33, 32);
        return publicKey;
    }
}

