/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.tsp;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.DERSequence;
import com.sansec.util.Arrays;

public class PartialHashtree
extends ASN1Object {
    private ASN1Sequence values;

    public static PartialHashtree getInstance(Object obj) {
        if (obj instanceof PartialHashtree) {
            return (PartialHashtree)obj;
        }
        if (obj != null) {
            return new PartialHashtree(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PartialHashtree(ASN1Sequence values) {
        for (int i = 0; i != values.size(); ++i) {
            if (values.getObjectAt(i) instanceof DEROctetString) continue;
            throw new IllegalArgumentException("unknown object in constructor: " + values.getObjectAt(i).getClass().getName());
        }
        this.values = values;
    }

    public PartialHashtree(byte[] values) {
        this(new byte[][]{values});
    }

    public PartialHashtree(byte[][] values) {
        ASN1EncodableVector v = new ASN1EncodableVector(values.length);
        for (int i = 0; i != values.length; ++i) {
            v.add(new DEROctetString(Arrays.clone(values[i])));
        }
        this.values = new DERSequence(v);
    }

    public byte[][] getValues() {
        byte[][] rv = new byte[this.values.size()][];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = Arrays.clone(ASN1OctetString.getInstance(this.values.getObjectAt(i)).getOctets());
        }
        return rv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

