/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.agreement;

import com.sansec.crypto.BasicAgreement;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.math.ec.ECPoint;
import java.math.BigInteger;

public class SwECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;
    private ISDSCrypto crypto = SwxaDeviceFactory.getInstance();

    @Override
    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        if (!pub.getParameters().equals(this.key.getParameters())) {
            throw new IllegalStateException("ECDH public key has wrong domain parameters");
        }
        ECPoint Q = pub.getQ();
        byte[] x = Q.getAffineXCoord().toBigInteger().toByteArray();
        byte[] y = Q.getAffineYCoord().toBigInteger().toByteArray();
        ECDSArefPublicKey refPublicKey = new ECDSArefPublicKey(this.key.getBits(), this.key.getCurveType(), x, y);
        byte[] out = null;
        try {
            if (this.key.getKeyIndex() > 0) {
                out = this.crypto.ecdhAgreement(this.key.getKeyIndex(), this.key.getKeyType(), refPublicKey.encode());
            } else {
                byte[] d = this.key.getD().toByteArray();
                ECDSArefPrivateKey refPrivateKey = new ECDSArefPrivateKey(this.key.getBits(), this.key.getCurveType(), d);
                out = this.crypto.ecdhAgreement(refPrivateKey.encode(), refPublicKey.encode());
            }
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException("ECDH algorithm key agreement calculateAgreement error", e);
        }
        return new BigInteger(out);
    }
}

