/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.ec;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.ec.ECDecryptor;
import com.sansec.crypto.ec.ECPair;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint tmp = pair.getX().multiply(this.key.getD());
        return pair.getY().subtract(tmp).normalize();
    }
}

