/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DSA;
import com.sansec.crypto.params.DSAKeyParameters;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.signers.DSAHsmSigner;
import com.sansec.crypto.signers.DSAKCalculator;
import com.sansec.crypto.signers.DSASigner;
import com.sansec.jce.provider.SwxaProvider;
import java.math.BigInteger;

public class DSASignatureEncoding
implements DSA {
    private DSASigner engine;
    private DSAKeyParameters key;
    private final DSAKCalculator kCalculator;

    public DSASignatureEncoding() {
        this.kCalculator = null;
    }

    public DSASignatureEncoding(DSAKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (DSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (DSAKeyParameters)param;
        }
        this.engine = new DSASigner(this.kCalculator);
        if (SwxaProvider.isHsm(this.key.isPrivate(), "Signature", "DSA")) {
            this.engine = new DSAHsmSigner();
        }
        this.engine.init(forEncryption, param);
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        return this.engine.generateSignature(message);
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        return this.engine.verifySignature(message, r, s);
    }
}

