/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DSA;
import com.sansec.crypto.params.ECKeyParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.signers.DSAKCalculator;
import com.sansec.crypto.signers.ECDSAHsmSigner;
import com.sansec.crypto.signers.ECDSASigner;
import com.sansec.jce.provider.SwxaProvider;
import java.math.BigInteger;

public class ECDSASignatureEncoding
implements DSA {
    private DSA engine;
    private ECKeyParameters key;
    private DSAKCalculator kCalculator;

    public ECDSASignatureEncoding() {
    }

    public ECDSASignatureEncoding(DSAKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
        this.engine = new ECDSASigner();
        if (this.kCalculator != null) {
            this.engine = new ECDSASigner(this.kCalculator);
        }
        if (SwxaProvider.isHsm(this.key.isPrivate(), "Signature", "ECDSA")) {
            this.engine = new ECDSAHsmSigner();
        }
        this.engine.init(forSigning, param);
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        return this.engine.generateSignature(message);
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        return this.engine.verifySignature(message, r, s);
    }
}

