/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.signers.SM2HsmSigner;
import com.sansec.crypto.signers.SM2Signer;
import com.sansec.jce.provider.SwxaProvider;

public class SM2SignatureEncoding {
    private SM2Signer engine;
    private SM2KeyParameters key;
    public static final int MAX_BLOCK_LENGTH = 32;

    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SM2KeyParameters)rParam.getParameters();
        } else {
            this.key = (SM2KeyParameters)param;
        }
        this.engine = new SM2Signer();
        if (SwxaProvider.isHsm(this.key.isPrivate(), "Signature", "SM2")) {
            this.engine = new SM2HsmSigner();
        }
        this.engine.init(forEncryption, param);
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        return baseBlockSize;
    }

    public byte[] sign(byte[] in, int inOff, int inLen) {
        byte[] block = new byte[32];
        if (inLen > 32) {
            System.arraycopy(in, inOff, block, 0, 32);
        } else {
            System.arraycopy(in, inOff, block, 0, inLen);
        }
        return this.engine.sign(block, 0, block.length);
    }

    public boolean verify(byte[] sigBytes, int sigOff, int sigLen, byte[] in, int inOff, int inLen) {
        byte[] block = new byte[32];
        if (inLen > 32) {
            System.arraycopy(in, inOff, block, 0, 32);
        } else {
            System.arraycopy(in, inOff, block, 0, inLen);
        }
        if (sigLen > this.engine.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        boolean flag = this.engine.verify(block, 0, block.length, sigBytes, sigOff, sigLen);
        return flag;
    }
}

