/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.BufferedBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.KeyParser;
import com.sansec.crypto.Mac;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.IESEngine;
import com.sansec.crypto.generators.EphemeralKeyPairGenerator;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.IESParameters;
import com.sansec.crypto.params.ParametersWithIV;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECIESrefCipher;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.math.ec.ECPoint;
import java.util.Arrays;
import java.util.logging.Logger;

public class IESHsmEngine
extends IESEngine {
    boolean forEncryption;
    AsymmetricKeyParameter privParam;
    AsymmetricKeyParameter pubParam;
    IESParameters param;
    private ISDSCrypto device;
    private Logger logger = CryptoLogger.logger;
    private byte[] IV;

    @Override
    public void init(boolean forEncryption, CipherParameters privParam, CipherParameters pubParam, CipherParameters params) {
        throw new RuntimeException("Unsupport exception");
    }

    @Override
    public void init(AsymmetricKeyParameter publicKey, CipherParameters params, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.forEncryption = true;
        this.pubParam = publicKey;
        this.extractParams(params);
    }

    @Override
    public void init(AsymmetricKeyParameter privateKey, CipherParameters params, KeyParser publicKeyParser) {
        this.forEncryption = false;
        this.privParam = privateKey;
        this.extractParams(params);
    }

    private void extractParams(CipherParameters params) {
        if (params instanceof ParametersWithIV) {
            this.IV = ((ParametersWithIV)params).getIV();
            this.param = (IESParameters)((ParametersWithIV)params).getParameters();
        } else {
            this.IV = null;
            this.param = (IESParameters)params;
        }
    }

    @Override
    public BufferedBlockCipher getCipher() {
        return this.cipher;
    }

    @Override
    public Mac getMac() {
        return this.mac;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] input = Arrays.copyOfRange(in, inOff, inOff + inLen);
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        if (this.forEncryption) {
            byte[] y;
            byte[] x;
            ECPublicKeyParameters key = (ECPublicKeyParameters)this.pubParam;
            int keyIndex = key.getKeyIndex();
            int keyType = key.getKeyType();
            int keyLength = key.getBits() / 8;
            ECIESrefCipher refCipher = null;
            if (keyIndex == 0) {
                ECPoint Q = key.getQ();
                x = Q.getAffineXCoord().toBigInteger().toByteArray();
                y = Q.getAffineYCoord().toBigInteger().toByteArray();
                ECDSArefPublicKey refPublicKey = new ECDSArefPublicKey(key.getBits(), key.getCurveType(), x, y);
                try {
                    refCipher = device.ecdsaEncrypt(refPublicKey, input);
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("External ECDSA public key encrypt error", e);
                }
            }
            try {
                refCipher = device.ecdsaEncrypt(keyIndex, keyType, input);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Internal ECDSA public key encrypt error", e);
            }
            byte[] out = new byte[1 + keyLength * 2 + refCipher.cLength + 20];
            out[0] = 4;
            x = refCipher.getX();
            y = refCipher.getY();
            byte[] c = refCipher.getC();
            byte[] m = refCipher.getM();
            int offset = 1;
            System.arraycopy(x, x.length - keyLength, out, offset, keyLength);
            System.arraycopy(y, y.length - keyLength, out, offset += keyLength, keyLength);
            System.arraycopy(c, 0, out, offset += keyLength, c.length);
            System.arraycopy(m, 44, out, offset += c.length, 20);
            return out;
        }
        ECPrivateKeyParameters key = (ECPrivateKeyParameters)this.privParam;
        int keyIndex = key.getKeyIndex();
        int keyType = key.getKeyType();
        int keyLength = key.getBits() / 8;
        int mode = 0;
        int offset = 1;
        byte[] x = new byte[80];
        System.arraycopy(input, offset, x, x.length - keyLength, keyLength);
        byte[] y = new byte[80];
        System.arraycopy(input, offset += keyLength, y, y.length - keyLength, keyLength);
        int cLength = input.length - (keyLength * 2 + 1 + 20);
        byte[] c = new byte[cLength];
        System.arraycopy(input, offset += keyLength, c, 0, cLength);
        byte[] m = new byte[64];
        System.arraycopy(input, offset += cLength, m, 44, 20);
        ECIESrefCipher refCipher = new ECIESrefCipher(mode, x, y, c, m);
        if (keyIndex == 0) {
            byte[] d = key.getD().toByteArray();
            ECDSArefPrivateKey refPrivateKey = new ECDSArefPrivateKey(key.getBits(), key.getCurveType(), d);
            try {
                return device.ecdsaDecrypt(refPrivateKey, refCipher);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("External ECDSA private key decrypt error", e);
            }
        }
        try {
            return device.ecdsaDecrypt(keyIndex, keyType, refCipher);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Internal ECDSA private key decrypt error", e);
        }
    }
}

