/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.engines.RSAEngine;
import com.sansec.crypto.engines.RSAHsmEngine;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAEngine rsaEngine;
    private RSAKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = new SecureRandom();
        }
        this.rsaEngine = new RSAEngine();
        if (SwxaProvider.isHsm(this.key.isPrivate(), "Cipher", "RSA")) {
            this.rsaEngine = new RSAHsmEngine();
        }
        this.rsaEngine.init(forEncryption, param);
    }

    @Override
    public int getInputBlockSize() {
        return this.rsaEngine.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.rsaEngine.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        byte[] result;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        byte[] input = this.rsaEngine.convertInput(in, inOff, inLen);
        if (this.key instanceof RSAPrivateCrtKeyParameters && !(this.rsaEngine instanceof RSAHsmEngine)) {
            RSAEngine core = this.rsaEngine;
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger e = k.getPublicExponent();
            if (e != null) {
                BigInteger rInv;
                BigInteger bInput = new BigInteger(1, input);
                BigInteger m = k.getModulus();
                BigInteger r = BigIntegers.createRandomInRange(ONE, m.subtract(ONE), this.random);
                BigInteger blindedInput = r.modPow(e, m).multiply(bInput).mod(m);
                BigInteger blindedResult = core.processBlock(blindedInput);
                BigInteger bResult = blindedResult.multiply(rInv = r.modInverse(m)).mod(m);
                if (!bInput.equals(bResult.modPow(e, m))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
                result = bResult.toByteArray();
            } else {
                result = this.rsaEngine.processBlock(input);
            }
        } else {
            result = this.rsaEngine.processBlock(input);
        }
        return this.rsaEngine.convertOutput(result);
    }
}

