/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.asn1.pkcs.SM2CipherStructure;
import com.sansec.asn1.pkcs.SM2StructureUtil;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.SM2Engine;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.PrintUtil;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.encoders.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SM2HsmEngine
extends SM2Engine {
    private Logger logger = CryptoLogger.logger;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SM2KeyParameters)rParam.getParameters();
        } else {
            this.key = (SM2KeyParameters)param;
        }
        this.forEncryption = forEncryption;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 engine not initialised");
        }
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        byte[] out = null;
        byte[] dataInput = in;
        int keyIndex = this.key.getKeyIndex();
        int keyType = this.key.getKeyType();
        if (this.key instanceof SM2PrivateKeyParameters) {
            SM2PrivateKeyParameters keyParam = (SM2PrivateKeyParameters)this.key;
            SM2refCipher cipher = null;
            try {
                SM2CipherStructure sm2Cipher = SM2CipherStructure.getInstance(dataInput);
                cipher = SM2StructureUtil.convert(sm2Cipher);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    try {
                        this.logger.log(Level.INFO, "SM2 ciphertext is " + new String(Hex.encode(dataInput), "utf-8"));
                    }
                    catch (UnsupportedEncodingException e1) {
                        throw new RuntimeCryptoException("dataInput to hex utf-8 string error.");
                    }
                }
                throw new RuntimeCryptoException("SM2 ciphertext structure error", e);
            }
            if (keyIndex == 0) {
                byte[] d = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getD());
                SM2refPrivateKey privateKey = new SM2refPrivateKey(d);
                try {
                    out = device.sm2Decrypt(privateKey, cipher);
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "sm2PrivateKeyDecryption error");
                        this.logger.log(Level.INFO, privateKey.toString());
                        this.logger.log(Level.INFO, cipher.toString());
                    }
                    throw new RuntimeCryptoException("External SM2 private key decryption error", e);
                }
            }
            try {
                out = device.sm2Decrypt(keyIndex, keyType, cipher);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "sm2PrivateKeyDecryption error");
                    this.logger.log(Level.INFO, cipher.toString());
                }
                throw new RuntimeCryptoException("Internal SM2 private key decryption error", e);
            }
            return out;
        }
        SM2KeyParameters keyParam = this.key;
        SM2refCipher cipher = null;
        if (keyIndex == 0) {
            byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
            byte[] y = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getY());
            SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
            try {
                cipher = device.sm2Encrypt(publicKey, dataInput);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "sm2PublicKeyEncryption error");
                    this.logger.log(Level.INFO, "data input :\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External SM2 public key encryption error", e);
            }
        }
        try {
            cipher = device.sm2Encrypt(keyIndex, keyType, in);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "sm2PublicKeyEncryption error");
                this.logger.log(Level.INFO, "data input :\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal SM2 public key encryption error", e);
        }
        SM2CipherStructure cipherSt = SM2StructureUtil.convert(cipher);
        try {
            out = cipherSt.getEncoded("DER");
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "SM2Cipher getEncoded error");
            }
            throw new RuntimeCryptoException("Construct SM2 ciphertext structure error", e);
        }
        return out;
    }
}

