/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.AsymmetricCipherKeyPairGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.SM2Soft;
import com.sansec.crypto.params.SM2KeyGenerationParameters;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class SM2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SM2KeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        if (strength != 256) {
            throw new RuntimeCryptoException("Invalid key length,strength = " + strength);
        }
        SM2Soft sm2 = new SM2Soft();
        byte[] keyPair = sm2.generateKeyPair();
        byte[] d = Arrays.copyOfRange(keyPair, 0, 32);
        byte[] x = Arrays.copyOfRange(keyPair, 32, 64);
        byte[] y = Arrays.copyOfRange(keyPair, 64, 96);
        BigInteger biD = new BigInteger(1, d);
        BigInteger biX = new BigInteger(1, x);
        BigInteger biY = new BigInteger(1, y);
        return new AsymmetricCipherKeyPair(new SM2KeyParameters(strength, false, biX, biY), new SM2PrivateKeyParameters(strength, biX, biY, biD));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (SM2KeyGenerationParameters)param;
        if (this.param.getStrength() >= 65536) {
            throw new InvalidParameterException("Key length too long error");
        }
    }
}

