/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.params;

import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.math.ec.ECConstants;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.Arrays;
import java.math.BigInteger;

public class ECDomainParameters
implements ECConstants {
    private final ECCurve curve;
    private final byte[] seed;
    private final ECPoint G;
    private final BigInteger n;
    private final BigInteger h;
    private BigInteger hInv = null;

    public ECDomainParameters(X9ECParameters x9) {
        this(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n) {
        this(curve, G, n, ONE, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n, BigInteger h) {
        this(curve, G, n, h, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n, BigInteger h, byte[] seed) {
        this.curve = curve;
        this.G = G.normalize();
        this.n = n;
        this.h = h;
        this.seed = seed;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ECDomainParameters) {
            ECDomainParameters other = (ECDomainParameters)obj;
            return this.curve.equals(other.curve) && this.G.equals(other.G) && this.n.equals(other.n) && this.h.equals(other.h);
        }
        return false;
    }

    public int hashCode() {
        int hc = this.curve.hashCode();
        hc *= 37;
        hc ^= this.G.hashCode();
        hc *= 37;
        hc ^= this.n.hashCode();
        hc *= 37;
        return hc ^= this.h.hashCode();
    }
}

