/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.params;

import com.sansec.crypto.params.AsymmetricKeyParameter;
import java.math.BigInteger;

public class RSAKeyParameters
extends AsymmetricKeyParameter {
    private BigInteger modulus;
    private BigInteger exponent;
    private String keyLabel;

    public RSAKeyParameters(int bits, boolean isPrivate, BigInteger modulus, BigInteger exponent) {
        super(isPrivate, bits);
        this.modulus = modulus;
        this.exponent = exponent;
    }

    public RSAKeyParameters(boolean isPrivate, BigInteger modulus, BigInteger exponent) {
        super(isPrivate);
        this.modulus = modulus;
        this.exponent = exponent;
    }

    public RSAKeyParameters(int keyIndex, int keyType, int bits, boolean isPrivate, BigInteger modulus, BigInteger exponent) {
        super(isPrivate, keyIndex, keyType, bits);
        this.exponent = exponent;
        this.modulus = modulus;
    }

    public RSAKeyParameters(int keyIndex, String keyLabel, int keyType, int bits, boolean isPrivate, BigInteger modulus, BigInteger exponent) {
        super(isPrivate, keyIndex, keyType, bits);
        this.keyLabel = keyLabel;
        this.exponent = exponent;
        this.modulus = modulus;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getExponent() {
        return this.exponent;
    }

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }
}

