/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.params;

import com.sansec.crypto.params.AsymmetricKeyParameter;
import java.math.BigInteger;
import java.security.spec.ECPoint;

public class SM2KeyParameters
extends AsymmetricKeyParameter {
    private int bits;
    private BigInteger x;
    private BigInteger y;

    public SM2KeyParameters(int keyIndex, int keyType, int bits, boolean isPrivateKey, BigInteger x, BigInteger y) {
        super(isPrivateKey, keyIndex, keyType, bits);
        this.x = x;
        this.y = y;
        this.bits = bits;
    }

    public SM2KeyParameters(int bits, boolean isPrivateKey, BigInteger x, BigInteger y) {
        super(isPrivateKey, bits);
        this.bits = bits;
        this.x = x;
        this.y = y;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public ECPoint getW() {
        if (this.x != null && this.y != null) {
            return new ECPoint(this.x, this.y);
        }
        return null;
    }
}

