/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.signers;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.signers.ECDSASigner;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefSignature;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.BigIntegerUitl;
import java.math.BigInteger;

public class ECDSAHsmSigner
extends ECDSASigner {
    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        ECDSArefSignature signature = null;
        byte[] dataInput = message;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        int keyIndex = this.key.getKeyIndex();
        int keyType = this.key.getKeyType();
        if (keyIndex == 0) {
            byte[] d = ((ECPrivateKeyParameters)this.key).getD().toByteArray();
            ECDSArefPrivateKey refPrivateKey = new ECDSArefPrivateKey(this.key.getBits(), this.key.getCurveType(), d);
            try {
                signature = device.ecdsaSign(refPrivateKey, dataInput);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("External ECDSA private key sign error", e);
            }
        }
        try {
            signature = device.ecdsaSign(keyIndex, keyType, dataInput);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Internal ECDSA private key sign error", e);
        }
        BigInteger r = BigIntegerUitl.toPositiveInteger(signature.getR());
        BigInteger s = BigIntegerUitl.toPositiveInteger(signature.getS());
        return new BigInteger[]{r, s};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        int rsBits = (this.key.getBits() + 7) / 8;
        byte[] rb = BigIntegerUitl.asUnsignedNByteArray(r, rsBits);
        byte[] sb = BigIntegerUitl.asUnsignedNByteArray(s, rsBits);
        ECDSArefSignature signature = new ECDSArefSignature(rb, sb);
        int keyIndex = this.key.getKeyIndex();
        int keyType = this.key.getKeyType();
        if (keyIndex == 0) {
            ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
            byte[] x = Q.getAffineXCoord().toBigInteger().toByteArray();
            byte[] y = Q.getAffineYCoord().toBigInteger().toByteArray();
            ECDSArefPublicKey refPublicKey = new ECDSArefPublicKey(this.key.getBits(), this.key.getCurveType(), x, y);
            try {
                return device.ecdsaVerify(refPublicKey, message, signature);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("External ECDSA public key verification error", e);
            }
        }
        try {
            return device.ecdsaVerify(keyIndex, keyType, message, signature);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Internal ECDSA public key verification error", e);
        }
    }
}

