/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.signers;

import com.sansec.asn1.pkcs.SM2SignStructure;
import com.sansec.asn1.pkcs.SM2StructureUtil;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.crypto.signers.SM2Signer;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.PrintUtil;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.encoders.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SM2HsmSigner
extends SM2Signer {
    private Logger logger = CryptoLogger.logger;

    @Override
    public void init(boolean forSign, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SM2KeyParameters)rParam.getParameters();
        } else {
            this.key = (SM2KeyParameters)param;
        }
        this.forSign = forSign;
    }

    @Override
    public byte[] sign(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        SM2refSignature signature = null;
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        SM2PrivateKeyParameters keyParam = (SM2PrivateKeyParameters)this.key;
        int keyIndex = keyParam.getKeyIndex();
        int keyType = keyParam.getKeyType();
        if (keyIndex == 0) {
            byte[] d = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getD());
            SM2refPrivateKey privateKey = new SM2refPrivateKey(d);
            try {
                signature = device.sm2Sign(privateKey, dataInput);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "sm2Sign error");
                    this.logger.log(Level.INFO, "privatekey:\n" + privateKey.toString());
                    this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External SM2 private key signature error", e);
            }
        }
        try {
            signature = device.sm2Sign(keyIndex, keyType, dataInput);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "sm2Sign error");
                this.logger.log(Level.INFO, "keyIndex:\n" + keyIndex);
                this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal SM2 private key signature error", e);
        }
        SM2SignStructure signatureSt = SM2StructureUtil.convert(signature);
        try {
            return signatureSt.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeCryptoException("Construct SM2 ciphertext structure error", e);
        }
    }

    @Override
    public boolean verify(byte[] in, int inOff, int inLen, byte[] sigBytes, int sigOff, int sigLen) {
        boolean flag;
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        SM2KeyParameters keyParam = this.key;
        int keyIndex = keyParam.getKeyIndex();
        int keyType = keyParam.getKeyType();
        SM2refSignature signature = null;
        try {
            SM2SignStructure signatureSt = SM2SignStructure.getInstance(sigBytes);
            signature = SM2StructureUtil.convert(signatureSt);
        }
        catch (Exception e) {
            String str = null;
            try {
                str = new String(Hex.encode(dataInput), "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeCryptoException("dataInput to utf-8 error", e1);
            }
            this.logger.log(Level.INFO, "SM2 signed data:" + str);
            throw new RuntimeCryptoException("SM2 signature structure error", e);
        }
        if (keyIndex == 0) {
            byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
            byte[] y = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getY());
            SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
            try {
                flag = device.sm2Verify(publicKey, dataInput, signature);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "sm2Verify error", e);
                    this.logger.log(Level.INFO, "publicKey:\n" + publicKey.toString());
                    this.logger.log(Level.INFO, "signature:\n" + signature.toString());
                    this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External SM2 public key verification error", e);
            }
        }
        try {
            flag = device.sm2Verify(keyIndex, keyType, dataInput, signature);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "sm2Verify error", e);
                this.logger.log(Level.INFO, "keyIndex:\n" + keyIndex);
                this.logger.log(Level.INFO, "signature:\n" + signature.toString());
                this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal SM2 public key verification error", e);
        }
        return flag;
    }
}

