/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.signers;

import com.sansec.asn1.pkcs.SM2SignStructure;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.SM2Soft;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.util.BigIntegerUitl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class SM2Signer {
    private static final int SIGNATURE_LENGTH = 247;
    protected SM2KeyParameters key;
    protected boolean forSign;

    public void init(boolean forSign, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SM2KeyParameters)rParam.getParameters();
        } else {
            this.key = (SM2KeyParameters)param;
        }
        if (this.key.getKeyIndex() != 0 && this.key.getKeyType() != 0) {
            throw new InvalidParameterException("not support internal key");
        }
        this.forSign = forSign;
    }

    public int getInputBlockSize() {
        if (this.forSign) {
            return this.key.getBits() / 8;
        }
        return 247;
    }

    public int getOutputBlockSize() {
        if (this.forSign) {
            return 247;
        }
        return 1;
    }

    public byte[] sign(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        SM2PrivateKeyParameters keyParam = (SM2PrivateKeyParameters)this.key;
        int keyIndex = keyParam.getKeyIndex();
        if (keyIndex != 0) {
            throw new RuntimeCryptoException("Unsupport internal operation");
        }
        byte[] dataInput = new byte[inLen];
        System.arraycopy(in, inOff, dataInput, 0, inLen);
        SM2Soft device = new SM2Soft();
        byte[] d = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getD());
        byte[] signature = null;
        try {
            signature = device.sign(d, dataInput);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("SM2 sign error ", e);
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(signature, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signature, 32, 64));
        SM2SignStructure signatureSt = new SM2SignStructure(r, s);
        try {
            return signatureSt.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeCryptoException("SM2 sign struct der encode error ", e);
        }
    }

    public boolean verify(byte[] in, int inOff, int inLen, byte[] sigBytes, int sigOff, int sigLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        SM2KeyParameters keyParam = this.key;
        byte[] dataInput = new byte[inLen];
        System.arraycopy(in, inOff, dataInput, 0, inLen);
        byte[] signInput = new byte[sigLen];
        System.arraycopy(sigBytes, sigOff, signInput, 0, sigLen);
        SM2Soft device = new SM2Soft();
        byte[] signature = null;
        SM2SignStructure structure = SM2SignStructure.getInstance(signInput);
        signature = new byte[64];
        byte[] r = BigIntegerUitl.asUnsigned32ByteArray(structure.getR());
        byte[] s = BigIntegerUitl.asUnsigned32ByteArray(structure.getS());
        System.arraycopy(r, 0, signature, 0, 32);
        System.arraycopy(s, 0, signature, 32, 32);
        byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
        byte[] y = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getY());
        byte[] publicKey = new byte[64];
        System.arraycopy(x, 0, publicKey, 0, 32);
        System.arraycopy(y, 0, publicKey, 32, 32);
        boolean flag = false;
        try {
            flag = device.verify(publicKey, dataInput, signature);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("SM2 verify error ", e);
        }
        return flag;
    }
}

