/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.tls;

import com.sansec.crypto.Mac;
import com.sansec.crypto.StreamCipher;
import com.sansec.crypto.engines.ChaCha7539Engine;
import com.sansec.crypto.macs.Poly1305;
import com.sansec.crypto.params.KeyParameter;
import com.sansec.crypto.params.ParametersWithIV;
import com.sansec.crypto.tls.TlsCipher;
import com.sansec.crypto.tls.TlsContext;
import com.sansec.crypto.tls.TlsFatalAlert;
import com.sansec.crypto.tls.TlsUtils;
import com.sansec.util.Arrays;
import com.sansec.util.Pack;
import java.io.IOException;

public class Chacha20Poly1305
implements TlsCipher {
    private static final byte[] ZEROES = new byte[15];
    protected TlsContext context;
    protected ChaCha7539Engine encryptCipher;
    protected ChaCha7539Engine decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public Chacha20Poly1305(TlsContext context) throws IOException {
        KeyParameter decryptKey;
        KeyParameter encryptKey;
        if (!TlsUtils.isTLSv12(context)) {
            throw new TlsFatalAlert(80);
        }
        this.context = context;
        int cipherKeySize = 32;
        int fixed_iv_length = 12;
        int key_block_size = 2 * cipherKeySize + 2 * fixed_iv_length;
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        KeyParameter client_write_key = new KeyParameter(key_block, offset, cipherKeySize);
        KeyParameter server_write_key = new KeyParameter(key_block, offset += cipherKeySize, cipherKeySize);
        byte[] client_write_IV = Arrays.copyOfRange(key_block, offset += cipherKeySize, offset + fixed_iv_length);
        byte[] server_write_IV = Arrays.copyOfRange(key_block, offset += fixed_iv_length, offset + fixed_iv_length);
        if ((offset += fixed_iv_length) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        this.encryptCipher = new ChaCha7539Engine();
        this.decryptCipher = new ChaCha7539Engine();
        if (context.isServer()) {
            encryptKey = server_write_key;
            decryptKey = client_write_key;
            this.encryptIV = server_write_IV;
            this.decryptIV = client_write_IV;
        } else {
            encryptKey = client_write_key;
            decryptKey = server_write_key;
            this.encryptIV = client_write_IV;
            this.decryptIV = server_write_IV;
        }
        this.encryptCipher.init(true, new ParametersWithIV(encryptKey, this.encryptIV));
        this.decryptCipher.init(false, new ParametersWithIV(decryptKey, this.decryptIV));
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - 16;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        KeyParameter macKey = this.initRecord(this.encryptCipher, true, seqNo, this.encryptIV);
        byte[] output = new byte[len + 16];
        this.encryptCipher.processBytes(plaintext, offset, len, output, 0);
        byte[] additionalData = this.getAdditionalData(seqNo, type, len);
        byte[] mac = this.calculateRecordMAC(macKey, additionalData, output, 0, len);
        System.arraycopy(mac, 0, output, len, mac.length);
        return output;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] receivedMAC;
        int plaintextLength;
        byte[] additionalData;
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        KeyParameter macKey = this.initRecord(this.decryptCipher, false, seqNo, this.decryptIV);
        byte[] calculatedMAC = this.calculateRecordMAC(macKey, additionalData = this.getAdditionalData(seqNo, type, plaintextLength = len - 16), ciphertext, offset, plaintextLength);
        if (!Arrays.constantTimeAreEqual(calculatedMAC, receivedMAC = Arrays.copyOfRange(ciphertext, offset + plaintextLength, offset + len))) {
            throw new TlsFatalAlert(20);
        }
        byte[] output = new byte[plaintextLength];
        this.decryptCipher.processBytes(ciphertext, offset, plaintextLength, output, 0);
        return output;
    }

    protected KeyParameter initRecord(StreamCipher cipher, boolean forEncryption, long seqNo, byte[] iv) {
        byte[] nonce = this.calculateNonce(seqNo, iv);
        cipher.init(forEncryption, new ParametersWithIV(null, nonce));
        return this.generateRecordMACKey(cipher);
    }

    protected byte[] calculateNonce(long seqNo, byte[] iv) {
        byte[] nonce = new byte[12];
        TlsUtils.writeUint64(seqNo, nonce, 4);
        for (int i = 0; i < 12; ++i) {
            int n = i;
            nonce[n] = (byte)(nonce[n] ^ iv[i]);
        }
        return nonce;
    }

    protected KeyParameter generateRecordMACKey(StreamCipher cipher) {
        byte[] firstBlock = new byte[64];
        cipher.processBytes(firstBlock, 0, firstBlock.length, firstBlock, 0);
        KeyParameter macKey = new KeyParameter(firstBlock, 0, 32);
        Arrays.fill(firstBlock, (byte)0);
        return macKey;
    }

    protected byte[] calculateRecordMAC(KeyParameter macKey, byte[] additionalData, byte[] buf, int off, int len) {
        Poly1305 mac = new Poly1305();
        mac.init(macKey);
        this.updateRecordMACText(mac, additionalData, 0, additionalData.length);
        this.updateRecordMACText(mac, buf, off, len);
        this.updateRecordMACLength(mac, additionalData.length);
        this.updateRecordMACLength(mac, len);
        byte[] output = new byte[mac.getMacSize()];
        mac.doFinal(output, 0);
        return output;
    }

    protected void updateRecordMACLength(Mac mac, int len) {
        byte[] longLen = Pack.longToLittleEndian((long)len & 0xFFFFFFFFL);
        mac.update(longLen, 0, longLen.length);
    }

    protected void updateRecordMACText(Mac mac, byte[] buf, int off, int len) {
        mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            mac.update(ZEROES, 0, 16 - partial);
        }
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] additional_data = new byte[13];
        TlsUtils.writeUint64(seqNo, additional_data, 0);
        TlsUtils.writeUint8(type, additional_data, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), additional_data, 9);
        TlsUtils.writeUint16(len, additional_data, 11);
        return additional_data;
    }
}

